<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
$routes->get('/', 'News::index');
$routes->get('/about', 'Page::about');
$routes->get('/contact', 'Page::contact');
$routes->get('/faqs', 'Page::faqs');
$routes->get('/pegawai/(:segment)', 'Pegawai::detail/$1');
$routes->match(['GET','POST'], '/login', 'Auth::login');
$routes->get('/logout', 'Auth::logout');
$routes->get('/news', 'News::index');
$routes->get('/news/(:any)', 'News::viewNews/$1');
$routes->group('admin', ['filter' => 'auth'], function ($routes) {
    $routes->get('/', 'AdminDashboard::index');
    $routes->get('dashboard', 'AdminDashboard::index');
    $routes->get('news', 'NewsAdmin::index');
    $routes->get('news/(:segment)/preview', 'NewsAdmin::preview/$1');
    $routes->add('news/new', 'NewsAdmin::create');
    $routes->add('news/(:segment)/edit', 'NewsAdmin::edit/$1');
    $routes->post('news/(:segment)/delete', 'NewsAdmin::delete/$1');
    $routes->post('news/(:segment)/publish', 'NewsAdmin::publish/$1');
    $routes->post('news/(:segment)/draft', 'NewsAdmin::draft/$1');
    $routes->get('perusahaan', 'PerusahaanAdmin::index');
    $routes->get('perusahaan/(:segment)/photo', 'PerusahaanAdmin::photo/$1');
    $routes->get('perusahaan/(:segment)/preview', 'PerusahaanAdmin::preview/$1');
    $routes->add('perusahaan/new', 'PerusahaanAdmin::create');
    $routes->add('perusahaan/(:segment)/edit', 'PerusahaanAdmin::edit/$1');
    $routes->post('perusahaan/(:segment)/delete', 'PerusahaanAdmin::delete/$1');
});
