# Portal Berita CodeIgniter 4

Aplikasi web portal berita yang dibangun dengan CodeIgniter 4, dilengkapi dengan admin panel untuk mengelola berita dan data pegawai.

## Fitur

### Public (Frontend)
- ✅ Halaman Beranda dengan highlight berita
- ✅ Halaman Berita dengan search dan filter
- ✅ Halaman Detail Berita
- ✅ Halaman About dengan struktur organisasi
- ✅ Halaman Contact
- ✅ Halaman FAQs
- ✅ Responsive design dengan UI/UX modern

### Admin Panel
- ✅ Dashboard dengan statistik
- ✅ Manajemen Berita (CRUD)
- ✅ Manajemen Data Pegawai (CRUD)
- ✅ Upload gambar untuk berita dan foto pegawai
- ✅ Status publikasi berita (Published/Draft)
- ✅ Preview berita sebelum publish

## Teknologi

- **Framework**: CodeIgniter 4
- **PHP**: 8.1+
- **Database**: MySQL/MariaDB
- **Frontend**: Bootstrap 5, Custom CSS
- **Security**: CSRF Protection, XSS Protection, Input Validation

## Struktur Proyek

```
CI4DIMAS/
├── app/
│   ├── Config/          # Konfigurasi aplikasi
│   ├── Controllers/      # Controller untuk handling request
│   ├── Models/          # Model untuk database interaction
│   ├── Views/           # Template/view files
│   ├── Filters/         # Filter untuk authentication, dll
│   └── Libraries/       # Custom libraries (Widget)
├── public/              # Public accessible files
│   ├── css/            # Stylesheet
│   ├── js/             # JavaScript
│   ├── media/          # Media files (banner, logo)
│   └── uploads/        # Uploaded files (news, pegawai)
├── writable/           # Writable directory (logs, cache, session)
└── vendor/             # Composer dependencies
```

## Instalasi

### 1. Clone Repository

```bash
git clone <repository-url>
cd CI4DIMAS
```

### 2. Install Dependencies

```bash
composer install
```

### 3. Konfigurasi Environment

Buat file `.env` dari template (jika ada) atau buat manual:

```env
CI_ENVIRONMENT = development
app.baseURL = 'http://localhost:8080/'

# Database
database.default.hostname = localhost
database.default.database = your_database
database.default.username = your_username
database.default.password = your_password
database.default.DBDriver = MySQLi
```

### 4. Generate Encryption Key

```bash
php spark key:generate
```

### 5. Setup Database

```bash
# Jalankan migration
php spark migrate

# (Opsional) Jalankan seeder untuk admin default
php spark db:seed AdminSeeder
```

### 6. Set Permissions

```bash
chmod -R 775 writable/
chmod -R 755 public/uploads/
```

### 7. Akses Aplikasi

- **Public**: `http://localhost:8080/`
- **Admin**: `http://localhost:8080/admin`
- **Login**: Gunakan kredensial dari seeder atau buat admin baru

## Dokumentasi

- [SECURITY.md](SECURITY.md) - Panduan keamanan dan checklist sebelum hosting
- [DEPLOYMENT.md](DEPLOYMENT.md) - Panduan deployment ke production

## Keamanan

Aplikasi ini telah dilengkapi dengan:

- ✅ **XSS Protection**: Semua output di-escape menggunakan `esc()`
- ✅ **CSRF Protection**: Semua form dilindungi dengan CSRF token
- ✅ **SQL Injection Protection**: Menggunakan Query Builder
- ✅ **Input Validation**: Validasi ketat untuk semua input
- ✅ **File Upload Security**: Validasi tipe, ukuran, dan MIME type
- ✅ **Authentication**: Admin routes dilindungi dengan filter

Lihat [SECURITY.md](SECURITY.md) untuk detail lengkap.

## Best Practices yang Diterapkan

1. **Code Organization**
   - PSR-4 autoloading
   - Separation of concerns (MVC pattern)
   - Reusable components (Widget library)

2. **Security**
   - Input validation dan sanitization
   - Output escaping
   - CSRF protection
   - Secure file upload

3. **Code Quality**
   - Konsisten formatting
   - Dokumentasi PHPDoc
   - Error handling yang proper
   - Logging untuk debugging

4. **Performance**
   - Query optimization
   - Cache management
   - Asset versioning untuk cache busting

## Kontributor

- Developer: [Nama Developer]
- Framework: CodeIgniter 4

## License

[Specify your license here]

## Support

Untuk pertanyaan atau masalah, silakan buat issue di repository atau hubungi tim development.




