<?= $this->extend('layout/post_layout') ?>

<?= $this->section('content') ?>

<h2 class="section-heading" style="text-align: center; margin-bottom: 2rem;">Histori Kompetensi Akademik</h2>

<div class="profile-mini-header" style="display: flex; align-items: center; gap: 2rem; background: rgba(255, 255, 255, 0.4); backdrop-filter: blur(15px); border-radius: 30px; padding: 1.5rem; margin-bottom: 3rem; border: 1px solid rgba(255, 255, 255, 0.5);">
    <div style="width: 100px; height: 100px; border-radius: 20px; overflow: hidden; border: 4px solid #fff; box-shadow: 0 10px 20px rgba(0,0,0,0.1);">
        <img src="<?= base_url('profile_image.php') ?>" alt="Imanoel" style="width: 100%; height: 100%; object-fit: cover;">
    </div>
    <div>
        <h3 style="color: var(--primary); font-weight: 800; margin: 0;">Imanoel</h3>
        <p style="color: var(--muted); margin: 0; font-size: 0.9rem; text-transform: uppercase; letter-spacing: 1px;">Kandidat Profesional & Arsitek Sistem</p>
    </div>
</div>

<div class="search-filter-section" style="background: rgba(255, 255, 255, 0.4); backdrop-filter: blur(10px); border-radius: 30px; padding: 2rem;">
    <form method="get" action="<?= base_url('education') ?>" class="w-100">
        <div class="row align-items-center">
            <div class="col-md-5 mb-2">
                <input type="text" name="search" class="form-control" placeholder="Query institusi atau spesialisasi jurusan..." value="<?= esc($search) ?>" style="border-radius: 20px; border: 1px solid var(--sky-blue);">
            </div>
            <div class="col-md-3 mb-2">
                <select name="filter_jenjang" class="form-control" style="border-radius: 20px;">
                    <option value="">Semua Jenjang</option>
                    <option value="SD" <?= $filter_jenjang == 'SD' ? 'selected' : '' ?>>SD (Sekolah Dasar)</option>
                    <option value="SMP" <?= $filter_jenjang == 'SMP' ? 'selected' : '' ?>>SMP (Menengah Pertama)</option>
                    <option value="SMA" <?= $filter_jenjang == 'SMA' ? 'selected' : '' ?>>SMA/SMK (Menengah Atas)</option>
                    <option value="S1" <?= $filter_jenjang == 'S1' ? 'selected' : '' ?>>S1 (Sarjana)</option>
                    <option value="S2" <?= $filter_jenjang == 'S2' ? 'selected' : '' ?>>S2 (Magister)</option>
                </select>
            </div>
            <div class="col-md-2 mb-2">
                <button type="submit" class="btn btn-primary w-100" style="border-radius: 20px; background: var(--primary);">Filter</button>
            </div>
            <div class="col-md-2 mb-2">
                <a href="<?= base_url('education') ?>" class="btn btn-secondary w-100" style="border-radius: 20px;">Reset</a>
            </div>
        </div>
    </form>
</div>

<div class="sorting-links" style="justify-content: center; margin: 2rem 0;">
    <span style="color: var(--muted); margin-right: 1rem;">Metode Pengurutan Histori:</span>
    <a href="<?= base_url('education?sort_by=tahun_mulai&sort_order=' . ($sort_by == 'tahun_mulai' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_jenjang=' . urlencode($filter_jenjang)) ?>">
        Linimasa Kronologis <?= $sort_by == 'tahun_mulai' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
    </a>
    <a href="<?= base_url('education?sort_by=nama_sekolah&sort_order=' . ($sort_by == 'nama_sekolah' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_jenjang=' . urlencode($filter_jenjang)) ?>">
        Entitas Institusi <?= $sort_by == 'nama_sekolah' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
    </a>
</div>

<?php if (empty($educations)): ?>
    <div class="alert alert-info" style="border-radius: 20px; text-align: center; background: var(--primary-fade); color: var(--primary-strong); border: none;">
        Data histori akademik tidak tersedia dalam basis data.
    </div>
<?php else: ?>
    <div class="education-timeline" style="border-left: 3px solid var(--sky-blue); padding-left: 3rem; margin-top: 3rem;">
        <?php foreach ($educations as $edu): ?>
            <div class="timeline-item" style="margin-bottom: 4rem; position: relative;">
                <div style="position: absolute; left: -3.65rem; top: 0; width: 24px; height: 24px; background: #fff; border: 4px solid var(--primary); border-radius: 50%; box-shadow: 0 0 0 10px rgba(125, 211, 252, 0.2);"></div>
                <div class="timeline-card" style="border: none; background: rgba(255,255,255,0.6); backdrop-filter: blur(15px); border-radius: 30px; padding: 2rem; transition: transform 0.3s ease; box-shadow: 0 10px 30px rgba(0,0,0,0.03);">
                    <div class="timeline-meta" style="color: var(--secondary); font-weight: 700; font-size: 0.9rem; margin-bottom: 0.75rem; display: flex; align-items: center; gap: 1rem;">
                        <span style="background: var(--primary-fade); padding: 0.25rem 0.75rem; border-radius: 10px;"><?= esc($edu['tahun_mulai']) ?> — <?= esc($edu['tahun_selesai']) ?></span>
                        <span style="opacity: 0.6;">|</span>
                        <span><?= esc($edu['jenjang']) ?></span>
                    </div>
                    <h3 class="timeline-title" style="color: var(--primary); font-weight: 800; font-size: 1.6rem; margin-bottom: 0.5rem;"><?= esc($edu['nama_sekolah']) ?></h3>
                    <p style="color: var(--text); font-weight: 600; font-size: 1.1rem; margin-bottom: 1rem;">
                        <span style="color: var(--muted); font-weight: 400;">Spesialisasi:</span> <?= esc($edu['jurusan']) ?> 
                        <?php if (!empty($edu['ipk'])): ?>
                            <span style="margin-left: 1rem; color: var(--secondary); background: var(--secondary-soft); padding: 0.1rem 0.6rem; border-radius: 8px; font-size: 0.9rem;">IPK: <?= esc($edu['ipk']) ?></span>
                        <?php endif; ?>
                    </p>
                    <?php if (!empty($edu['keterangan'])): ?>
                        <p style="color: var(--text); line-height: 1.7; opacity: 0.8; margin-top: 1rem; padding: 1rem; background: rgba(255,255,255,0.4); border-radius: 15px; border-left: 4px solid var(--sky-blue);"><?= esc($edu['keterangan']) ?></p>
                    <?php endif; ?>
                </div>
            </div>
        <?php endforeach; ?>
    </div>

    <div class="mt-4 d-flex justify-content-center">
        <?= $pager->links() ?>
    </div>
<?php endif; ?>

<?= $this->endSection() ?>



