<?= $this->extend('layout/post_layout') ?>

<?= $this->section('content') ?>

<h2 class="section-heading" style="text-align: center; margin-bottom: 2rem;">Log Aktivitas Sistem & Pengembangan</h2>

<div class="profile-mini-header" style="display: flex; align-items: center; gap: 2rem; background: rgba(255, 255, 255, 0.4); backdrop-filter: blur(15px); border-radius: 30px; padding: 1.5rem; margin-bottom: 3rem; border: 1px solid rgba(255, 255, 255, 0.5);">
    <div style="width: 100px; height: 100px; border-radius: 20px; overflow: hidden; border: 4px solid #fff; box-shadow: 0 10px 20px rgba(0,0,0,0.1);">
        <img src="<?= base_url('profile_image.php') ?>" alt="Imanoel" style="width: 100%; height: 100%; object-fit: cover;">
    </div>
    <div>
        <h3 style="color: var(--primary); font-weight: 800; margin: 0;">Imanoel</h3>
        <p style="color: var(--muted); margin: 0; font-size: 0.9rem; text-transform: uppercase; letter-spacing: 1px;">Jurnal aktivitas dan rekam jejak teknis</p>
    </div>
</div>

<div class="search-filter-section" style="background: rgba(255, 255, 255, 0.4); backdrop-filter: blur(10px); border-radius: 30px; padding: 2rem;">
    <form method="get" action="<?= base_url('activities') ?>" class="w-100">
        <div class="row align-items-center">
            <div class="col-md-5 mb-2">
                <input type="text" name="search" class="form-control" placeholder="Pencarian string aktivitas atau deskripsi..." value="<?= esc($search) ?>" style="border-radius: 20px; border: 1px solid var(--sky-blue);">
            </div>
            <div class="col-md-3 mb-2">
                <input type="date" name="filter_tanggal" class="form-control" value="<?= esc($filter_tanggal) ?>" style="border-radius: 20px;">
            </div>
            <div class="col-md-2 mb-2">
                <button type="submit" class="btn btn-primary w-100" style="border-radius: 20px; background: var(--primary);">Filter Log</button>
            </div>
            <div class="col-md-2 mb-2">
                <a href="<?= base_url('activities') ?>" class="btn btn-secondary w-100" style="border-radius: 20px;">Reset</a>
            </div>
        </div>
    </form>
</div>

<div class="sorting-links" style="justify-content: center; margin: 2rem 0;">
    <span style="color: var(--muted); margin-right: 1rem;">Pengurutan Data Aktivitas:</span>
    <a href="<?= base_url('activities?sort_by=tanggal&sort_order=' . ($sort_by == 'tanggal' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_tanggal=' . urlencode($filter_tanggal)) ?>">
        Timestamp Kejadian <?= $sort_by == 'tanggal' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
    </a>
    <a href="<?= base_url('activities?sort_by=nama_aktivitas&sort_order=' . ($sort_by == 'nama_aktivitas' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_tanggal=' . urlencode($filter_tanggal)) ?>">
        Label Deskripsi Kegiatan <?= $sort_by == 'nama_aktivitas' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
    </a>
</div>

<?php if (empty($activities)): ?>
    <div class="alert alert-info" style="border-radius: 20px; text-align: center; background: var(--primary-fade); color: var(--primary-strong); border: none;">
        Log aktivitas tidak ditemukan untuk parameter yang ditentukan.
    </div>
<?php else: ?>
    <div class="row">
    <?php foreach ($activities as $activity): ?>
        <div class="col-md-12 mb-4">
            <article class="activity-card" style="border: none; background: rgba(255,255,255,0.6); backdrop-filter: blur(15px); border-radius: 30px; overflow: hidden; display: flex; flex-direction: row; gap: 2rem; padding: 2rem;">
                <div class="activity-media" style="flex: 0 0 300px;">
                    <?php if (!empty($activity['foto'])): ?>
                        <img src="<?= base_url($activity['foto']) ?>" alt="Foto Aktivitas" style="width: 100%; height: 200px; object-fit: cover; border-radius: 20px; box-shadow: 0 10px 20px rgba(0,0,0,0.05);">
                    <?php endif; ?>
                    <?php if (!empty($activity['video'])): ?>
                        <video controls style="width: 100%; height: 200px; object-fit: cover; border-radius: 20px; margin-top: 1rem;">
                            <source src="<?= base_url($activity['video']) ?>" type="video/mp4">
                        </video>
                    <?php endif; ?>
                    <?php if (empty($activity['foto']) && empty($activity['video'])): ?>
                        <div style="width: 100%; height: 200px; background: var(--primary-fade); border-radius: 20px; display: flex; align-items: center; justify-content: center; color: var(--primary);">
                            <span style="font-size: 3rem;">✨</span>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="activity-details" style="flex: 1;">
                    <div class="activity-meta" style="color: var(--secondary); font-weight: 700; font-size: 0.85rem; margin-bottom: 0.5rem; text-transform: uppercase;">
                        <?= date('d F Y', strtotime($activity['tanggal'])) ?> · <?= date('H:i', strtotime($activity['jam'])) ?> WIB
                    </div>
                    <h3 class="activity-title" style="color: var(--primary); font-weight: 800; font-size: 1.5rem; margin-bottom: 1rem;"><?= esc($activity['nama_aktivitas']) ?></h3>
                    <?php if (!empty($activity['deskripsi'] ?? null)): ?>
                        <p style="color: var(--text); line-height: 1.8; opacity: 0.8;"><?= esc($activity['deskripsi']) ?></p>
                    <?php endif; ?>
                </div>
            </article>
        </div>
    <?php endforeach; ?>
    </div>

    <div class="mt-4 d-flex justify-content-center">
        <?= $pager->links() ?>
    </div>
<?php endif; ?>

<?= $this->endSection() ?>



