<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Biodata extends Migration
{
	public function up()
	{
		// Membuat kolom/field untuk tabel biodata
		$this->forge->addField([
			'id'          => [
				'type'           => 'INT',
				'constraint'     => 11,
				'unsigned'       => true,
				'auto_increment' => true
			],
			'nama'       => [
				'type'           => 'VARCHAR',
				'constraint'     => '255',
				'null'           => false
			],
			'alamat'      => [
				'type'           => 'TEXT',
				'null'           => true,
			],
			'tempat_lahir' => [
				'type'           => 'VARCHAR',
				'constraint'     => '100',
				'null'           => true,
			],
			'tanggal_lahir'      => [
				'type'           => 'DATE',
				'null'           => true,
			],
			'jenis_kelamin'      => [
				'type'           => 'ENUM',
				'constraint'     => ['Laki-laki', 'Perempuan'],
				'null'           => true,
			],
			'agama'      => [
				'type'           => 'VARCHAR',
				'constraint'     => '50',
				'null'           => true,
			],
			'no_hp'      => [
				'type'           => 'VARCHAR',
				'constraint'     => '20',
				'null'           => true,
			],
			'email'      => [
				'type'           => 'VARCHAR',
				'constraint'     => '100',
				'null'           => true,
			],
			'foto_profil'      => [
				'type'           => 'VARCHAR',
				'constraint'     => '255',
				'null'           => true,
			],
			'deskripsi'      => [
				'type'           => 'TEXT',
				'null'           => true,
			],
			'created_at DATETIME DEFAULT CURRENT_TIMESTAMP',
			'updated_at DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'
		]);

		// Membuat primary key
		$this->forge->addKey('id', TRUE);

		// Membuat tabel biodata
		$this->forge->createTable('biodata', TRUE);
	}

	//---------------------

	public function down()
	{
		// menghapus tabel biodata
		$this->forge->dropTable('biodata');
	}
}







