<!DOCTYPE html>
<html lang="id" x-data="{ mobileMenu: false, darkMode: false }" :class="{ 'dark': darkMode }">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $title ?? 'Portfolio Digital' ?> - Ilham</title>
    
    <!-- Tailwind CSS CDN -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            darkMode: 'class',
            theme: {
                extend: {
                    colors: {
                        primary: {
                            50: '#eef2ff',
                            100: '#e0e7ff',
                            200: '#c7d2fe',
                            300: '#a5b4fc',
                            400: '#818cf8',
                            500: '#6366f1',
                            600: '#4f46e5',
                            700: '#4338ca',
                            800: '#3730a3',
                            900: '#312e81',
                        }
                    }
                }
            }
        }
    </script>
    
    <!-- Alpine.js CDN -->
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    
    <!-- AOS Animation Library -->
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    
    <!-- Phosphor Icons -->
    <script src="https://unpkg.com/@phosphor-icons/web"></script>
    
    <!-- DevIcons for Programming Languages -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/gh/devicons/devicon@latest/devicon.min.css">
    
    <style>
        /* Custom Scrollbar */
        ::-webkit-scrollbar {
            width: 8px;
        }
        ::-webkit-scrollbar-track {
            background: #f1f5f9;
        }
        ::-webkit-scrollbar-thumb {
            background: #cbd5e1;
            border-radius: 4px;
        }
        ::-webkit-scrollbar-thumb:hover {
            background: #94a3b8;
        }

        /* Floating Background Blobs */
        .blob {
            position: absolute;
            border-radius: 50%;
            filter: blur(60px);
            opacity: 0.3;
            animation: float 20s ease-in-out infinite;
        }
        .blob-1 {
            width: 400px;
            height: 400px;
            background: linear-gradient(135deg, #6366f1 0%, #a855f7 100%);
            top: -100px;
            left: -100px;
            animation-delay: 0s;
        }
        .blob-2 {
            width: 300px;
            height: 300px;
            background: linear-gradient(135deg, #06b6d4 0%, #6366f1 100%);
            top: 50%;
            right: -50px;
            animation-delay: -5s;
        }
        .blob-3 {
            width: 350px;
            height: 350px;
            background: linear-gradient(135deg, #f472b6 0%, #6366f1 100%);
            bottom: -100px;
            left: 30%;
            animation-delay: -10s;
        }

        @keyframes float {
            0%, 100% { transform: translate(0, 0) rotate(0deg); }
            25% { transform: translate(30px, -30px) rotate(5deg); }
            50% { transform: translate(-20px, 20px) rotate(-5deg); }
            75% { transform: translate(20px, 30px) rotate(3deg); }
        }

        /* Mouse Following Eyes */
        .eye {
            position: relative;
            width: 60px;
            height: 60px;
            background: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        }
        .pupil {
            width: 20px;
            height: 20px;
            background: #1e293b;
            border-radius: 50%;
            transition: transform 0.1s ease-out;
        }

        /* 3D Tilt Card */
        .tilt-card {
            transform-style: preserve-3d;
            transition: transform 0.15s ease-out;
        }
        .tilt-card-inner {
            transform: translateZ(30px);
        }

        /* Click Ripple Effect */
        .ripple {
            position: relative;
            overflow: hidden;
        }
        .ripple::after {
            content: '';
            position: absolute;
            width: 100%;
            height: 100%;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%) scale(0);
            background: radial-gradient(circle, rgba(255,255,255,0.3) 0%, transparent 70%);
            border-radius: 50%;
            opacity: 0;
            transition: transform 0.5s, opacity 0.5s;
        }
        .ripple:active::after {
            transform: translate(-50%, -50%) scale(4);
            opacity: 1;
            transition: transform 0s, opacity 0s;
        }

        /* Magnetic Button */
        .magnetic-btn {
            transition: transform 0.3s ease-out;
        }

        /* Cursor Trail */
        .cursor-dot {
            position: fixed;
            width: 8px;
            height: 8px;
            background: #6366f1;
            border-radius: 50%;
            pointer-events: none;
            z-index: 9999;
            opacity: 0.6;
            transition: transform 0.15s ease-out;
        }

        /* Card Hover Lift */
        .card-lift {
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }
        .card-lift:hover {
            transform: translateY(-8px);
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.15);
        }

        /* Text Reveal Animation */
        .text-reveal {
            opacity: 0;
            transform: translateY(20px);
            transition: opacity 0.6s ease, transform 0.6s ease;
        }
        .text-reveal.visible {
            opacity: 1;
            transform: translateY(0);
        }

        /* Glassmorphism */
        .glass {
            background: rgba(255, 255, 255, 0.7);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.3);
        }

        /* Focus Ring */
        .focus-ring:focus {
            outline: none;
            ring: 2px solid #6366f1;
            ring-offset: 2px;
        }

        /* Input Focus Animation */
        .input-animate {
            transition: all 0.3s ease;
        }
        .input-animate:focus {
            transform: scale(1.02);
            border-color: #6366f1;
            box-shadow: 0 0 0 3px rgba(99, 102, 241, 0.1);
        }

        /* Navbar Sticky Blur */
        .navbar-blur {
            backdrop-filter: blur(12px);
            -webkit-backdrop-filter: blur(12px);
        }

        /* Loading Skeleton */
        .skeleton {
            background: linear-gradient(90deg, #f1f5f9 25%, #e2e8f0 50%, #f1f5f9 75%);
            background-size: 200% 100%;
            animation: skeleton-loading 1.5s infinite;
        }
        @keyframes skeleton-loading {
            0% { background-position: 200% 0; }
            100% { background-position: -200% 0; }
        }
    </style>
</head>
<body class="bg-slate-50 text-slate-800 min-h-screen overflow-x-hidden">
    <!-- Floating Background Blobs -->
    <div class="fixed inset-0 overflow-hidden pointer-events-none z-0">
        <div class="blob blob-1"></div>
        <div class="blob blob-2"></div>
        <div class="blob blob-3"></div>
    </div>

    <!-- Cursor Trail (Desktop Only) -->
    <div id="cursor-trail" class="cursor-dot hidden lg:block"></div>

    <!-- Navbar -->
    <nav class="fixed top-0 left-0 right-0 z-50 navbar-blur bg-white/70 border-b border-slate-200/50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between h-16">
                <!-- Logo -->
                <a href="<?= base_url() ?>" class="flex items-center space-x-2 group">
                    <div class="w-10 h-10 bg-gradient-to-br from-primary-500 to-primary-700 rounded-xl flex items-center justify-center text-white font-bold text-lg transform group-hover:rotate-12 transition-transform duration-300">
                        I
                    </div>
                    <span class="font-bold text-xl text-slate-800">Ilham</span>
                </a>

                <!-- Desktop Menu -->
                <div class="hidden md:flex items-center space-x-1">
                    <a href="<?= base_url() ?>" class="px-4 py-2 rounded-xl text-slate-600 hover:text-primary-600 hover:bg-primary-50 transition-all duration-300 font-medium">
                        <i class="ph ph-house mr-1"></i> Beranda
                    </a>
                    <a href="<?= base_url('biodata') ?>" class="px-4 py-2 rounded-xl text-slate-600 hover:text-primary-600 hover:bg-primary-50 transition-all duration-300 font-medium">
                        <i class="ph ph-user mr-1"></i> Biodata
                    </a>
                    <a href="<?= base_url('pendidikan') ?>" class="px-4 py-2 rounded-xl text-slate-600 hover:text-primary-600 hover:bg-primary-50 transition-all duration-300 font-medium">
                        <i class="ph ph-graduation-cap mr-1"></i> Pendidikan
                    </a>
                    <a href="<?= base_url('aktivitas') ?>" class="px-4 py-2 rounded-xl text-slate-600 hover:text-primary-600 hover:bg-primary-50 transition-all duration-300 font-medium">
                        <i class="ph ph-calendar mr-1"></i> Aktivitas
                    </a>
                </div>

                <!-- Admin Button & Mobile Menu Toggle -->
                <div class="flex items-center space-x-3">
                    <a href="<?= base_url('auth/login') ?>" class="hidden md:inline-flex px-4 py-2 bg-gradient-to-r from-primary-500 to-primary-600 text-white rounded-xl font-medium hover:from-primary-600 hover:to-primary-700 transition-all duration-300 ripple magnetic-btn shadow-lg shadow-primary-500/25">
                        <i class="ph ph-sign-in mr-1"></i> Admin
                    </a>
                    
                    <!-- Mobile Menu Button -->
                    <button @click="mobileMenu = !mobileMenu" class="md:hidden p-2 rounded-xl text-slate-600 hover:bg-slate-100 transition-colors">
                        <i class="ph ph-list text-2xl" x-show="!mobileMenu"></i>
                        <i class="ph ph-x text-2xl" x-show="mobileMenu" x-cloak></i>
                    </button>
                </div>
            </div>
        </div>

        <!-- Mobile Menu -->
        <div x-show="mobileMenu" 
             x-transition:enter="transition ease-out duration-200"
             x-transition:enter-start="opacity-0 -translate-y-4"
             x-transition:enter-end="opacity-100 translate-y-0"
             x-transition:leave="transition ease-in duration-150"
             x-transition:leave-start="opacity-100 translate-y-0"
             x-transition:leave-end="opacity-0 -translate-y-4"
             class="md:hidden bg-white/90 navbar-blur border-t border-slate-200/50"
             x-cloak>
            <div class="px-4 py-4 space-y-2">
                <a href="<?= base_url() ?>" class="block px-4 py-3 rounded-xl text-slate-600 hover:text-primary-600 hover:bg-primary-50 transition-all duration-300 font-medium">
                    <i class="ph ph-house mr-2"></i> Beranda
                </a>
                <a href="<?= base_url('biodata') ?>" class="block px-4 py-3 rounded-xl text-slate-600 hover:text-primary-600 hover:bg-primary-50 transition-all duration-300 font-medium">
                    <i class="ph ph-user mr-2"></i> Biodata
                </a>
                <a href="<?= base_url('pendidikan') ?>" class="block px-4 py-3 rounded-xl text-slate-600 hover:text-primary-600 hover:bg-primary-50 transition-all duration-300 font-medium">
                    <i class="ph ph-graduation-cap mr-2"></i> Pendidikan
                </a>
                <a href="<?= base_url('aktivitas') ?>" class="block px-4 py-3 rounded-xl text-slate-600 hover:text-primary-600 hover:bg-primary-50 transition-all duration-300 font-medium">
                    <i class="ph ph-calendar mr-2"></i> Aktivitas
                </a>
                <a href="<?= base_url('auth/login') ?>" class="block px-4 py-3 bg-gradient-to-r from-primary-500 to-primary-600 text-white rounded-xl font-medium text-center mt-4">
                    <i class="ph ph-sign-in mr-2"></i> Admin Login
                </a>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <main class="relative z-10 pt-20">
        <?= $this->renderSection('content') ?>
    </main>

    <!-- Footer -->
    <footer class="relative z-10 mt-20 bg-white/70 navbar-blur border-t border-slate-200/50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <!-- Brand -->
                <div data-aos="fade-up">
                    <div class="flex items-center space-x-2 mb-4">
                        <div class="w-10 h-10 bg-gradient-to-br from-primary-500 to-primary-700 rounded-xl flex items-center justify-center text-white font-bold text-lg">
                            I
                        </div>
                        <span class="font-bold text-xl text-slate-800">Ilham</span>
                    </div>
                    <p class="text-slate-500 text-sm leading-relaxed">
                        Portfolio digital yang menampilkan aktivitas, pendidikan, dan biodata secara modern dan interaktif.
                    </p>
                </div>

                <!-- Quick Links -->
                <div data-aos="fade-up" data-aos-delay="100">
                    <h4 class="font-semibold text-slate-800 mb-4">Menu Cepat</h4>
                    <ul class="space-y-2">
                        <li><a href="<?= base_url() ?>" class="text-slate-500 hover:text-primary-600 transition-colors text-sm">Beranda</a></li>
                        <li><a href="<?= base_url('biodata') ?>" class="text-slate-500 hover:text-primary-600 transition-colors text-sm">Biodata</a></li>
                        <li><a href="<?= base_url('pendidikan') ?>" class="text-slate-500 hover:text-primary-600 transition-colors text-sm">Pendidikan</a></li>
                        <li><a href="<?= base_url('aktivitas') ?>" class="text-slate-500 hover:text-primary-600 transition-colors text-sm">Aktivitas</a></li>
                    </ul>
                </div>

                <!-- Contact -->
                <div data-aos="fade-up" data-aos-delay="200">
                    <h4 class="font-semibold text-slate-800 mb-4">Kontak</h4>
                    <ul class="space-y-2">
                        <li class="flex items-center text-slate-500 text-sm">
                            <i class="ph ph-envelope mr-2 text-primary-500"></i>
                            ilham@example.com
                        </li>
                        <li class="flex items-center text-slate-500 text-sm">
                            <i class="ph ph-phone mr-2 text-primary-500"></i>
                            +62 812 3456 7890
                        </li>
                        <li class="flex items-center text-slate-500 text-sm">
                            <i class="ph ph-map-pin mr-2 text-primary-500"></i>
                            Tangerang, Indonesia
                        </li>
                    </ul>
                </div>
            </div>

            <div class="border-t border-slate-200 mt-8 pt-8 flex flex-col md:flex-row items-center justify-between">
                <p class="text-slate-500 text-sm">
                    &copy; <?= date('Y') ?> Ilham. All rights reserved.
                </p>
                <p class="text-slate-400 text-xs mt-2 md:mt-0">
                    Built with <i class="ph ph-heart-fill text-red-500"></i> using CodeIgniter 4 & Tailwind CSS
                </p>
            </div>
        </div>
    </footer>

    <!-- Flash Messages -->
    <?php if (session()->getFlashdata('success')): ?>
    <div x-data="{ show: true }" 
         x-show="show" 
         x-transition
         x-init="setTimeout(() => show = false, 5000)"
         class="fixed bottom-6 right-6 z-50 bg-green-500 text-white px-6 py-4 rounded-2xl shadow-lg flex items-center space-x-3">
        <i class="ph ph-check-circle text-2xl"></i>
        <span><?= session()->getFlashdata('success') ?></span>
        <button @click="show = false" class="ml-2 hover:bg-green-600 rounded-full p-1 transition-colors">
            <i class="ph ph-x"></i>
        </button>
    </div>
    <?php endif; ?>

    <?php if (session()->getFlashdata('error')): ?>
    <div x-data="{ show: true }" 
         x-show="show" 
         x-transition
         x-init="setTimeout(() => show = false, 5000)"
         class="fixed bottom-6 right-6 z-50 bg-red-500 text-white px-6 py-4 rounded-2xl shadow-lg flex items-center space-x-3">
        <i class="ph ph-x-circle text-2xl"></i>
        <span><?= session()->getFlashdata('error') ?></span>
        <button @click="show = false" class="ml-2 hover:bg-red-600 rounded-full p-1 transition-colors">
            <i class="ph ph-x"></i>
        </button>
    </div>
    <?php endif; ?>

    <script>
        // Initialize AOS
        AOS.init({
            duration: 800,
            easing: 'ease-out-cubic',
            once: true,
            offset: 50
        });

        // Cursor Trail Effect
        const cursorTrail = document.getElementById('cursor-trail');
        if (cursorTrail && window.innerWidth >= 1024) {
            document.addEventListener('mousemove', (e) => {
                cursorTrail.style.left = e.clientX - 4 + 'px';
                cursorTrail.style.top = e.clientY - 4 + 'px';
            });
        }

        // Mouse Following Eyes
        document.querySelectorAll('.eye').forEach(eye => {
            const pupil = eye.querySelector('.pupil');
            document.addEventListener('mousemove', (e) => {
                const rect = eye.getBoundingClientRect();
                const eyeCenterX = rect.left + rect.width / 2;
                const eyeCenterY = rect.top + rect.height / 2;
                
                const angle = Math.atan2(e.clientY - eyeCenterY, e.clientX - eyeCenterX);
                const distance = Math.min(15, Math.hypot(e.clientX - eyeCenterX, e.clientY - eyeCenterY) / 10);
                
                const x = Math.cos(angle) * distance;
                const y = Math.sin(angle) * distance;
                
                if (pupil) {
                    pupil.style.transform = `translate(${x}px, ${y}px)`;
                }
            });
        });

        // 3D Tilt Effect for Cards
        document.querySelectorAll('.tilt-card').forEach(card => {
            card.addEventListener('mousemove', (e) => {
                const rect = card.getBoundingClientRect();
                const x = e.clientX - rect.left;
                const y = e.clientY - rect.top;
                
                const centerX = rect.width / 2;
                const centerY = rect.height / 2;
                
                const rotateX = (y - centerY) / 10;
                const rotateY = (centerX - x) / 10;
                
                card.style.transform = `perspective(1000px) rotateX(${rotateX}deg) rotateY(${rotateY}deg)`;
            });
            
            card.addEventListener('mouseleave', () => {
                card.style.transform = 'perspective(1000px) rotateX(0) rotateY(0)';
            });
        });

        // Magnetic Button Effect
        document.querySelectorAll('.magnetic-btn').forEach(btn => {
            btn.addEventListener('mousemove', (e) => {
                const rect = btn.getBoundingClientRect();
                const x = e.clientX - rect.left - rect.width / 2;
                const y = e.clientY - rect.top - rect.height / 2;
                
                btn.style.transform = `translate(${x * 0.3}px, ${y * 0.3}px)`;
            });
            
            btn.addEventListener('mouseleave', () => {
                btn.style.transform = 'translate(0, 0)';
            });
        });

        // Text Reveal on Scroll
        const textRevealObserver = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.classList.add('visible');
                }
            });
        }, { threshold: 0.1 });

        document.querySelectorAll('.text-reveal').forEach(el => {
            textRevealObserver.observe(el);
        });
    </script>

    <?= $this->renderSection('scripts') ?>
</body>
</html>
