<?= $this->extend('layout/main') ?>

<?= $this->section('content') ?>
<section class="py-12">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="text-center mb-12" data-aos="fade-up">
            <span class="inline-block px-4 py-2 bg-purple-100 text-purple-600 rounded-full text-sm font-medium mb-4">
                📸 Dokumentasi
            </span>
            <h1 class="text-3xl md:text-4xl font-bold text-slate-800 mb-4">Galeri Foto & Video</h1>
            <p class="text-slate-500 max-w-2xl mx-auto">Koleksi foto dan video dokumentasi kegiatan saya.</p>
        </div>

        <!-- Filter -->
        <div class="flex justify-center gap-2 mb-8" data-aos="fade-up" data-aos-delay="100">
            <a href="<?= base_url('galeri') ?>" class="px-4 py-2 rounded-xl transition-colors <?= !$tipe ? 'bg-primary-500 text-white' : 'bg-white text-slate-600 hover:bg-slate-50' ?>">
                Semua
            </a>
            <a href="<?= base_url('galeri?tipe=foto') ?>" class="px-4 py-2 rounded-xl transition-colors <?= $tipe === 'foto' ? 'bg-primary-500 text-white' : 'bg-white text-slate-600 hover:bg-slate-50' ?>">
                <i class="ph ph-image mr-1"></i> Foto
            </a>
            <a href="<?= base_url('galeri?tipe=video') ?>" class="px-4 py-2 rounded-xl transition-colors <?= $tipe === 'video' ? 'bg-primary-500 text-white' : 'bg-white text-slate-600 hover:bg-slate-50' ?>">
                <i class="ph ph-video mr-1"></i> Video
            </a>
        </div>

        <?php if (!empty($galeri)): ?>
        <!-- Gallery Grid -->
        <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-4">
            <?php foreach ($galeri as $index => $item): ?>
            <div class="group relative rounded-2xl overflow-hidden bg-white shadow-lg shadow-slate-200/50 cursor-pointer"
                 data-aos="fade-up"
                 data-aos-delay="<?= ($index % 8) * 50 ?>"
                 onclick="openLightbox(<?= $index ?>)">
                
                <div class="aspect-square overflow-hidden bg-slate-100">
                    <?php if ($item['tipe'] === 'video'): ?>
                        <!-- Video with autoplay on hover -->
                        <div class="video-container relative w-full h-full">
                            <?php if ($item['thumbnail']): ?>
                            <img src="<?= base_url('uploads/galeri/' . $item['thumbnail']) ?>" 
                                 alt="<?= $item['judul'] ?>" 
                                 class="video-thumbnail w-full h-full object-cover transition-opacity duration-300">
                            <?php endif; ?>
                            <video src="<?= base_url('uploads/galeri/' . $item['file']) ?>" 
                                   class="video-player w-full h-full object-cover <?= $item['thumbnail'] ? 'opacity-0' : '' ?> transition-opacity duration-300"
                                   muted loop playsinline></video>
                            <div class="play-icon absolute inset-0 flex items-center justify-center transition-opacity duration-300">
                                <div class="w-14 h-14 bg-white/90 backdrop-blur rounded-full flex items-center justify-center shadow-lg group-hover:scale-110 transition-transform">
                                    <i class="ph ph-play-fill text-2xl text-slate-800 ml-1"></i>
                                </div>
                            </div>
                        </div>
                    <?php else: ?>
                        <!-- Photo -->
                        <?php if ($item['file']): ?>
                        <img src="<?= base_url('uploads/galeri/' . $item['file']) ?>" 
                             alt="<?= $item['judul'] ?>" 
                             class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-500">
                        <?php else: ?>
                        <div class="w-full h-full flex items-center justify-center bg-gradient-to-br from-primary-100 to-primary-200">
                            <i class="ph ph-image text-5xl text-primary-400"></i>
                        </div>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>

                <!-- Overlay -->
                <div class="absolute inset-0 bg-gradient-to-t from-black/70 via-transparent to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-300">
                    <div class="absolute bottom-0 left-0 right-0 p-4">
                        <h3 class="text-white font-semibold text-sm line-clamp-2"><?= $item['judul'] ?></h3>
                        <p class="text-white/70 text-xs"><?= date('d M Y', strtotime($item['tanggal'] ?? $item['created_at'])) ?></p>
                    </div>
                </div>

                <!-- Type badge -->
                <div class="absolute top-3 left-3">
                    <span class="px-2 py-1 text-xs font-medium rounded-lg <?= $item['tipe'] === 'video' ? 'bg-red-500 text-white' : 'bg-blue-500 text-white' ?>">
                        <i class="ph ph-<?= $item['tipe'] === 'video' ? 'video' : 'image' ?> mr-1"></i>
                        <?= ucfirst($item['tipe']) ?>
                    </span>
                </div>
            </div>
            <?php endforeach; ?>
        </div>

        <!-- Pagination -->
        <?php if ($pager && $pager->getPageCount() > 1): ?>
        <div class="mt-12 flex justify-center" data-aos="fade-up">
            <?= $pager->links('default', 'default_full') ?>
        </div>
        <?php endif; ?>

        <?php else: ?>
        <!-- Empty State -->
        <div class="bg-white rounded-3xl shadow-xl shadow-slate-200/50 p-12 text-center" data-aos="fade-up">
            <div class="w-24 h-24 bg-slate-100 rounded-full flex items-center justify-center mx-auto mb-6">
                <i class="ph ph-images text-5xl text-slate-400"></i>
            </div>
            <h3 class="text-xl font-semibold text-slate-800 mb-2">Belum Ada Galeri</h3>
            <p class="text-slate-500">Galeri foto dan video belum tersedia saat ini.</p>
        </div>
        <?php endif; ?>
    </div>
</section>

<!-- Lightbox Modal -->
<div id="lightbox" class="fixed inset-0 z-50 hidden bg-black/95" onclick="closeLightbox()">
    <button class="absolute top-6 right-6 text-white text-4xl hover:text-slate-300 transition-colors" onclick="closeLightbox()">
        <i class="ph ph-x"></i>
    </button>
    <button class="absolute left-4 top-1/2 -translate-y-1/2 text-white text-4xl hover:text-slate-300 transition-colors" onclick="event.stopPropagation(); prevSlide()">
        <i class="ph ph-caret-left"></i>
    </button>
    <button class="absolute right-4 top-1/2 -translate-y-1/2 text-white text-4xl hover:text-slate-300 transition-colors" onclick="event.stopPropagation(); nextSlide()">
        <i class="ph ph-caret-right"></i>
    </button>
    <div class="flex items-center justify-center h-full p-8" onclick="event.stopPropagation()">
        <div id="lightbox-content" class="max-w-5xl max-h-full"></div>
    </div>
    <div class="absolute bottom-6 left-1/2 -translate-x-1/2 text-white text-center">
        <h3 id="lightbox-title" class="text-lg font-semibold"></h3>
        <p id="lightbox-desc" class="text-sm text-slate-300"></p>
    </div>
</div>

<style>
    .video-container:hover .video-thumbnail {
        opacity: 0;
    }
    .video-container:hover .video-player {
        opacity: 1 !important;
    }
    .video-container:hover .play-icon {
        opacity: 0;
    }
</style>

<script>
// Gallery data for lightbox
const galleryData = <?= json_encode($galeri) ?>;
let currentIndex = 0;

// Video autoplay on hover
document.querySelectorAll('.video-container').forEach(container => {
    const video = container.querySelector('.video-player');
    const thumbnail = container.querySelector('.video-thumbnail');
    const playIcon = container.querySelector('.play-icon');
    
    container.addEventListener('mouseenter', () => {
        if (video) {
            video.play().catch(() => {});
            if (thumbnail) thumbnail.style.opacity = '0';
            if (playIcon) playIcon.style.opacity = '0';
        }
    });
    
    container.addEventListener('mouseleave', () => {
        if (video) {
            video.pause();
            video.currentTime = 0;
            if (thumbnail) thumbnail.style.opacity = '1';
            if (playIcon) playIcon.style.opacity = '1';
        }
    });
});

// Lightbox functions
function openLightbox(index) {
    currentIndex = index;
    updateLightbox();
    document.getElementById('lightbox').classList.remove('hidden');
    document.body.style.overflow = 'hidden';
}

function closeLightbox() {
    document.getElementById('lightbox').classList.add('hidden');
    document.body.style.overflow = '';
    const video = document.querySelector('#lightbox-content video');
    if (video) video.pause();
}

function nextSlide() {
    currentIndex = (currentIndex + 1) % galleryData.length;
    updateLightbox();
}

function prevSlide() {
    currentIndex = (currentIndex - 1 + galleryData.length) % galleryData.length;
    updateLightbox();
}

function updateLightbox() {
    const item = galleryData[currentIndex];
    const content = document.getElementById('lightbox-content');
    const baseUrl = '<?= base_url('uploads/galeri/') ?>';
    
    if (item.tipe === 'video' && item.file) {
        content.innerHTML = `<video src="${baseUrl}${item.file}" controls autoplay class="max-w-full max-h-[80vh] rounded-lg"></video>`;
    } else if (item.file) {
        content.innerHTML = `<img src="${baseUrl}${item.file}" alt="${item.judul}" class="max-w-full max-h-[80vh] rounded-lg">`;
    }
    
    document.getElementById('lightbox-title').textContent = item.judul;
    document.getElementById('lightbox-desc').textContent = item.deskripsi || '';
}

// Keyboard navigation
document.addEventListener('keydown', (e) => {
    if (!document.getElementById('lightbox').classList.contains('hidden')) {
        if (e.key === 'Escape') closeLightbox();
        if (e.key === 'ArrowRight') nextSlide();
        if (e.key === 'ArrowLeft') prevSlide();
    }
});
</script>
<?= $this->endSection() ?>
