<?= $this->extend('layout/main') ?>

<?= $this->section('content') ?>
<section class="py-12">
    <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="text-center mb-12" data-aos="fade-up">
            <span class="inline-block px-4 py-2 bg-primary-100 text-primary-600 rounded-full text-sm font-medium mb-4">
                👤 Tentang Saya
            </span>
            <h1 class="text-3xl md:text-4xl font-bold text-slate-800">Biodata</h1>
        </div>

        <?php if ($biodata): ?>
        <!-- Profile Card -->
        <div class="bg-white rounded-3xl shadow-xl shadow-slate-200/50 overflow-hidden mb-8" data-aos="fade-up" data-aos-delay="100">
            <div class="p-8 md:p-12">
                <div class="flex flex-col md:flex-row items-center md:items-start gap-8">
                    <!-- Photo -->
                    <div class="flex-shrink-0">
                        <div class="w-40 h-40 md:w-48 md:h-48 rounded-2xl overflow-hidden bg-gradient-to-br from-primary-100 to-primary-200 shadow-lg">
                            <?php if ($biodata['foto_profil']): ?>
                            <img src="<?= base_url('uploads/biodata/' . $biodata['foto_profil']) ?>" 
                                 alt="<?= $biodata['nama_lengkap'] ?>" 
                                 class="w-full h-full object-cover">
                            <?php else: ?>
                            <div class="w-full h-full flex items-center justify-center">
                                <i class="ph ph-user text-6xl text-primary-400"></i>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- Info -->
                    <div class="flex-1 text-center md:text-left">
                        <h2 class="text-2xl md:text-3xl font-bold text-slate-800 mb-2">
                            <?= $biodata['nama_lengkap'] ?>
                        </h2>
                        <p class="text-slate-500 mb-6">
                            <?= $biodata['deskripsi_diri'] ?? 'Tidak ada deskripsi' ?>
                        </p>

                        <!-- Contact Info -->
                        <div class="space-y-3">
                            <div class="flex items-center justify-center md:justify-start text-slate-600">
                                <div class="w-10 h-10 bg-primary-100 rounded-xl flex items-center justify-center mr-3">
                                    <i class="ph ph-envelope text-xl text-primary-600"></i>
                                </div>
                                <a href="mailto:<?= $biodata['email'] ?>" class="hover:text-primary-600 transition-colors">
                                    <?= $biodata['email'] ?>
                                </a>
                            </div>
                            
                            <?php if ($biodata['no_hp']): ?>
                            <div class="flex items-center justify-center md:justify-start text-slate-600">
                                <div class="w-10 h-10 bg-green-100 rounded-xl flex items-center justify-center mr-3">
                                    <i class="ph ph-phone text-xl text-green-600"></i>
                                </div>
                                <a href="tel:<?= $biodata['no_hp'] ?>" class="hover:text-green-600 transition-colors">
                                    <?= $biodata['no_hp'] ?>
                                </a>
                            </div>
                            <?php endif; ?>

                            <?php if ($biodata['alamat']): ?>
                            <div class="flex items-center justify-center md:justify-start text-slate-600">
                                <div class="w-10 h-10 bg-yellow-100 rounded-xl flex items-center justify-center mr-3">
                                    <i class="ph ph-map-pin text-xl text-yellow-600"></i>
                                </div>
                                <span><?= $biodata['alamat'] ?></span>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Programming Languages Section -->
        <?php if (!empty($bahasa)): ?>
        <div class="mb-8" data-aos="fade-up" data-aos-delay="150">
            <div class="flex items-center gap-3 mb-6">
                <div class="w-10 h-10 bg-purple-100 rounded-xl flex items-center justify-center">
                    <i class="ph ph-code text-xl text-purple-600"></i>
                </div>
                <h3 class="text-xl font-bold text-slate-800">Bahasa Pemrograman</h3>
            </div>
            <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5 gap-4">
                <?php 
                // Icon mapping for DevIcons
                $iconMap = [
                    'php' => 'devicon-php-plain',
                    'javascript' => 'devicon-javascript-plain',
                    'python' => 'devicon-python-plain',
                    'java' => 'devicon-java-plain',
                    'c++' => 'devicon-cplusplus-plain',
                    'c#' => 'devicon-csharp-plain',
                    'html' => 'devicon-html5-plain',
                    'css' => 'devicon-css3-plain',
                    'react' => 'devicon-react-original',
                    'vue' => 'devicon-vuejs-plain',
                    'angular' => 'devicon-angularjs-plain',
                    'nodejs' => 'devicon-nodejs-plain',
                    'mysql' => 'devicon-mysql-plain',
                    'postgresql' => 'devicon-postgresql-plain',
                    'mongodb' => 'devicon-mongodb-plain',
                    'laravel' => 'devicon-laravel-original',
                    'codeigniter' => 'devicon-codeigniter-plain',
                    'flutter' => 'devicon-flutter-plain',
                    'dart' => 'devicon-dart-plain',
                    'typescript' => 'devicon-typescript-plain',
                    'go' => 'devicon-go-plain',
                    'rust' => 'devicon-rust-original',
                    'swift' => 'devicon-swift-plain',
                    'kotlin' => 'devicon-kotlin-plain',
                    'ruby' => 'devicon-ruby-plain',
                ];
                ?>
                <?php foreach ($bahasa as $lang): ?>
                <?php 
                $langKey = strtolower($lang['nama_bahasa']);
                $hasIcon = isset($iconMap[$langKey]);
                ?>
                <div class="bg-white rounded-2xl shadow-lg shadow-slate-200/50 p-5 hover:shadow-xl hover:-translate-y-1 transition-all duration-300 group">
                    <div class="flex flex-col items-center text-center">
                        <!-- Language Icon -->
                        <div class="w-16 h-16 rounded-xl flex items-center justify-center mb-3 transition-transform group-hover:scale-110" 
                             style="background-color: <?= $lang['warna'] ?? '#6366f1' ?>15">
                            <?php if ($hasIcon): ?>
                            <i class="<?= $iconMap[$langKey] ?> text-4xl" style="color: <?= $lang['warna'] ?? '#6366f1' ?>"></i>
                            <?php else: ?>
                            <span class="text-2xl font-bold" style="color: <?= $lang['warna'] ?? '#6366f1' ?>">
                                <?= strtoupper(substr($lang['nama_bahasa'], 0, 2)) ?>
                            </span>
                            <?php endif; ?>
                        </div>
                        <h4 class="font-semibold text-slate-800 mb-1"><?= $lang['nama_bahasa'] ?></h4>
                        <span class="inline-block px-2 py-0.5 text-xs font-medium rounded-full
                            <?php if ($lang['tingkat'] === 'Expert'): ?>
                            bg-green-100 text-green-600
                            <?php elseif ($lang['tingkat'] === 'Mahir'): ?>
                            bg-blue-100 text-blue-600
                            <?php elseif ($lang['tingkat'] === 'Menengah'): ?>
                            bg-yellow-100 text-yellow-600
                            <?php else: ?>
                            bg-slate-100 text-slate-600
                            <?php endif; ?>
                        ">
                            <?= $lang['tingkat'] ?>
                        </span>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endif; ?>

        <!-- Certificates Section -->
        <?php if (!empty($sertifikat)): ?>
        <div data-aos="fade-up" data-aos-delay="200">
            <div class="flex items-center gap-3 mb-6">
                <div class="w-10 h-10 bg-amber-100 rounded-xl flex items-center justify-center">
                    <i class="ph ph-certificate text-xl text-amber-600"></i>
                </div>
                <h3 class="text-xl font-bold text-slate-800">Sertifikat</h3>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                <?php foreach ($sertifikat as $cert): ?>
                <div class="bg-white rounded-2xl shadow-lg shadow-slate-200/50 overflow-hidden hover:shadow-xl transition-shadow group">
                    <?php if ($cert['file_sertifikat']): ?>
                    <div class="h-40 overflow-hidden">
                        <img src="<?= base_url('uploads/sertifikat/' . $cert['file_sertifikat']) ?>" 
                             alt="<?= $cert['nama_sertifikat'] ?>" 
                             class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-300">
                    </div>
                    <?php else: ?>
                    <div class="h-40 bg-gradient-to-br from-amber-100 to-amber-200 flex items-center justify-center">
                        <i class="ph ph-certificate text-6xl text-amber-400"></i>
                    </div>
                    <?php endif; ?>
                    <div class="p-5">
                        <h4 class="font-semibold text-slate-800 mb-1 line-clamp-2"><?= $cert['nama_sertifikat'] ?></h4>
                        <p class="text-sm text-slate-500 mb-2"><?= $cert['penerbit'] ?></p>
                        <?php if ($cert['tanggal']): ?>
                        <p class="text-xs text-slate-400"><?= date('d M Y', strtotime($cert['tanggal'])) ?></p>
                        <?php endif; ?>
                        <?php if ($cert['credential_url']): ?>
                        <a href="<?= $cert['credential_url'] ?>" target="_blank" 
                           class="inline-flex items-center text-sm text-primary-600 hover:text-primary-700 mt-3">
                            <i class="ph ph-link mr-1"></i>
                            Lihat Sertifikat
                        </a>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endif; ?>

        <?php else: ?>
        <!-- Empty State -->
        <div class="bg-white rounded-3xl shadow-xl shadow-slate-200/50 p-12 text-center" data-aos="fade-up">
            <div class="w-24 h-24 bg-slate-100 rounded-full flex items-center justify-center mx-auto mb-6">
                <i class="ph ph-user-circle text-5xl text-slate-400"></i>
            </div>
            <h3 class="text-xl font-semibold text-slate-800 mb-2">Belum Ada Data Biodata</h3>
            <p class="text-slate-500">Data biodata belum tersedia saat ini.</p>
        </div>
        <?php endif; ?>
    </div>
</section>
<?= $this->endSection() ?>

