<?= $this->extend('layout/admin') ?>

<?= $this->section('content') ?>
<div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
    <!-- Form Section -->
    <div class="lg:col-span-2">
        <div class="bg-white rounded-2xl shadow-sm border border-slate-200 overflow-hidden">
            <div class="p-6 border-b border-slate-200 bg-gradient-to-r from-amber-500 to-orange-500">
                <h2 class="font-semibold text-white flex items-center">
                    <i class="ph ph-pencil-simple text-xl mr-2"></i>
                    Edit Media
                </h2>
                <p class="text-amber-100 text-sm mt-1">Perbarui konten galeri</p>
            </div>
            
            <form action="<?= base_url('admin/galeri/update/' . $galeri['id']) ?>" method="POST" enctype="multipart/form-data" class="p-6">
                <?= csrf_field() ?>
                
                <?php if (session()->getFlashdata('errors')): ?>
                <div class="mb-6 p-4 bg-red-50 border border-red-200 rounded-xl">
                    <ul class="list-disc list-inside text-sm text-red-600">
                        <?php foreach (session()->getFlashdata('errors') as $error): ?>
                        <li><?= $error ?></li>
                        <?php endforeach; ?>
                    </ul>
                </div>
                <?php endif; ?>

                <div class="space-y-5" x-data="{ tipe: '<?= old('tipe', $galeri['tipe']) ?>' }">
                    <!-- Preview current media -->
                    <?php if ($galeri['file']): ?>
                    <div class="rounded-xl overflow-hidden bg-slate-100">
                        <?php if ($galeri['tipe'] === 'video'): ?>
                        <video src="<?= base_url('uploads/galeri/' . $galeri['file']) ?>" controls class="w-full max-h-48 object-contain"></video>
                        <?php else: ?>
                        <img src="<?= base_url('uploads/galeri/' . $galeri['file']) ?>" alt="<?= $galeri['judul'] ?>" class="w-full max-h-48 object-contain">
                        <?php endif; ?>
                    </div>
                    <?php endif; ?>

                    <div>
                        <label for="judul" class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-text-t text-amber-500 mr-1"></i>
                            Judul <span class="text-red-500">*</span>
                        </label>
                        <input type="text" name="judul" id="judul" value="<?= old('judul', $galeri['judul']) ?>" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-amber-500 focus:ring-2 focus:ring-amber-500/20 transition-all" required>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-selection-all text-amber-500 mr-1"></i>
                            Tipe Media <span class="text-red-500">*</span>
                        </label>
                        <div class="flex gap-4">
                            <label class="flex-1 cursor-pointer">
                                <input type="radio" name="tipe" value="foto" x-model="tipe" class="sr-only">
                                <div :class="tipe === 'foto' ? 'border-amber-500 bg-amber-50' : 'border-slate-200 bg-slate-50'" class="border-2 rounded-xl p-4 text-center transition-all">
                                    <i class="ph ph-image text-2xl mb-2" :class="tipe === 'foto' ? 'text-amber-600' : 'text-slate-400'"></i>
                                    <p class="font-medium" :class="tipe === 'foto' ? 'text-amber-600' : 'text-slate-600'">Foto</p>
                                </div>
                            </label>
                            <label class="flex-1 cursor-pointer">
                                <input type="radio" name="tipe" value="video" x-model="tipe" class="sr-only">
                                <div :class="tipe === 'video' ? 'border-amber-500 bg-amber-50' : 'border-slate-200 bg-slate-50'" class="border-2 rounded-xl p-4 text-center transition-all">
                                    <i class="ph ph-video text-2xl mb-2" :class="tipe === 'video' ? 'text-amber-600' : 'text-slate-400'"></i>
                                    <p class="font-medium" :class="tipe === 'video' ? 'text-amber-600' : 'text-slate-600'">Video</p>
                                </div>
                            </label>
                        </div>
                    </div>

                    <div>
                        <label for="tanggal" class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-calendar text-amber-500 mr-1"></i>
                            Tanggal
                        </label>
                        <input type="date" name="tanggal" id="tanggal" value="<?= old('tanggal', $galeri['tanggal']) ?>" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-amber-500 focus:ring-2 focus:ring-amber-500/20 transition-all">
                    </div>

                    <div>
                        <label for="deskripsi" class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-article text-amber-500 mr-1"></i>
                            Deskripsi
                        </label>
                        <textarea name="deskripsi" id="deskripsi" rows="3" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-amber-500 focus:ring-2 focus:ring-amber-500/20 transition-all resize-none"><?= old('deskripsi', $galeri['deskripsi']) ?></textarea>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-cloud-arrow-up text-amber-500 mr-1"></i>
                            Ganti File Media
                        </label>
                        <div class="border-2 border-dashed border-slate-200 rounded-xl p-6 text-center hover:border-amber-400 transition-colors">
                            <input type="file" name="file" id="file" accept="image/*,video/*" class="hidden">
                            <label for="file" class="cursor-pointer">
                                <i class="ph ph-cloud-arrow-up text-4xl text-amber-400 mb-2"></i>
                                <p class="text-slate-600">Klik untuk upload file baru</p>
                                <p class="text-xs text-slate-400 mt-1">Biarkan kosong jika tidak ingin mengubah</p>
                            </label>
                        </div>
                    </div>

                    <div x-show="tipe === 'video'" x-transition>
                        <label class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-image text-amber-500 mr-1"></i>
                            Thumbnail
                        </label>
                        <div class="flex items-center gap-4">
                            <div class="w-24 h-24 rounded-xl overflow-hidden bg-slate-100 border-2 border-dashed border-slate-200">
                                <?php if ($galeri['thumbnail']): ?>
                                <img src="<?= base_url('uploads/galeri/' . $galeri['thumbnail']) ?>" class="w-full h-full object-cover">
                                <?php else: ?>
                                <div class="w-full h-full flex items-center justify-center">
                                    <i class="ph ph-image text-3xl text-slate-400"></i>
                                </div>
                                <?php endif; ?>
                            </div>
                            <div class="flex-1">
                                <input type="file" name="thumbnail" id="thumbnail" accept="image/*" class="hidden">
                                <label for="thumbnail" class="inline-flex items-center px-4 py-2.5 bg-amber-50 text-amber-700 rounded-xl hover:bg-amber-100 transition-colors cursor-pointer border border-amber-200">
                                    <i class="ph ph-upload-simple mr-2"></i>
                                    <?= $galeri['thumbnail'] ? 'Ganti Thumbnail' : 'Pilih Thumbnail' ?>
                                </label>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="flex items-center justify-end gap-3 mt-8 pt-6 border-t border-slate-200">
                    <a href="<?= base_url('admin/galeri') ?>" class="px-6 py-3 text-slate-600 hover:bg-slate-100 rounded-xl transition-colors flex items-center">
                        <i class="ph ph-x mr-2"></i>
                        Batal
                    </a>
                    <button type="submit" class="px-6 py-3 bg-gradient-to-r from-amber-500 to-orange-500 text-white rounded-xl hover:from-amber-600 hover:to-orange-600 transition-all shadow-lg shadow-amber-500/25 flex items-center">
                        <i class="ph ph-floppy-disk mr-2"></i>
                        Simpan Perubahan
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Decorative Right Panel -->
    <div class="hidden lg:block">
        <div class="sticky top-24 space-y-6">
            <!-- Current Data Card -->
            <div class="bg-gradient-to-br from-amber-500 to-orange-600 rounded-2xl p-6 text-white shadow-xl shadow-amber-500/20">
                <div class="w-16 h-16 bg-white/20 rounded-2xl flex items-center justify-center mb-4 overflow-hidden">
                    <?php if ($galeri['thumbnail'] || ($galeri['tipe'] === 'foto' && $galeri['file'])): ?>
                    <img src="<?= base_url('uploads/galeri/' . ($galeri['thumbnail'] ?: $galeri['file'])) ?>" class="w-full h-full object-cover">
                    <?php else: ?>
                    <i class="ph ph-<?= $galeri['tipe'] === 'video' ? 'video' : 'image' ?> text-4xl"></i>
                    <?php endif; ?>
                </div>
                <h3 class="text-lg font-bold mb-1 truncate"><?= $galeri['judul'] ?></h3>
                <p class="text-amber-100 text-sm capitalize"><?= $galeri['tipe'] ?></p>
            </div>

            <!-- Info Card -->
            <div class="bg-white rounded-2xl p-6 border border-slate-200 shadow-sm">
                <h4 class="font-semibold text-slate-800 mb-4 flex items-center">
                    <i class="ph ph-info text-blue-500 text-xl mr-2"></i>
                    Informasi Media
                </h4>
                <div class="space-y-3 text-sm">
                    <div class="flex items-center justify-between p-3 bg-slate-50 rounded-lg">
                        <span class="text-slate-500">ID</span>
                        <span class="font-medium text-slate-800">#<?= $galeri['id'] ?></span>
                    </div>
                    <div class="flex items-center justify-between p-3 bg-slate-50 rounded-lg">
                        <span class="text-slate-500">Tipe</span>
                        <span class="font-medium text-slate-800 capitalize"><?= $galeri['tipe'] ?></span>
                    </div>
                    <div class="flex items-center justify-between p-3 bg-slate-50 rounded-lg">
                        <span class="text-slate-500">Tanggal</span>
                        <span class="font-medium text-slate-800"><?= $galeri['tanggal'] ? date('d M Y', strtotime($galeri['tanggal'])) : '-' ?></span>
                    </div>
                </div>
            </div>

            <!-- Quick Actions -->
            <div class="bg-white rounded-2xl p-6 border border-slate-200 shadow-sm">
                <h4 class="font-semibold text-slate-800 mb-4 flex items-center">
                    <i class="ph ph-lightning text-amber-500 text-xl mr-2"></i>
                    Aksi Cepat
                </h4>
                <div class="space-y-2">
                    <a href="<?= base_url('admin/galeri') ?>" class="flex items-center p-3 bg-slate-50 hover:bg-slate-100 rounded-lg transition-colors">
                        <i class="ph ph-list text-slate-500 mr-3"></i>
                        <span class="text-sm text-slate-700">Kembali ke Daftar</span>
                    </a>
                    <a href="<?= base_url('admin/galeri/create') ?>" class="flex items-center p-3 bg-violet-50 hover:bg-violet-100 rounded-lg transition-colors">
                        <i class="ph ph-plus-circle text-violet-500 mr-3"></i>
                        <span class="text-sm text-violet-700">Tambah Baru</span>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>
