<?= $this->extend('layout/admin') ?>

<?= $this->section('content') ?>
<div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
    <!-- Form Section -->
    <div class="lg:col-span-2">
        <div class="bg-white rounded-2xl shadow-sm border border-slate-200 overflow-hidden">
            <div class="p-6 border-b border-slate-200 bg-gradient-to-r from-violet-500 to-purple-600">
                <h2 class="font-semibold text-white flex items-center">
                    <i class="ph ph-images-square text-xl mr-2"></i>
                    Tambah Media
                </h2>
                <p class="text-violet-100 text-sm mt-1">Upload foto atau video ke galeri</p>
            </div>
            
            <form action="<?= base_url('admin/galeri/store') ?>" method="POST" enctype="multipart/form-data" class="p-6">
                <?= csrf_field() ?>
                
                <?php if (session()->getFlashdata('errors')): ?>
                <div class="mb-6 p-4 bg-red-50 border border-red-200 rounded-xl">
                    <ul class="list-disc list-inside text-sm text-red-600">
                        <?php foreach (session()->getFlashdata('errors') as $error): ?>
                        <li><?= $error ?></li>
                        <?php endforeach; ?>
                    </ul>
                </div>
                <?php endif; ?>

                <div class="space-y-5" x-data="{ tipe: '<?= old('tipe', 'foto') ?>' }">
                    <div>
                        <label for="judul" class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-text-t text-violet-500 mr-1"></i>
                            Judul <span class="text-red-500">*</span>
                        </label>
                        <input type="text" name="judul" id="judul" value="<?= old('judul') ?>" placeholder="Judul media" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-violet-500 focus:ring-2 focus:ring-violet-500/20 transition-all" required>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-selection-all text-violet-500 mr-1"></i>
                            Tipe Media <span class="text-red-500">*</span>
                        </label>
                        <div class="flex gap-4">
                            <label class="flex-1 cursor-pointer">
                                <input type="radio" name="tipe" value="foto" x-model="tipe" class="sr-only">
                                <div :class="tipe === 'foto' ? 'border-violet-500 bg-violet-50' : 'border-slate-200 bg-slate-50'" class="border-2 rounded-xl p-4 text-center transition-all">
                                    <i class="ph ph-image text-2xl mb-2" :class="tipe === 'foto' ? 'text-violet-600' : 'text-slate-400'"></i>
                                    <p class="font-medium" :class="tipe === 'foto' ? 'text-violet-600' : 'text-slate-600'">Foto</p>
                                </div>
                            </label>
                            <label class="flex-1 cursor-pointer">
                                <input type="radio" name="tipe" value="video" x-model="tipe" class="sr-only">
                                <div :class="tipe === 'video' ? 'border-violet-500 bg-violet-50' : 'border-slate-200 bg-slate-50'" class="border-2 rounded-xl p-4 text-center transition-all">
                                    <i class="ph ph-video text-2xl mb-2" :class="tipe === 'video' ? 'text-violet-600' : 'text-slate-400'"></i>
                                    <p class="font-medium" :class="tipe === 'video' ? 'text-violet-600' : 'text-slate-600'">Video</p>
                                </div>
                            </label>
                        </div>
                    </div>

                    <div>
                        <label for="tanggal" class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-calendar text-violet-500 mr-1"></i>
                            Tanggal
                        </label>
                        <input type="date" name="tanggal" id="tanggal" value="<?= old('tanggal', date('Y-m-d')) ?>" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-violet-500 focus:ring-2 focus:ring-violet-500/20 transition-all">
                    </div>

                    <div>
                        <label for="deskripsi" class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-article text-violet-500 mr-1"></i>
                            Deskripsi
                        </label>
                        <textarea name="deskripsi" id="deskripsi" rows="3" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-violet-500 focus:ring-2 focus:ring-violet-500/20 transition-all resize-none" placeholder="Deskripsi singkat..."><?= old('deskripsi') ?></textarea>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-cloud-arrow-up text-violet-500 mr-1"></i>
                            File Media <span class="text-red-500">*</span>
                        </label>
                        <div class="border-2 border-dashed border-slate-200 rounded-xl p-6 text-center hover:border-violet-400 transition-colors">
                            <input type="file" name="file" id="file" accept="image/*,video/*" class="hidden" required>
                            <label for="file" class="cursor-pointer">
                                <i class="ph ph-cloud-arrow-up text-4xl text-violet-400 mb-2"></i>
                                <p class="text-slate-600">Klik untuk upload atau drag & drop</p>
                                <p class="text-xs text-slate-400 mt-1">JPG, PNG, GIF, MP4, WEBM (Maks 50MB)</p>
                            </label>
                        </div>
                    </div>

                    <div x-show="tipe === 'video'" x-transition>
                        <label class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-image text-violet-500 mr-1"></i>
                            Thumbnail (untuk video)
                        </label>
                        <div class="flex items-center gap-4">
                            <div class="w-24 h-24 rounded-xl overflow-hidden bg-slate-100 flex items-center justify-center border-2 border-dashed border-slate-200" id="thumb-preview">
                                <i class="ph ph-image text-3xl text-slate-400"></i>
                            </div>
                            <div class="flex-1">
                                <input type="file" name="thumbnail" id="thumbnail" accept="image/*" class="hidden">
                                <label for="thumbnail" class="inline-flex items-center px-4 py-2.5 bg-violet-50 text-violet-700 rounded-xl hover:bg-violet-100 transition-colors cursor-pointer border border-violet-200">
                                    <i class="ph ph-upload-simple mr-2"></i>
                                    Pilih Thumbnail
                                </label>
                                <p class="text-xs text-slate-500 mt-2">Opsional. Otomatis dari frame video.</p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="flex items-center justify-end gap-3 mt-8 pt-6 border-t border-slate-200">
                    <a href="<?= base_url('admin/galeri') ?>" class="px-6 py-3 text-slate-600 hover:bg-slate-100 rounded-xl transition-colors flex items-center">
                        <i class="ph ph-x mr-2"></i>
                        Batal
                    </a>
                    <button type="submit" class="px-6 py-3 bg-gradient-to-r from-violet-500 to-purple-600 text-white rounded-xl hover:from-violet-600 hover:to-purple-700 transition-all shadow-lg shadow-violet-500/25 flex items-center">
                        <i class="ph ph-floppy-disk mr-2"></i>
                        Simpan
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Decorative Right Panel -->
    <div class="hidden lg:block">
        <div class="sticky top-24 space-y-6">
            <!-- Info Card -->
            <div class="bg-gradient-to-br from-violet-500 to-purple-600 rounded-2xl p-6 text-white shadow-xl shadow-violet-500/20">
                <div class="w-16 h-16 bg-white/20 rounded-2xl flex items-center justify-center mb-4">
                    <i class="ph ph-folder-simple-star text-4xl"></i>
                </div>
                <h3 class="text-xl font-bold mb-2">Galeri Media</h3>
                <p class="text-violet-100 text-sm leading-relaxed">
                    Tampilkan koleksi foto dan video terbaik Anda untuk menginspirasi pengunjung.
                </p>
            </div>

            <!-- Tips Card -->
            <div class="bg-white rounded-2xl p-6 border border-slate-200 shadow-sm">
                <h4 class="font-semibold text-slate-800 mb-4 flex items-center">
                    <i class="ph ph-lightbulb text-amber-500 text-xl mr-2"></i>
                    Tips Upload
                </h4>
                <ul class="space-y-3 text-sm text-slate-600">
                    <li class="flex items-start">
                        <i class="ph ph-check-circle text-green-500 mt-0.5 mr-2 flex-shrink-0"></i>
                        <span>Gunakan resolusi tinggi untuk hasil terbaik</span>
                    </li>
                    <li class="flex items-start">
                        <i class="ph ph-check-circle text-green-500 mt-0.5 mr-2 flex-shrink-0"></i>
                        <span>Kompres video untuk ukuran lebih kecil</span>
                    </li>
                    <li class="flex items-start">
                        <i class="ph ph-check-circle text-green-500 mt-0.5 mr-2 flex-shrink-0"></i>
                        <span>Beri judul yang deskriptif</span>
                    </li>
                </ul>
            </div>

            <!-- Format Card -->
            <div class="bg-white rounded-2xl p-6 border border-slate-200 shadow-sm">
                <h4 class="font-semibold text-slate-800 mb-4 flex items-center">
                    <i class="ph ph-file-image text-blue-500 text-xl mr-2"></i>
                    Format Didukung
                </h4>
                <div class="space-y-3">
                    <div class="flex items-center justify-between p-3 bg-slate-50 rounded-lg">
                        <span class="text-slate-600 flex items-center">
                            <i class="ph ph-image text-violet-500 mr-2"></i> Foto
                        </span>
                        <span class="text-xs font-medium text-slate-500">JPG, PNG, GIF</span>
                    </div>
                    <div class="flex items-center justify-between p-3 bg-slate-50 rounded-lg">
                        <span class="text-slate-600 flex items-center">
                            <i class="ph ph-video text-blue-500 mr-2"></i> Video
                        </span>
                        <span class="text-xs font-medium text-slate-500">MP4, WEBM</span>
                    </div>
                    <div class="flex items-center justify-between p-3 bg-slate-50 rounded-lg">
                        <span class="text-slate-600 flex items-center">
                            <i class="ph ph-hard-drive text-amber-500 mr-2"></i> Maks Size
                        </span>
                        <span class="text-xs font-medium text-slate-500">50 MB</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>
