<?= $this->extend('layout/admin') ?>

<?= $this->section('content') ?>
<div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
    <!-- Form Section -->
    <div class="lg:col-span-2">
        <div class="bg-white rounded-2xl shadow-sm border border-slate-200 overflow-hidden">
            <div class="p-6 border-b border-slate-200 bg-gradient-to-r from-amber-500 to-orange-500">
                <h2 class="font-semibold text-white flex items-center">
                    <i class="ph ph-pencil-simple text-xl mr-2"></i>
                    Edit Bahasa Pemrograman
                </h2>
                <p class="text-amber-100 text-sm mt-1">Perbarui skill programming</p>
            </div>
            
            <form action="<?= base_url('admin/bahasa/update/' . $bahasa['id']) ?>" method="POST" class="p-6">
                <?= csrf_field() ?>
                
                <?php if (session()->getFlashdata('errors')): ?>
                <div class="mb-6 p-4 bg-red-50 border border-red-200 rounded-xl">
                    <ul class="list-disc list-inside text-sm text-red-600">
                        <?php foreach (session()->getFlashdata('errors') as $error): ?>
                        <li><?= $error ?></li>
                        <?php endforeach; ?>
                    </ul>
                </div>
                <?php endif; ?>

                <div class="space-y-5">
                    <div>
                        <label for="nama_bahasa" class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-code text-amber-500 mr-1"></i>
                            Nama Bahasa <span class="text-red-500">*</span>
                        </label>
                        <input type="text" name="nama_bahasa" id="nama_bahasa" value="<?= old('nama_bahasa', $bahasa['nama_bahasa']) ?>" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-amber-500 focus:ring-2 focus:ring-amber-500/20 transition-all" required>
                    </div>

                    <div>
                        <label for="icon_class" class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-smiley text-amber-500 mr-1"></i>
                            Icon Bahasa
                        </label>
                        <select name="icon_class" id="icon_class" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-amber-500 transition-all">
                            <?php foreach ($iconOptions as $key => $option): ?>
                            <option value="<?= $key ?>" <?= $bahasa['icon_class'] === $key ? 'selected' : '' ?>><?= $option['name'] ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div>
                        <label for="tingkat" class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-chart-bar text-amber-500 mr-1"></i>
                            Tingkat Keahlian <span class="text-red-500">*</span>
                        </label>
                        <select name="tingkat" id="tingkat" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-amber-500 transition-all" required>
                            <?php foreach ($tingkatList as $t): ?>
                            <option value="<?= $t ?>" <?= $bahasa['tingkat'] === $t ? 'selected' : '' ?>><?= $t ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div>
                        <label for="urutan" class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-sort-ascending text-amber-500 mr-1"></i>
                            Urutan
                        </label>
                        <input type="number" name="urutan" id="urutan" value="<?= old('urutan', $bahasa['urutan']) ?>" min="0" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-amber-500 focus:ring-2 focus:ring-amber-500/20 transition-all">
                    </div>
                </div>

                <div class="flex items-center justify-end gap-3 mt-8 pt-6 border-t border-slate-200">
                    <a href="<?= base_url('admin/bahasa') ?>" class="px-6 py-3 text-slate-600 hover:bg-slate-100 rounded-xl transition-colors flex items-center">
                        <i class="ph ph-x mr-2"></i>
                        Batal
                    </a>
                    <button type="submit" class="px-6 py-3 bg-gradient-to-r from-amber-500 to-orange-500 text-white rounded-xl hover:from-amber-600 hover:to-orange-600 transition-all shadow-lg shadow-amber-500/25 flex items-center">
                        <i class="ph ph-floppy-disk mr-2"></i>
                        Simpan Perubahan
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Decorative Right Panel -->
    <div class="hidden lg:block">
        <div class="sticky top-24 space-y-6">
            <!-- Current Data Card -->
            <div class="bg-gradient-to-br from-amber-500 to-orange-600 rounded-2xl p-6 text-white shadow-xl shadow-amber-500/20">
                <div class="w-16 h-16 bg-white/20 rounded-2xl flex items-center justify-center mb-4">
                    <i class="ph ph-code text-4xl"></i>
                </div>
                <h3 class="text-xl font-bold mb-2"><?= $bahasa['nama_bahasa'] ?></h3>
                <div class="mt-3 p-3 bg-white/10 rounded-xl">
                    <p class="text-amber-100 text-sm">Tingkat: <span class="font-semibold text-white"><?= $bahasa['tingkat'] ?></span></p>
                </div>
            </div>

            <!-- Info Card -->
            <div class="bg-white rounded-2xl p-6 border border-slate-200 shadow-sm">
                <h4 class="font-semibold text-slate-800 mb-4 flex items-center">
                    <i class="ph ph-info text-blue-500 text-xl mr-2"></i>
                    Informasi Data
                </h4>
                <div class="space-y-3 text-sm">
                    <div class="flex items-center justify-between p-3 bg-slate-50 rounded-lg">
                        <span class="text-slate-500">ID</span>
                        <span class="font-medium text-slate-800">#<?= $bahasa['id'] ?></span>
                    </div>
                    <div class="flex items-center justify-between p-3 bg-slate-50 rounded-lg">
                        <span class="text-slate-500">Urutan</span>
                        <span class="font-medium text-slate-800"><?= $bahasa['urutan'] ?></span>
                    </div>
                </div>
            </div>

            <!-- Quick Actions -->
            <div class="bg-white rounded-2xl p-6 border border-slate-200 shadow-sm">
                <h4 class="font-semibold text-slate-800 mb-4 flex items-center">
                    <i class="ph ph-lightning text-amber-500 text-xl mr-2"></i>
                    Aksi Cepat
                </h4>
                <div class="space-y-2">
                    <a href="<?= base_url('admin/bahasa') ?>" class="flex items-center p-3 bg-slate-50 hover:bg-slate-100 rounded-lg transition-colors">
                        <i class="ph ph-list text-slate-500 mr-3"></i>
                        <span class="text-sm text-slate-700">Kembali ke Daftar</span>
                    </a>
                    <a href="<?= base_url('admin/bahasa/create') ?>" class="flex items-center p-3 bg-blue-50 hover:bg-blue-100 rounded-lg transition-colors">
                        <i class="ph ph-plus-circle text-blue-500 mr-3"></i>
                        <span class="text-sm text-blue-700">Tambah Baru</span>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>
