<?= $this->extend('layout/admin') ?>

<?= $this->section('content') ?>
<div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
    <!-- Form Section -->
    <div class="lg:col-span-2">
        <div class="bg-white rounded-2xl shadow-sm border border-slate-200 overflow-hidden">
            <div class="p-6 border-b border-slate-200 bg-gradient-to-r from-blue-500 to-indigo-600">
                <h2 class="font-semibold text-white flex items-center">
                    <i class="ph ph-code text-xl mr-2"></i>
                    Tambah Bahasa Pemrograman
                </h2>
                <p class="text-blue-100 text-sm mt-1">Tambahkan skill programming Anda</p>
            </div>
            
            <form action="<?= base_url('admin/bahasa/store') ?>" method="POST" class="p-6">
                <?= csrf_field() ?>
                
                <?php if (session()->getFlashdata('errors')): ?>
                <div class="mb-6 p-4 bg-red-50 border border-red-200 rounded-xl">
                    <ul class="list-disc list-inside text-sm text-red-600">
                        <?php foreach (session()->getFlashdata('errors') as $error): ?>
                        <li><?= $error ?></li>
                        <?php endforeach; ?>
                    </ul>
                </div>
                <?php endif; ?>

                <div class="space-y-5">
                    <div>
                        <label for="nama_bahasa" class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-code text-blue-500 mr-1"></i>
                            Nama Bahasa <span class="text-red-500">*</span>
                        </label>
                        <input type="text" name="nama_bahasa" id="nama_bahasa" value="<?= old('nama_bahasa') ?>" placeholder="Contoh: PHP, JavaScript, Python" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-blue-500 focus:ring-2 focus:ring-blue-500/20 transition-all" required>
                    </div>

                    <div>
                        <label for="icon_class" class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-smiley text-blue-500 mr-1"></i>
                            Icon Bahasa
                        </label>
                        <select name="icon_class" id="icon_class" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-blue-500 transition-all">
                            <?php foreach ($iconOptions as $key => $option): ?>
                            <option value="<?= $key ?>" style="color: <?= $option['color'] ?>"><?= $option['name'] ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div>
                        <label for="tingkat" class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-chart-bar text-blue-500 mr-1"></i>
                            Tingkat Keahlian <span class="text-red-500">*</span>
                        </label>
                        <select name="tingkat" id="tingkat" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-blue-500 transition-all" required>
                            <?php foreach ($tingkatList as $t): ?>
                            <option value="<?= $t ?>" <?= old('tingkat') === $t ? 'selected' : '' ?>><?= $t ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div>
                        <label for="urutan" class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-sort-ascending text-blue-500 mr-1"></i>
                            Urutan
                        </label>
                        <input type="number" name="urutan" id="urutan" value="<?= old('urutan', 0) ?>" min="0" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-blue-500 focus:ring-2 focus:ring-blue-500/20 transition-all">
                        <p class="text-xs text-slate-500 mt-1">Angka lebih kecil akan ditampilkan lebih dulu</p>
                    </div>
                </div>

                <div class="flex items-center justify-end gap-3 mt-8 pt-6 border-t border-slate-200">
                    <a href="<?= base_url('admin/bahasa') ?>" class="px-6 py-3 text-slate-600 hover:bg-slate-100 rounded-xl transition-colors flex items-center">
                        <i class="ph ph-x mr-2"></i>
                        Batal
                    </a>
                    <button type="submit" class="px-6 py-3 bg-gradient-to-r from-blue-500 to-indigo-600 text-white rounded-xl hover:from-blue-600 hover:to-indigo-700 transition-all shadow-lg shadow-blue-500/25 flex items-center">
                        <i class="ph ph-floppy-disk mr-2"></i>
                        Simpan
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Decorative Right Panel -->
    <div class="hidden lg:block">
        <div class="sticky top-24 space-y-6">
            <!-- Info Card -->
            <div class="bg-gradient-to-br from-blue-500 to-indigo-600 rounded-2xl p-6 text-white shadow-xl shadow-blue-500/20">
                <div class="w-16 h-16 bg-white/20 rounded-2xl flex items-center justify-center mb-4">
                    <i class="ph ph-brackets-curly text-4xl"></i>
                </div>
                <h3 class="text-xl font-bold mb-2">Bahasa Pemrograman</h3>
                <p class="text-blue-100 text-sm leading-relaxed">
                    Tampilkan keahlian coding Anda untuk menarik perhatian rekruter dan klien.
                </p>
            </div>

            <!-- Tingkat Info Card -->
            <div class="bg-white rounded-2xl p-6 border border-slate-200 shadow-sm">
                <h4 class="font-semibold text-slate-800 mb-4 flex items-center">
                    <i class="ph ph-chart-bar text-blue-500 text-xl mr-2"></i>
                    Level Keahlian
                </h4>
                <div class="space-y-3">
                    <div class="flex items-center p-3 bg-slate-50 rounded-lg">
                        <div class="w-2 h-2 bg-red-500 rounded-full mr-3"></div>
                        <span class="text-sm text-slate-600 flex-1">Pemula</span>
                        <span class="text-xs text-slate-400">Baru belajar</span>
                    </div>
                    <div class="flex items-center p-3 bg-slate-50 rounded-lg">
                        <div class="w-2 h-2 bg-yellow-500 rounded-full mr-3"></div>
                        <span class="text-sm text-slate-600 flex-1">Menengah</span>
                        <span class="text-xs text-slate-400">1-2 tahun</span>
                    </div>
                    <div class="flex items-center p-3 bg-slate-50 rounded-lg">
                        <div class="w-2 h-2 bg-green-500 rounded-full mr-3"></div>
                        <span class="text-sm text-slate-600 flex-1">Mahir</span>
                        <span class="text-xs text-slate-400">2+ tahun</span>
                    </div>
                    <div class="flex items-center p-3 bg-slate-50 rounded-lg">
                        <div class="w-2 h-2 bg-purple-500 rounded-full mr-3"></div>
                        <span class="text-sm text-slate-600 flex-1">Ahli</span>
                        <span class="text-xs text-slate-400">Expert</span>
                    </div>
                </div>
            </div>

            <!-- Popular Languages -->
            <div class="bg-white rounded-2xl p-6 border border-slate-200 shadow-sm">
                <h4 class="font-semibold text-slate-800 mb-4 flex items-center">
                    <i class="ph ph-star text-amber-500 text-xl mr-2"></i>
                    Bahasa Populer
                </h4>
                <div class="flex flex-wrap gap-2">
                    <span class="px-3 py-1.5 bg-yellow-100 text-yellow-700 rounded-full text-xs font-medium">JavaScript</span>
                    <span class="px-3 py-1.5 bg-blue-100 text-blue-700 rounded-full text-xs font-medium">Python</span>
                    <span class="px-3 py-1.5 bg-indigo-100 text-indigo-700 rounded-full text-xs font-medium">PHP</span>
                    <span class="px-3 py-1.5 bg-sky-100 text-sky-700 rounded-full text-xs font-medium">TypeScript</span>
                    <span class="px-3 py-1.5 bg-orange-100 text-orange-700 rounded-full text-xs font-medium">Java</span>
                    <span class="px-3 py-1.5 bg-cyan-100 text-cyan-700 rounded-full text-xs font-medium">Go</span>
                    <span class="px-3 py-1.5 bg-red-100 text-red-700 rounded-full text-xs font-medium">Ruby</span>
                    <span class="px-3 py-1.5 bg-purple-100 text-purple-700 rounded-full text-xs font-medium">C#</span>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>
