<?= $this->extend('layout/admin') ?>

<?= $this->section('content') ?>
<div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
    <!-- Form Section -->
    <div class="lg:col-span-2">
        <div class="bg-white rounded-2xl shadow-sm border border-slate-200 overflow-hidden">
            <div class="p-6 border-b border-slate-200 bg-gradient-to-r from-amber-500 to-orange-500">
                <h2 class="font-semibold text-white flex items-center">
                    <i class="ph ph-pencil-simple text-xl mr-2"></i>
                    Edit Aktivitas
                </h2>
                <p class="text-amber-100 text-sm mt-1">Perbarui dokumentasi aktivitas</p>
            </div>
            
            <form action="<?= base_url('admin/aktivitas/update/' . $aktivitas['id']) ?>" method="POST" enctype="multipart/form-data" class="p-6">
                <?= csrf_field() ?>
                
                <?php if (session()->getFlashdata('errors')): ?>
                <div class="mb-6 p-4 bg-red-50 border border-red-200 rounded-xl">
                    <ul class="list-disc list-inside text-sm text-red-600">
                        <?php foreach (session()->getFlashdata('errors') as $error): ?>
                        <li><?= $error ?></li>
                        <?php endforeach; ?>
                    </ul>
                </div>
                <?php endif; ?>

                <div class="space-y-5" x-data="{ tipe: '<?= old('tipe', $aktivitas['tipe'] ?? 'foto') ?>' }">
                    <!-- Tipe Selection -->
                    <div>
                        <label class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-selection-all text-amber-500 mr-1"></i>
                            Tipe Media <span class="text-red-500">*</span>
                        </label>
                        <div class="flex gap-4">
                            <label class="flex-1 cursor-pointer">
                                <input type="radio" name="tipe" value="foto" x-model="tipe" class="sr-only">
                                <div :class="tipe === 'foto' ? 'border-amber-500 bg-amber-50' : 'border-slate-200 bg-slate-50'" class="border-2 rounded-xl p-4 text-center transition-all">
                                    <i class="ph ph-image text-2xl mb-2" :class="tipe === 'foto' ? 'text-amber-600' : 'text-slate-400'"></i>
                                    <p class="font-medium" :class="tipe === 'foto' ? 'text-amber-600' : 'text-slate-600'">Foto</p>
                                </div>
                            </label>
                            <label class="flex-1 cursor-pointer">
                                <input type="radio" name="tipe" value="video" x-model="tipe" class="sr-only">
                                <div :class="tipe === 'video' ? 'border-amber-500 bg-amber-50' : 'border-slate-200 bg-slate-50'" class="border-2 rounded-xl p-4 text-center transition-all">
                                    <i class="ph ph-video text-2xl mb-2" :class="tipe === 'video' ? 'text-amber-600' : 'text-slate-400'"></i>
                                    <p class="font-medium" :class="tipe === 'video' ? 'text-amber-600' : 'text-slate-600'">Video</p>
                                </div>
                            </label>
                        </div>
                    </div>

                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label for="tanggal" class="block text-sm font-medium text-slate-700 mb-2">
                                <i class="ph ph-calendar text-amber-500 mr-1"></i>
                                Tanggal <span class="text-red-500">*</span>
                            </label>
                            <input type="date" name="tanggal" id="tanggal" value="<?= old('tanggal', $aktivitas['tanggal']) ?>" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-amber-500 focus:ring-2 focus:ring-amber-500/20 transition-all" required>
                        </div>
                        <div>
                            <label for="jam" class="block text-sm font-medium text-slate-700 mb-2">
                                <i class="ph ph-clock text-amber-500 mr-1"></i>
                                Jam <span class="text-red-500">*</span>
                            </label>
                            <input type="time" name="jam" id="jam" value="<?= old('jam', date('H:i', strtotime($aktivitas['jam']))) ?>" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-amber-500 focus:ring-2 focus:ring-amber-500/20 transition-all" required>
                        </div>
                    </div>

                    <div>
                        <label for="nama_aktivitas" class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-text-t text-amber-500 mr-1"></i>
                            Nama Aktivitas <span class="text-red-500">*</span>
                        </label>
                        <input type="text" name="nama_aktivitas" id="nama_aktivitas" value="<?= old('nama_aktivitas', $aktivitas['nama_aktivitas']) ?>" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-amber-500 focus:ring-2 focus:ring-amber-500/20 transition-all" required>
                    </div>

                    <div>
                        <label for="deskripsi" class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-article text-amber-500 mr-1"></i>
                            Deskripsi
                        </label>
                        <textarea name="deskripsi" id="deskripsi" rows="3" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-amber-500 focus:ring-2 focus:ring-amber-500/20 transition-all resize-none"><?= old('deskripsi', $aktivitas['deskripsi']) ?></textarea>
                    </div>

                    <!-- Current Media Preview -->
                    <?php if ($aktivitas['foto'] || $aktivitas['video']): ?>
                    <div class="rounded-xl overflow-hidden bg-slate-100">
                        <?php if ($aktivitas['video']): ?>
                        <video src="<?= base_url('uploads/aktivitas/' . $aktivitas['video']) ?>" controls class="w-full max-h-48 object-contain"></video>
                        <?php elseif ($aktivitas['foto']): ?>
                        <img src="<?= base_url('uploads/aktivitas/' . $aktivitas['foto']) ?>" alt="" class="w-full max-h-48 object-contain">
                        <?php endif; ?>
                    </div>
                    <?php endif; ?>

                    <!-- Foto Upload -->
                    <div>
                        <label class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-image text-amber-500 mr-1"></i>
                            <span x-text="tipe === 'video' ? 'Thumbnail (opsional)' : 'Ganti Foto'"></span>
                        </label>
                        <div class="flex items-center gap-4">
                            <div class="w-24 h-24 rounded-xl overflow-hidden bg-slate-100 border-2 border-dashed border-slate-200" id="foto-preview">
                                <?php if ($aktivitas['foto']): ?>
                                <img src="<?= base_url('uploads/aktivitas/' . $aktivitas['foto']) ?>" class="w-full h-full object-cover">
                                <?php else: ?>
                                <div class="w-full h-full flex items-center justify-center">
                                    <i class="ph ph-image text-3xl text-slate-400"></i>
                                </div>
                                <?php endif; ?>
                            </div>
                            <div class="flex-1">
                                <input type="file" name="foto" id="foto" accept="image/*" class="hidden" onchange="previewFoto(this)">
                                <label for="foto" class="inline-flex items-center px-4 py-2.5 bg-amber-50 text-amber-700 rounded-xl hover:bg-amber-100 transition-colors cursor-pointer border border-amber-200">
                                    <i class="ph ph-upload-simple mr-2"></i>
                                    Pilih Gambar
                                </label>
                            </div>
                        </div>
                    </div>

                    <!-- Video Upload -->
                    <div x-show="tipe === 'video'" x-transition>
                        <label class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-video text-amber-500 mr-1"></i>
                            Ganti Video
                        </label>
                        <div class="border-2 border-dashed border-slate-200 rounded-xl p-6 text-center hover:border-amber-400 transition-colors">
                            <input type="file" name="video" id="video" accept="video/*" class="hidden">
                            <label for="video" class="cursor-pointer">
                                <i class="ph ph-video text-4xl text-slate-400 mb-2"></i>
                                <p class="text-slate-600">Klik untuk upload video baru</p>
                                <p class="text-xs text-slate-400 mt-1">Biarkan kosong jika tidak ingin mengubah</p>
                            </label>
                        </div>
                    </div>
                </div>

                <div class="flex items-center justify-end gap-3 mt-8 pt-6 border-t border-slate-200">
                    <a href="<?= base_url('admin/aktivitas') ?>" class="px-6 py-3 text-slate-600 hover:bg-slate-100 rounded-xl transition-colors flex items-center">
                        <i class="ph ph-x mr-2"></i>
                        Batal
                    </a>
                    <button type="submit" class="px-6 py-3 bg-gradient-to-r from-amber-500 to-orange-500 text-white rounded-xl hover:from-amber-600 hover:to-orange-600 transition-all shadow-lg shadow-amber-500/25 flex items-center">
                        <i class="ph ph-floppy-disk mr-2"></i>
                        Simpan Perubahan
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Decorative Right Panel -->
    <div class="hidden lg:block">
        <div class="sticky top-24 space-y-6">
            <!-- Current Data Card -->
            <div class="bg-gradient-to-br from-amber-500 to-orange-600 rounded-2xl p-6 text-white shadow-xl shadow-amber-500/20">
                <div class="w-16 h-16 bg-white/20 rounded-2xl flex items-center justify-center mb-4 overflow-hidden">
                    <?php if ($aktivitas['foto']): ?>
                    <img src="<?= base_url('uploads/aktivitas/' . $aktivitas['foto']) ?>" class="w-full h-full object-cover">
                    <?php else: ?>
                    <i class="ph ph-image text-4xl"></i>
                    <?php endif; ?>
                </div>
                <h3 class="text-xl font-bold mb-2">Edit Aktivitas</h3>
                <div class="mt-3 p-3 bg-white/10 rounded-xl">
                    <p class="font-semibold text-white truncate"><?= $aktivitas['nama_aktivitas'] ?></p>
                    <p class="text-amber-100 text-sm"><?= date('d M Y', strtotime($aktivitas['tanggal'])) ?></p>
                </div>
            </div>

            <!-- Info Card -->
            <div class="bg-white rounded-2xl p-6 border border-slate-200 shadow-sm">
                <h4 class="font-semibold text-slate-800 mb-4 flex items-center">
                    <i class="ph ph-info text-blue-500 text-xl mr-2"></i>
                    Informasi Media
                </h4>
                <div class="space-y-3 text-sm">
                    <div class="flex items-center justify-between p-3 bg-slate-50 rounded-lg">
                        <span class="text-slate-500">ID</span>
                        <span class="font-medium text-slate-800">#<?= $aktivitas['id'] ?></span>
                    </div>
                    <div class="flex items-center justify-between p-3 bg-slate-50 rounded-lg">
                        <span class="text-slate-500">Tipe</span>
                        <span class="font-medium text-slate-800 capitalize"><?= $aktivitas['tipe'] ?? 'Foto' ?></span>
                    </div>
                    <div class="flex items-center justify-between p-3 bg-slate-50 rounded-lg">
                        <span class="text-slate-500">Waktu</span>
                        <span class="font-medium text-slate-800"><?= date('H:i', strtotime($aktivitas['jam'])) ?></span>
                    </div>
                </div>
            </div>

            <!-- Quick Actions -->
            <div class="bg-white rounded-2xl p-6 border border-slate-200 shadow-sm">
                <h4 class="font-semibold text-slate-800 mb-4 flex items-center">
                    <i class="ph ph-lightning text-amber-500 text-xl mr-2"></i>
                    Aksi Cepat
                </h4>
                <div class="space-y-2">
                    <a href="<?= base_url('admin/aktivitas') ?>" class="flex items-center p-3 bg-slate-50 hover:bg-slate-100 rounded-lg transition-colors">
                        <i class="ph ph-list text-slate-500 mr-3"></i>
                        <span class="text-sm text-slate-700">Kembali ke Daftar</span>
                    </a>
                    <a href="<?= base_url('admin/aktivitas/create') ?>" class="flex items-center p-3 bg-green-50 hover:bg-green-100 rounded-lg transition-colors">
                        <i class="ph ph-plus-circle text-green-500 mr-3"></i>
                        <span class="text-sm text-green-700">Tambah Baru</span>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function previewFoto(input) {
    const file = input.files[0];
    if (file) {
        const reader = new FileReader();
        reader.onload = function(e) {
            document.getElementById('foto-preview').innerHTML = `<img src="${e.target.result}" class="w-full h-full object-cover">`;
        }
        reader.readAsDataURL(file);
    }
}
</script>
<?= $this->endSection() ?>
