<?php 
$pager->setSurroundCount(2);

// Get current page from links array
$links = $pager->links();
$currentPage = 1;
$totalPages = count($links);

foreach ($links as $link) {
    if ($link['active']) {
        $currentPage = (int)$link['title'];
        break;
    }
}

// Get last page number from links
if (!empty($links)) {
    $lastLink = end($links);
    $totalPages = (int)$lastLink['title'];
}
?>

<nav class="flex items-center justify-center gap-2">
    <!-- First & Previous -->
    <?php if ($currentPage > 1): ?>
        <a href="<?= $pager->getFirst() ?>" class="pagination-btn arrow" title="Halaman Pertama">
            <i class="ph-bold ph-caret-double-left"></i>
        </a>
        <a href="<?= $pager->getPreviousPage() ?>" class="pagination-btn arrow" title="Sebelumnya">
            <i class="ph-bold ph-caret-left"></i>
        </a>
    <?php else: ?>
        <span class="pagination-btn disabled">
            <i class="ph-bold ph-caret-double-left"></i>
        </span>
        <span class="pagination-btn disabled">
            <i class="ph-bold ph-caret-left"></i>
        </span>
    <?php endif ?>

    <!-- Page Numbers -->
    <?php foreach ($links as $link): ?>
        <?php if ($link['active']): ?>
            <span class="pagination-btn current"><?= $link['title'] ?></span>
        <?php else: ?>
            <a href="<?= $link['uri'] ?>" class="pagination-btn number"><?= $link['title'] ?></a>
        <?php endif ?>
    <?php endforeach ?>

    <!-- Next & Last -->
    <?php if ($currentPage < $totalPages): ?>
        <a href="<?= $pager->getNextPage() ?>" class="pagination-btn arrow" title="Selanjutnya">
            <i class="ph-bold ph-caret-right"></i>
        </a>
        <a href="<?= $pager->getLast() ?>" class="pagination-btn arrow" title="Halaman Terakhir">
            <i class="ph-bold ph-caret-double-right"></i>
        </a>
    <?php else: ?>
        <span class="pagination-btn disabled">
            <i class="ph-bold ph-caret-right"></i>
        </span>
        <span class="pagination-btn disabled">
            <i class="ph-bold ph-caret-double-right"></i>
        </span>
    <?php endif ?>
</nav>

<style>
.pagination-btn {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 40px;
    height: 40px;
    border-radius: 12px;
    font-weight: 600;
    font-size: 14px;
    transition: all 0.2s ease;
    text-decoration: none;
}

.pagination-btn.arrow {
    background: linear-gradient(135deg, #8b5cf6 0%, #7c3aed 100%);
    color: white;
    box-shadow: 0 4px 12px rgba(139, 92, 246, 0.3);
    cursor: pointer;
}

.pagination-btn.arrow:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 16px rgba(139, 92, 246, 0.4);
}

.pagination-btn.disabled {
    background: #f1f5f9;
    color: #cbd5e1;
    cursor: not-allowed;
}

.pagination-btn.number {
    background: white;
    color: #475569;
    border: 1px solid #e2e8f0;
    cursor: pointer;
}

.pagination-btn.number:hover {
    background: #f8fafc;
    border-color: #8b5cf6;
    color: #8b5cf6;
}

.pagination-btn.current {
    background: linear-gradient(135deg, #8b5cf6 0%, #7c3aed 100%);
    color: white;
    box-shadow: 0 4px 12px rgba(139, 92, 246, 0.3);
}
</style>
