<?php

namespace App\Models;

use CodeIgniter\Model;

class SertifikatModel extends Model
{
    protected $table            = 'tb_sertifikat';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = ['nama_sertifikat', 'penerbit', 'tanggal', 'file_sertifikat', 'credential_url', 'deskripsi'];

    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules = [
        'nama_sertifikat' => 'required|min_length[3]|max_length[255]',
        'penerbit'        => 'required|min_length[2]|max_length[255]',
    ];

    protected $validationMessages = [
        'nama_sertifikat' => [
            'required' => 'Nama sertifikat wajib diisi',
        ],
        'penerbit' => [
            'required' => 'Penerbit sertifikat wajib diisi',
        ],
    ];

    public function getAllOrdered()
    {
        return $this->orderBy('tanggal', 'DESC')->findAll();
    }
}
