<?php

namespace App\Models;

use CodeIgniter\Model;

class PendidikanModel extends Model
{
    protected $table            = 'tb_pendidikan';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = ['jenjang', 'nama_sekolah', 'tahun_masuk', 'tahun_lulus', 'jurusan'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    // Validation
    protected $validationRules = [
        'jenjang'      => 'required|in_list[TK,SD,SMP,SMA,SMK,D1,D2,D3,D4,S1-Sarjana,S2-Magister,S3-Doktor,Profesi,Kursus]',
        'nama_sekolah' => 'required|min_length[3]|max_length[255]',
        'tahun_masuk'  => 'required|numeric|exact_length[4]',
    ];

    protected $validationMessages = [
        'jenjang' => [
            'required' => 'Jenjang pendidikan wajib dipilih',
            'in_list'  => 'Jenjang harus salah satu dari pilihan yang tersedia',
        ],
        'nama_sekolah' => [
            'required'   => 'Nama sekolah/universitas wajib diisi',
            'min_length' => 'Nama sekolah minimal 3 karakter',
        ],
        'tahun_masuk' => [
            'required' => 'Tahun masuk wajib diisi',
            'numeric'  => 'Tahun masuk harus berupa angka',
        ],
    ];

    protected $skipValidation = false;

    // Get pendidikan with search, filter, and pagination
    public function getPendidikan($search = null, $jenjang = null, $sort = 'tahun_masuk', $order = 'DESC')
    {
        if ($search) {
            $this->groupStart()
                 ->like('nama_sekolah', $search)
                 ->orLike('jurusan', $search)
                 ->groupEnd();
        }
        
        if ($jenjang) {
            $this->where('jenjang', $jenjang);
        }
        
        $this->orderBy($sort, $order);
        
        return $this;
    }

    // Get list of jenjang for filter
    public function getJenjangList()
    {
        return [
            'TK',
            'SD',
            'SMP',
            'SMA',
            'SMK',
            'D1',
            'D2',
            'D3',
            'D4',
            'S1-Sarjana',
            'S2-Magister',
            'S3-Doktor',
            'Profesi',
            'Kursus'
        ];
    }
}
