<?php

namespace App\Models;

use CodeIgniter\Model;

class GaleriModel extends Model
{
    protected $table            = 'tb_galeri';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = ['judul', 'deskripsi', 'tipe', 'file', 'thumbnail', 'tanggal'];

    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules = [
        'judul' => 'required|min_length[3]|max_length[255]',
        'tipe'  => 'required|in_list[foto,video]',
    ];

    protected $validationMessages = [
        'judul' => [
            'required' => 'Judul wajib diisi',
        ],
        'tipe' => [
            'required' => 'Tipe media wajib dipilih',
        ],
    ];

    public function getGaleri($search = null, $tipe = null, $sort = 'created_at', $order = 'DESC')
    {
        if ($search) {
            $this->groupStart()
                 ->like('judul', $search)
                 ->orLike('deskripsi', $search)
                 ->groupEnd();
        }
        
        if ($tipe) {
            $this->where('tipe', $tipe);
        }
        
        $this->orderBy($sort, $order);
        
        return $this;
    }

    public function getFotos()
    {
        return $this->where('tipe', 'foto')->orderBy('created_at', 'DESC')->findAll();
    }

    public function getVideos()
    {
        return $this->where('tipe', 'video')->orderBy('created_at', 'DESC')->findAll();
    }

    public function getTipeList()
    {
        return ['foto', 'video'];
    }
}
