<?php

namespace App\Models;

use CodeIgniter\Model;

class BiodataModel extends Model
{
    protected $table            = 'tb_biodata';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = ['nama_lengkap', 'alamat', 'email', 'no_hp', 'deskripsi_diri', 'foto_profil'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    // Validation
    protected $validationRules = [
        'nama_lengkap' => 'required|min_length[3]|max_length[255]',
        'email'        => 'required|valid_email',
    ];

    protected $validationMessages = [
        'nama_lengkap' => [
            'required'   => 'Nama lengkap wajib diisi',
            'min_length' => 'Nama lengkap minimal 3 karakter',
        ],
        'email' => [
            'required'    => 'Email wajib diisi',
            'valid_email' => 'Format email tidak valid',
        ],
    ];

    protected $skipValidation = false;

    // Get first biodata (single record)
    public function getBiodata()
    {
        return $this->first();
    }
}
