<?php

namespace App\Models;

use CodeIgniter\Model;

class AktivitasModel extends Model
{
    protected $table            = 'tb_aktivitas';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = ['tanggal', 'jam', 'nama_aktivitas', 'foto', 'tipe', 'video', 'thumbnail', 'deskripsi'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    // Validation
    protected $validationRules = [
        'tanggal'        => 'required|valid_date',
        'jam'            => 'required',
        'nama_aktivitas' => 'required|min_length[3]|max_length[255]',
    ];

    protected $validationMessages = [
        'tanggal' => [
            'required'   => 'Tanggal wajib diisi',
            'valid_date' => 'Format tanggal tidak valid',
        ],
        'jam' => [
            'required' => 'Jam wajib diisi',
        ],
        'nama_aktivitas' => [
            'required'   => 'Nama aktivitas wajib diisi',
            'min_length' => 'Nama aktivitas minimal 3 karakter',
        ],
    ];

    protected $skipValidation = false;

    // Get aktivitas with search, filter, and pagination
    public function getAktivitas($search = null, $year = null, $sort = 'tanggal', $order = 'DESC')
    {
        if ($search) {
            $this->groupStart()
                 ->like('nama_aktivitas', $search)
                 ->orLike('deskripsi', $search)
                 ->groupEnd();
        }
        
        if ($year) {
            $this->where('YEAR(tanggal)', $year);
        }
        
        $this->orderBy($sort, $order);
        
        return $this;
    }

    // Get available years for filter
    public function getAvailableYears()
    {
        return $this->select('YEAR(tanggal) as year')
                    ->distinct()
                    ->orderBy('year', 'DESC')
                    ->findAll();
    }
}
