<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateTbSertifikat extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'INT',
                'constraint'     => 11,
                'unsigned'       => true,
                'auto_increment' => true,
            ],
            'nama_sertifikat' => [
                'type'       => 'VARCHAR',
                'constraint' => 255,
            ],
            'penerbit' => [
                'type'       => 'VARCHAR',
                'constraint' => 255,
            ],
            'tanggal' => [
                'type' => 'DATE',
                'null' => true,
            ],
            'file_sertifikat' => [
                'type'       => 'VARCHAR',
                'constraint' => 255,
                'null'       => true,
                'comment'    => 'Image file of certificate',
            ],
            'credential_url' => [
                'type'       => 'VARCHAR',
                'constraint' => 500,
                'null'       => true,
                'comment'    => 'URL to verify certificate',
            ],
            'deskripsi' => [
                'type' => 'TEXT',
                'null' => true,
            ],
            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
        ]);

        $this->forge->addKey('id', true);
        $this->forge->createTable('tb_sertifikat');
    }

    public function down()
    {
        $this->forge->dropTable('tb_sertifikat');
    }
}
