<?php

namespace App\Controllers;

use App\Models\BiodataModel;
use App\Models\AktivitasModel;
use App\Models\PendidikanModel;
use App\Models\BahasaModel;
use App\Models\SertifikatModel;

class Home extends BaseController
{
    public function index()
    {
        $biodataModel = new BiodataModel();
        $aktivitasModel = new AktivitasModel();
        $pendidikanModel = new PendidikanModel();
        $bahasaModel = new BahasaModel();
        $sertifikatModel = new SertifikatModel();

        $data = [
            'title' => 'Beranda',
            'biodata' => $biodataModel->first(),
            'aktivitas' => $aktivitasModel->orderBy('tanggal', 'DESC')->findAll(3), // Only 3 on home
            'pendidikan' => $pendidikanModel->orderBy('tahun_masuk', 'DESC')->findAll(3), // Only 3 on home
            'bahasa' => $bahasaModel->orderBy('urutan', 'ASC')->findAll(6), // Only 6 on home
            'sertifikat' => $sertifikatModel->orderBy('tanggal', 'DESC')->findAll(3), // Only 3 on home
        ];

        return view('home/index', $data);
    }
}

