<?php

namespace App\Controllers;

use App\Models\UserModel;

class Auth extends BaseController
{
    public function login()
    {
        // If already logged in, redirect to admin
        if (session()->get('isLoggedIn')) {
            return redirect()->to(base_url('admin'));
        }

        return view('auth/login', ['title' => 'Login']);
    }

    public function attemptLogin()
    {
        $rules = [
            'username' => 'required',
            'password' => 'required',
        ];

        if (!$this->validate($rules)) {
            return redirect()->back()->withInput()->with('error', 'Mohon isi semua field');
        }

        $userModel = new UserModel();
        $username = $this->request->getPost('username');
        $password = $this->request->getPost('password');

        // Check if user exists
        $user = $userModel->where('username', $username)->first();

        if (!$user) {
            return redirect()->back()->withInput()->with('error', 'Username tidak ditemukan');
        }

        // Verify password
        if (!password_verify($password, $user['password'])) {
            return redirect()->back()->withInput()->with('error', 'Password salah');
        }

        // Set session
        session()->set([
            'user_id'      => $user['id'],
            'username'     => $user['username'],
            'email'        => $user['email'],
            'nama_lengkap' => $user['nama_lengkap'],
            'isLoggedIn'   => true,
        ]);

        return redirect()->to(base_url('admin'))->with('success', 'Selamat datang, ' . ($user['nama_lengkap'] ?? $user['username']) . '!');
    }

    public function logout()
    {
        session()->destroy();
        return redirect()->to(base_url('auth/login'))->with('success', 'Berhasil logout');
    }
}
