<?php

namespace App\Controllers;

use App\Models\AktivitasModel;

class Aktivitas extends BaseController
{
    protected $aktivitasModel;

    public function __construct()
    {
        $this->aktivitasModel = new AktivitasModel();
    }

    public function index()
    {
        // Get query parameters
        $search = $this->request->getGet('search');
        $year = $this->request->getGet('year');
        $sort = $this->request->getGet('sort') ?? 'tanggal';
        $order = $this->request->getGet('order') ?? 'DESC';

        // Build query and paginate (let CodeIgniter handle page from URL)
        $aktivitas = $this->aktivitasModel
            ->getAktivitas($search, $year, $sort, $order)
            ->paginate(5);
        
        $pager = $this->aktivitasModel->pager;
        
        // Preserve query parameters in pagination links
        $pager->setPath('aktivitas');
        if ($search) $pager->setOnly(['search', 'year', 'order']);

        $data = [
            'title' => 'Aktivitas',
            'aktivitas' => $aktivitas,
            'pager' => $pager,
            'search' => $search,
            'year' => $year,
            'sort' => $sort,
            'order' => $order,
            'availableYears' => $this->aktivitasModel->getAvailableYears(),
        ];

        return view('aktivitas/index', $data);
    }

    public function detail($id)
    {
        $aktivitas = $this->aktivitasModel->find($id);

        if (!$aktivitas) {
            throw new \CodeIgniter\Exceptions\PageNotFoundException('Aktivitas tidak ditemukan');
        }

        $data = [
            'title' => $aktivitas['nama_aktivitas'],
            'aktivitas' => $aktivitas,
        ];

        return view('aktivitas/detail', $data);
    }
}
