<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\SertifikatModel;

class SertifikatController extends BaseController
{
    protected $sertifikatModel;

    public function __construct()
    {
        $this->sertifikatModel = new SertifikatModel();
    }

    public function index()
    {
        $data = [
            'title' => 'Kelola Sertifikat',
            'sertifikat' => $this->sertifikatModel->getAllOrdered(),
        ];

        return view('admin/sertifikat/index', $data);
    }

    public function create()
    {
        $data = [
            'title' => 'Tambah Sertifikat',
        ];

        return view('admin/sertifikat/create', $data);
    }

    public function store()
    {
        $rules = [
            'nama_sertifikat' => 'required|min_length[3]|max_length[255]',
            'penerbit'        => 'required|min_length[2]|max_length[255]',
        ];

        if (!$this->validate($rules)) {
            return redirect()->back()->withInput()->with('errors', $this->validator->getErrors());
        }

        $data = [
            'nama_sertifikat' => $this->request->getPost('nama_sertifikat'),
            'penerbit'        => $this->request->getPost('penerbit'),
            'tanggal'         => $this->request->getPost('tanggal') ?: null,
            'credential_url'  => $this->request->getPost('credential_url'),
            'deskripsi'       => $this->request->getPost('deskripsi'),
        ];

        // Handle file upload
        $file = $this->request->getFile('file_sertifikat');
        if ($file && $file->isValid() && !$file->hasMoved()) {
            $newName = $file->getRandomName();
            $file->move(FCPATH . 'uploads/sertifikat', $newName);
            $data['file_sertifikat'] = $newName;
        }

        $this->sertifikatModel->insert($data);

        return redirect()->to(base_url('admin/sertifikat'))->with('success', 'Sertifikat berhasil ditambahkan');
    }

    public function edit($id)
    {
        $sertifikat = $this->sertifikatModel->find($id);

        if (!$sertifikat) {
            throw new \CodeIgniter\Exceptions\PageNotFoundException('Sertifikat tidak ditemukan');
        }

        $data = [
            'title' => 'Edit Sertifikat',
            'sertifikat' => $sertifikat,
        ];

        return view('admin/sertifikat/edit', $data);
    }

    public function update($id)
    {
        $sertifikat = $this->sertifikatModel->find($id);

        if (!$sertifikat) {
            throw new \CodeIgniter\Exceptions\PageNotFoundException('Sertifikat tidak ditemukan');
        }

        $rules = [
            'nama_sertifikat' => 'required|min_length[3]|max_length[255]',
            'penerbit'        => 'required|min_length[2]|max_length[255]',
        ];

        if (!$this->validate($rules)) {
            return redirect()->back()->withInput()->with('errors', $this->validator->getErrors());
        }

        $data = [
            'nama_sertifikat' => $this->request->getPost('nama_sertifikat'),
            'penerbit'        => $this->request->getPost('penerbit'),
            'tanggal'         => $this->request->getPost('tanggal') ?: null,
            'credential_url'  => $this->request->getPost('credential_url'),
            'deskripsi'       => $this->request->getPost('deskripsi'),
        ];

        // Handle file upload
        $file = $this->request->getFile('file_sertifikat');
        if ($file && $file->isValid() && !$file->hasMoved()) {
            $newName = $file->getRandomName();
            $file->move(FCPATH . 'uploads/sertifikat', $newName);
            $data['file_sertifikat'] = $newName;

            // Delete old file
            if ($sertifikat['file_sertifikat'] && file_exists(FCPATH . 'uploads/sertifikat/' . $sertifikat['file_sertifikat'])) {
                unlink(FCPATH . 'uploads/sertifikat/' . $sertifikat['file_sertifikat']);
            }
        }

        $this->sertifikatModel->update($id, $data);

        return redirect()->to(base_url('admin/sertifikat'))->with('success', 'Sertifikat berhasil diperbarui');
    }

    public function delete($id)
    {
        $sertifikat = $this->sertifikatModel->find($id);

        if (!$sertifikat) {
            throw new \CodeIgniter\Exceptions\PageNotFoundException('Sertifikat tidak ditemukan');
        }

        // Delete file
        if ($sertifikat['file_sertifikat'] && file_exists(FCPATH . 'uploads/sertifikat/' . $sertifikat['file_sertifikat'])) {
            unlink(FCPATH . 'uploads/sertifikat/' . $sertifikat['file_sertifikat']);
        }

        $this->sertifikatModel->delete($id);

        return redirect()->to(base_url('admin/sertifikat'))->with('success', 'Sertifikat berhasil dihapus');
    }
}
