<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\BahasaModel;

class BahasaController extends BaseController
{
    protected $bahasaModel;

    public function __construct()
    {
        $this->bahasaModel = new BahasaModel();
    }

    public function index()
    {
        $data = [
            'title' => 'Kelola Bahasa Pemrograman',
            'bahasa' => $this->bahasaModel->getAllOrdered(),
        ];

        return view('admin/bahasa/index', $data);
    }

    public function create()
    {
        $data = [
            'title' => 'Tambah Bahasa',
            'tingkatList' => $this->bahasaModel->getTingkatList(),
            'iconOptions' => $this->bahasaModel->getIconOptions(),
        ];

        return view('admin/bahasa/create', $data);
    }

    public function store()
    {
        $rules = [
            'nama_bahasa' => 'required|min_length[1]|max_length[100]',
            'tingkat'     => 'required|in_list[Pemula,Menengah,Mahir,Expert]',
        ];

        if (!$this->validate($rules)) {
            return redirect()->back()->withInput()->with('errors', $this->validator->getErrors());
        }

        $iconOptions = $this->bahasaModel->getIconOptions();
        $iconClass = $this->request->getPost('icon_class');
        $warna = $iconOptions[$iconClass]['color'] ?? '#6366f1';

        $data = [
            'nama_bahasa' => $this->request->getPost('nama_bahasa'),
            'tingkat'     => $this->request->getPost('tingkat'),
            'icon_class'  => $iconClass,
            'warna'       => $warna,
            'urutan'      => $this->request->getPost('urutan') ?? 0,
        ];

        $this->bahasaModel->insert($data);

        return redirect()->to(base_url('admin/bahasa'))->with('success', 'Bahasa berhasil ditambahkan');
    }

    public function edit($id)
    {
        $bahasa = $this->bahasaModel->find($id);

        if (!$bahasa) {
            throw new \CodeIgniter\Exceptions\PageNotFoundException('Bahasa tidak ditemukan');
        }

        $data = [
            'title' => 'Edit Bahasa',
            'bahasa' => $bahasa,
            'tingkatList' => $this->bahasaModel->getTingkatList(),
            'iconOptions' => $this->bahasaModel->getIconOptions(),
        ];

        return view('admin/bahasa/edit', $data);
    }

    public function update($id)
    {
        $bahasa = $this->bahasaModel->find($id);

        if (!$bahasa) {
            throw new \CodeIgniter\Exceptions\PageNotFoundException('Bahasa tidak ditemukan');
        }

        $rules = [
            'nama_bahasa' => 'required|min_length[1]|max_length[100]',
            'tingkat'     => 'required|in_list[Pemula,Menengah,Mahir,Expert]',
        ];

        if (!$this->validate($rules)) {
            return redirect()->back()->withInput()->with('errors', $this->validator->getErrors());
        }

        $iconOptions = $this->bahasaModel->getIconOptions();
        $iconClass = $this->request->getPost('icon_class');
        $warna = $iconOptions[$iconClass]['color'] ?? '#6366f1';

        $data = [
            'nama_bahasa' => $this->request->getPost('nama_bahasa'),
            'tingkat'     => $this->request->getPost('tingkat'),
            'icon_class'  => $iconClass,
            'warna'       => $warna,
            'urutan'      => $this->request->getPost('urutan') ?? 0,
        ];

        $this->bahasaModel->update($id, $data);

        return redirect()->to(base_url('admin/bahasa'))->with('success', 'Bahasa berhasil diperbarui');
    }

    public function delete($id)
    {
        $bahasa = $this->bahasaModel->find($id);

        if (!$bahasa) {
            throw new \CodeIgniter\Exceptions\PageNotFoundException('Bahasa tidak ditemukan');
        }

        $this->bahasaModel->delete($id);

        return redirect()->to(base_url('admin/bahasa'))->with('success', 'Bahasa berhasil dihapus');
    }
}
