<?php
// Test script to check what error occurs

error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "Testing Portfolio Website...\n\n";

// Load CI4
require_once __DIR__ . '/vendor/autoload.php';

// Test HomeController
echo "1. Testing HomeController:\n";
try {
    $db = new mysqli('localhost', 'root', '', 'portfolio_hanif');
    
    // Test biodata
    $result = $db->query("SELECT * FROM biodata LIMIT 1");
    $biodata = $result->fetch_assoc();
    echo "   Biodata: " . ($biodata ? $biodata['name'] : 'No biodata') . "\n";
    
    // Test activities
    $result = $db->query("SELECT * FROM activities WHERE status='publish' LIMIT 3");
    echo "   Activities: " . $result->num_rows . " found\n";
    
    // Test settings
    $result = $db->query("SELECT * FROM settings LIMIT 1");
    $row = $result->fetch_assoc();
    echo "   Settings first row: " . print_r($row, true) . "\n";
    
    // Test educations
    $result = $db->query("SELECT * FROM educations");
    echo "   Educations: " . $result->num_rows . " found\n";
    
    $db->close();
} catch (Exception $e) {
    echo "   Error: " . $e->getMessage() . "\n";
}

echo "\n2. Testing Views:\n";
try {
    // Check if view files exist
    $views = [
        'app/Views/layouts/public.php',
        'app/Views/public/home.php',
        'app/Views/admin/login.php'
    ];
    foreach ($views as $view) {
        echo "   $view: " . (file_exists($view) ? 'EXISTS' : 'MISSING') . "\n";
    }
} catch (Exception $e) {
    echo "   Error: " . $e->getMessage() . "\n";
}

echo "\n3. Checking Helper:\n";
$helperPath = 'app/Helpers/media_helper.php';
echo "   $helperPath: " . (file_exists($helperPath) ? 'EXISTS' : 'MISSING') . "\n";

echo "\nDone!\n";
