<?= $this->extend('layouts/public') ?>

<?= $this->section('content') ?>

<!-- Hero Section with 3D -->
<section class="relative min-h-screen flex items-center justify-center overflow-hidden pt-20">
    <!-- 3D Background Canvas -->
    <canvas id="hero-canvas"></canvas>
    
    <!-- Blobs -->
    <div class="blob blob-1"></div>
    <div class="blob blob-2"></div>
    
    <!-- Content -->
    <div class="relative z-10 max-w-7xl mx-auto px-4 lg:px-8 py-20 lg:py-32">
        <div class="grid lg:grid-cols-2 gap-12 items-center">
            <!-- Left: Text Content -->
            <div class="text-center lg:text-left">
                <div class="inline-flex items-center gap-2 px-4 py-2 rounded-full dark:bg-white/10 bg-gray-100 mb-6 reveal">
                    <span class="w-2 h-2 rounded-full bg-green-400 animate-pulse"></span>
                    <span class="text-sm dark:text-white/80 text-gray-600">Available for freelance projects</span>
                </div>
                
                <h1 class="text-4xl lg:text-6xl font-bold dark:text-white text-gray-900 mb-6 leading-tight reveal">
                    Hi, I'm <span class="gradient-text"><?= esc($biodata['name'] ?? 'Developer') ?></span>
                </h1>
                
                <p class="text-xl dark:text-white/60 text-gray-600 mb-4 reveal">
                    <?= esc($biodata['headline'] ?? 'Full-Stack Developer') ?>
                </p>
                
                <p class="text-lg dark:text-white/50 text-gray-500 mb-8 reveal max-w-xl">
                    <?= esc($biodata['summary'] ?? '') ?>
                </p>
                
                <!-- CTA Buttons -->
                <div class="flex flex-wrap gap-4 justify-center lg:justify-start reveal">
                    <a href="<?= base_url('aktivitas') ?>" class="btn-primary flex items-center gap-2">
                        <i data-lucide="folder-open" class="w-5 h-5"></i>
                        Lihat Portfolio
                    </a>
                    <?php if (!empty($biodata['cv_file'])): ?>
                    <a href="<?= media_url($biodata['cv_file']) ?>" download class="btn-secondary flex items-center gap-2 dark:text-white text-gray-700">
                        <i data-lucide="download" class="w-5 h-5"></i>
                        Download CV
                    </a>
                    <?php endif; ?>
                    <a href="<?= base_url('kontak') ?>" class="btn-secondary flex items-center gap-2 dark:text-white text-gray-700">
                        <i data-lucide="mail" class="w-5 h-5"></i>
                        Kontak
                    </a>
                </div>
                
                <!-- Social Links -->
                <div class="flex gap-3 mt-8 justify-center lg:justify-start reveal">
                    <?php if (!empty($biodata['socials']['github'])): ?>
                    <a href="<?= esc($biodata['socials']['github']) ?>" target="_blank" class="w-10 h-10 rounded-xl dark:bg-white/10 bg-gray-100 flex items-center justify-center hover:bg-primary/20 transition-colors group">
                        <i data-lucide="github" class="w-5 h-5 dark:text-white text-gray-700 group-hover:text-primary"></i>
                    </a>
                    <?php endif; ?>
                    <?php if (!empty($biodata['socials']['linkedin'])): ?>
                    <a href="<?= esc($biodata['socials']['linkedin']) ?>" target="_blank" class="w-10 h-10 rounded-xl dark:bg-white/10 bg-gray-100 flex items-center justify-center hover:bg-primary/20 transition-colors group">
                        <i data-lucide="linkedin" class="w-5 h-5 dark:text-white text-gray-700 group-hover:text-primary"></i>
                    </a>
                    <?php endif; ?>
                    <?php if (!empty($biodata['socials']['twitter'])): ?>
                    <a href="<?= esc($biodata['socials']['twitter']) ?>" target="_blank" class="w-10 h-10 rounded-xl dark:bg-white/10 bg-gray-100 flex items-center justify-center hover:bg-primary/20 transition-colors group">
                        <i data-lucide="twitter" class="w-5 h-5 dark:text-white text-gray-700 group-hover:text-primary"></i>
                    </a>
                    <?php endif; ?>
                </div>
            </div>
            
            <!-- Right: Profile Image or 3D Object Placeholder -->
            <div class="flex justify-center lg:justify-end reveal">
                <div class="relative">
                    <!-- Glow Ring -->
                    <div class="absolute inset-0 rounded-full bg-gradient-to-r from-primary to-accent blur-3xl opacity-30 animate-pulse"></div>
                    
                    <!-- Profile Image Container -->
                    <div class="relative w-64 h-64 lg:w-80 lg:h-80 rounded-full overflow-hidden gradient-border glow">
                        <?php if (!empty($biodata['photo'])): ?>
                            <img src="<?= media_url($biodata['photo']) ?>" 
                                 alt="<?= esc($biodata['name']) ?>" 
                                 class="w-full h-full object-cover"
                                 loading="lazy">
                        <?php else: ?>
                            <div class="w-full h-full bg-gradient-to-br from-primary/20 to-accent/20 flex items-center justify-center">
                                <i data-lucide="user" class="w-24 h-24 dark:text-white/40 text-gray-400"></i>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Scroll Indicator -->
    <div class="absolute bottom-8 left-1/2 -translate-x-1/2 flex flex-col items-center gap-2 reveal">
        <span class="text-sm dark:text-white/40 text-gray-500">Scroll Down</span>
        <div class="w-6 h-10 rounded-full border-2 dark:border-white/30 border-gray-400 flex items-start justify-center p-2">
            <div class="w-1.5 h-3 rounded-full bg-primary animate-bounce"></div>
        </div>
    </div>
</section>

<!-- Stats Section -->
<section class="py-16 relative z-10">
    <div class="max-w-7xl mx-auto px-4 lg:px-8">
        <div class="grid grid-cols-2 lg:grid-cols-4 gap-6 stagger-container">
            <div class="card p-6 text-center stagger-item tilt-card">
                <div class="text-4xl lg:text-5xl font-bold gradient-text mb-2" data-count="<?= $stats['projects'] ?? 0 ?>">
                    <?= $stats['projects'] ?? 0 ?>
                </div>
                <p class="dark:text-white/60 text-gray-600">Projects</p>
            </div>
            <div class="card p-6 text-center stagger-item tilt-card">
                <div class="text-4xl lg:text-5xl font-bold gradient-text mb-2" data-count="<?= $stats['years'] ?? 0 ?>">
                    <?= $stats['years'] ?? 0 ?>+
                </div>
                <p class="dark:text-white/60 text-gray-600">Years Experience</p>
            </div>
            <div class="card p-6 text-center stagger-item tilt-card">
                <div class="text-4xl lg:text-5xl font-bold gradient-text mb-2" data-count="<?= $stats['skills'] ?? 0 ?>">
                    <?= $stats['skills'] ?? 0 ?>
                </div>
                <p class="dark:text-white/60 text-gray-600">Skills</p>
            </div>
            <div class="card p-6 text-center stagger-item tilt-card">
                <div class="text-4xl lg:text-5xl font-bold gradient-text mb-2">
                    100%
                </div>
                <p class="dark:text-white/60 text-gray-600">Dedication</p>
            </div>
        </div>
    </div>
</section>

<!-- Skills Section -->
<?php if (!empty($biodata['skills'])): ?>
<section class="py-16 relative z-10">
    <div class="max-w-7xl mx-auto px-4 lg:px-8">
        <div class="text-center mb-12 reveal">
            <h2 class="text-3xl lg:text-4xl font-bold dark:text-white text-gray-900 mb-4">
                Skills & <span class="gradient-text">Expertise</span>
            </h2>
            <p class="dark:text-white/60 text-gray-600 max-w-2xl mx-auto">
                Teknologi dan keahlian yang saya kuasai untuk membangun solusi digital yang inovatif
            </p>
        </div>
        
        <div class="grid md:grid-cols-2 gap-6 stagger-container">
            <?php foreach ($biodata['skills'] as $skill): ?>
            <div class="card p-6 stagger-item">
                <div class="flex justify-between items-center mb-3">
                    <span class="font-semibold dark:text-white text-gray-900"><?= esc($skill['name']) ?></span>
                    <span class="text-primary font-medium"><?= esc($skill['level']) ?>%</span>
                </div>
                <div class="skill-bar">
                    <div class="skill-bar-fill" style="width: 0%" data-width="<?= esc($skill['level']) ?>%"></div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Tools Section -->
<?php if (!empty($biodata['tools'])): ?>
<section class="py-16 relative z-10">
    <div class="max-w-7xl mx-auto px-4 lg:px-8">
        <div class="text-center mb-12 reveal">
            <h2 class="text-3xl lg:text-4xl font-bold dark:text-white text-gray-900 mb-4">
                Tools & <span class="gradient-text">Technologies</span>
            </h2>
            <p class="dark:text-white/60 text-gray-600 max-w-2xl mx-auto">
                Alat dan teknologi yang saya gunakan sehari-hari
            </p>
        </div>
        
        <div class="flex flex-wrap justify-center gap-4 stagger-container">
            <?php foreach ($biodata['tools'] as $tool): ?>
            <div class="stagger-item px-6 py-3 rounded-xl dark:bg-white/10 bg-gray-100 dark:text-white text-gray-700 font-medium hover:bg-primary/20 transition-colors cursor-default">
                <?= esc($tool) ?>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Recent Activities Section -->
<?php if (!empty($activities)): ?>
<section class="py-16 relative z-10">
    <div class="max-w-7xl mx-auto px-4 lg:px-8">
        <div class="flex justify-between items-center mb-12 reveal">
            <div>
                <h2 class="text-3xl lg:text-4xl font-bold dark:text-white text-gray-900 mb-4">
                    Aktivitas <span class="gradient-text">Terbaru</span>
                </h2>
                <p class="dark:text-white/60 text-gray-600">
                    Project dan kegiatan yang sedang saya kerjakan
                </p>
            </div>
            <a href="<?= base_url('aktivitas') ?>" class="btn-secondary hidden md:flex items-center gap-2 dark:text-white text-gray-700">
                Lihat Semua
                <i data-lucide="arrow-right" class="w-4 h-4"></i>
            </a>
        </div>
        
        <div class="grid md:grid-cols-2 gap-6 stagger-container">
            <?php foreach ($activities as $activity): ?>
            <a href="<?= base_url('aktivitas/' . $activity['slug']) ?>" class="card p-6 group stagger-item tilt-card block">
                <div class="flex items-start gap-4">
                    <!-- Thumbnail -->
                    <div class="w-20 h-20 rounded-xl overflow-hidden flex-shrink-0 bg-gradient-to-br from-primary/20 to-accent/20">
                        <?php if (!empty($activity['thumbnail'])): ?>
                            <img src="<?= media_url($activity['thumbnail']) ?>" 
                                 alt="<?= esc($activity['title']) ?>" 
                                 class="w-full h-full object-cover"
                                 loading="lazy">
                        <?php else: ?>
                            <div class="w-full h-full flex items-center justify-center">
                                <i data-lucide="folder" class="w-8 h-8 text-primary"></i>
                            </div>
                        <?php endif; ?>
                    </div>
                    
                    <!-- Content -->
                    <div class="flex-1 min-w-0">
                        <div class="flex items-center gap-2 mb-2">
                            <?php if (!empty($activity['category'])): ?>
                            <span class="tag"><?= esc($activity['category']) ?></span>
                            <?php endif; ?>
                            <span class="text-sm dark:text-white/40 text-gray-500"><?= format_date($activity['activity_date'], 'd M Y') ?></span>
                        </div>
                        <h3 class="font-semibold dark:text-white text-gray-900 group-hover:text-primary transition-colors mb-2 truncate">
                            <?= esc($activity['title']) ?>
                        </h3>
                        <p class="text-sm dark:text-white/60 text-gray-600 line-clamp-2">
                            <?= excerpt($activity['content'], 100) ?>
                        </p>
                    </div>
                    
                    <!-- Arrow -->
                    <i data-lucide="arrow-up-right" class="w-5 h-5 dark:text-white/40 text-gray-400 group-hover:text-primary transition-colors flex-shrink-0"></i>
                </div>
            </a>
            <?php endforeach; ?>
        </div>
        
        <div class="text-center mt-8 md:hidden reveal">
            <a href="<?= base_url('aktivitas') ?>" class="btn-primary inline-flex items-center gap-2">
                Lihat Semua Aktivitas
                <i data-lucide="arrow-right" class="w-4 h-4"></i>
            </a>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Education Preview -->
<?php if (!empty($educations)): ?>
<section class="py-16 relative z-10">
    <div class="max-w-7xl mx-auto px-4 lg:px-8">
        <div class="flex justify-between items-center mb-12 reveal">
            <div>
                <h2 class="text-3xl lg:text-4xl font-bold dark:text-white text-gray-900 mb-4">
                    Riwayat <span class="gradient-text">Pendidikan</span>
                </h2>
                <p class="dark:text-white/60 text-gray-600">
                    Perjalanan akademik dan prestasi pendidikan
                </p>
            </div>
            <a href="<?= base_url('pendidikan') ?>" class="btn-secondary hidden md:flex items-center gap-2 dark:text-white text-gray-700">
                Lihat Semua
                <i data-lucide="arrow-right" class="w-4 h-4"></i>
            </a>
        </div>
        
        <div class="relative pl-8">
            <div class="timeline-line"></div>
            
            <div class="space-y-8 stagger-container">
                <?php foreach (array_slice($educations, 0, 3) as $edu): ?>
                <div class="relative stagger-item">
                    <div class="timeline-dot top-2"></div>
                    <div class="card p-6 ml-8">
                        <div class="flex items-start gap-4">
                            <?php if (!empty($edu['logo'])): ?>
                            <div class="w-12 h-12 rounded-xl overflow-hidden flex-shrink-0">
                                <img src="<?= media_url($edu['logo']) ?>" 
                                     alt="<?= esc($edu['institution']) ?>" 
                                     class="w-full h-full object-cover"
                                     loading="lazy">
                            </div>
                            <?php else: ?>
                            <div class="w-12 h-12 rounded-xl bg-gradient-to-br from-primary/20 to-accent/20 flex items-center justify-center flex-shrink-0">
                                <i data-lucide="graduation-cap" class="w-6 h-6 text-primary"></i>
                            </div>
                            <?php endif; ?>
                            
                            <div class="flex-1">
                                <div class="flex items-center gap-2 mb-1">
                                    <span class="text-sm text-primary font-medium">
                                        <?= esc($edu['start_year']) ?> - <?= esc($edu['end_year'] ?? 'Sekarang') ?>
                                    </span>
                                </div>
                                <h3 class="font-semibold dark:text-white text-gray-900 mb-1">
                                    <?= esc($edu['institution']) ?>
                                </h3>
                                <?php if (!empty($edu['major'])): ?>
                                <p class="text-sm dark:text-white/60 text-gray-600">
                                    <?= esc($edu['major']) ?>
                                </p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- CTA Section -->
<section class="py-24 relative z-10">
    <div class="max-w-4xl mx-auto px-4 lg:px-8 text-center">
        <div class="card p-12 reveal gradient-border glow">
            <h2 class="text-3xl lg:text-4xl font-bold dark:text-white text-gray-900 mb-4">
                Mari <span class="gradient-text">Berkolaborasi</span>
            </h2>
            <p class="dark:text-white/60 text-gray-600 mb-8 max-w-xl mx-auto">
                Punya project menarik atau ingin berdiskusi? Saya selalu terbuka untuk kolaborasi dan kesempatan baru.
            </p>
            <div class="flex flex-wrap gap-4 justify-center">
                <a href="<?= base_url('kontak') ?>" class="btn-primary flex items-center gap-2">
                    <i data-lucide="send" class="w-5 h-5"></i>
                    Kirim Pesan
                </a>
                <?php if (!empty($biodata['email'])): ?>
                <a href="mailto:<?= esc($biodata['email']) ?>" class="btn-secondary flex items-center gap-2 dark:text-white text-gray-700">
                    <i data-lucide="mail" class="w-5 h-5"></i>
                    <?= esc($biodata['email']) ?>
                </a>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
    // 3D Particle Scene
    (function() {
        const canvas = document.getElementById('hero-canvas');
        if (!canvas || !window.THREE) return;
        
        const scene = new THREE.Scene();
        const camera = new THREE.PerspectiveCamera(75, window.innerWidth / window.innerHeight, 0.1, 1000);
        const renderer = new THREE.WebGLRenderer({ canvas, alpha: true, antialias: true });
        
        renderer.setSize(window.innerWidth, window.innerHeight);
        renderer.setPixelRatio(Math.min(window.devicePixelRatio, 2));
        
        // Create particles
        const particlesGeometry = new THREE.BufferGeometry();
        const particlesCount = 1500;
        const posArray = new Float32Array(particlesCount * 3);
        
        for (let i = 0; i < particlesCount * 3; i++) {
            posArray[i] = (Math.random() - 0.5) * 10;
        }
        
        particlesGeometry.setAttribute('position', new THREE.BufferAttribute(posArray, 3));
        
        const particlesMaterial = new THREE.PointsMaterial({
            size: 0.02,
            color: 0x7C3AED,
            transparent: true,
            opacity: 0.6,
            blending: THREE.AdditiveBlending
        });
        
        const particlesMesh = new THREE.Points(particlesGeometry, particlesMaterial);
        scene.add(particlesMesh);
        
        camera.position.z = 3;
        
        let mouseX = 0;
        let mouseY = 0;
        
        document.addEventListener('mousemove', (event) => {
            mouseX = (event.clientX / window.innerWidth) * 2 - 1;
            mouseY = -(event.clientY / window.innerHeight) * 2 + 1;
        });
        
        function animate() {
            requestAnimationFrame(animate);
            
            particlesMesh.rotation.y += 0.001;
            particlesMesh.rotation.x += 0.0005;
            
            particlesMesh.rotation.y += mouseX * 0.0005;
            particlesMesh.rotation.x += mouseY * 0.0005;
            
            renderer.render(scene, camera);
        }
        
        animate();
        
        // Handle resize
        window.addEventListener('resize', () => {
            camera.aspect = window.innerWidth / window.innerHeight;
            camera.updateProjectionMatrix();
            renderer.setSize(window.innerWidth, window.innerHeight);
        });
    })();
    
    // Animate skill bars on scroll
    gsap.utils.toArray('.skill-bar-fill').forEach((bar) => {
        const width = bar.dataset.width;
        gsap.to(bar, {
            width: width,
            duration: 1.5,
            ease: 'power2.out',
            scrollTrigger: {
                trigger: bar,
                start: 'top 90%',
            }
        });
    });
    
    // Counter animation for stats
    gsap.utils.toArray('[data-count]').forEach((elem) => {
        const count = parseInt(elem.dataset.count);
        gsap.fromTo(elem, 
            { innerText: 0 },
            {
                innerText: count,
                duration: 2,
                ease: 'power2.out',
                snap: { innerText: 1 },
                scrollTrigger: {
                    trigger: elem,
                    start: 'top 90%',
                }
            }
        );
    });
</script>
<?= $this->endSection() ?>
