<?= $this->extend('layouts/public') ?>

<?= $this->section('content') ?>

<!-- Page Header -->
<section class="pt-32 pb-16 relative">
    <div class="blob blob-1 opacity-20"></div>
    <div class="max-w-7xl mx-auto px-4 lg:px-8">
        <div class="text-center reveal">
            <h1 class="text-4xl lg:text-5xl font-bold dark:text-white text-gray-900 mb-4">
                <span class="gradient-text">Pendidikan</span>
            </h1>
            <p class="dark:text-white/60 text-gray-600 max-w-xl mx-auto">
                Riwayat pendidikan dan perjalanan akademik saya
            </p>
        </div>
    </div>
</section>

<!-- Education Timeline -->
<section class="py-8 relative z-10">
    <div class="max-w-4xl mx-auto px-4 lg:px-8">
        <?php if (empty($educations)): ?>
        <div class="text-center py-16 reveal">
            <i data-lucide="graduation-cap" class="w-16 h-16 mx-auto dark:text-white/20 text-gray-300 mb-4"></i>
            <h3 class="text-xl font-semibold dark:text-white text-gray-900 mb-2">Belum ada data pendidikan</h3>
            <p class="dark:text-white/60 text-gray-600">Data pendidikan akan segera ditambahkan.</p>
        </div>
        <?php else: ?>
        <div class="relative pl-8">
            <div class="timeline-line"></div>
            
            <div class="space-y-8 stagger-container">
                <?php foreach ($educations as $edu): ?>
                <div class="relative stagger-item">
                    <div class="timeline-dot top-6"></div>
                    
                    <div class="card p-6 ml-8 tilt-card">
                        <div class="flex items-start gap-4">
                            <!-- Logo -->
                            <?php if (!empty($edu['logo'])): ?>
                            <div class="w-16 h-16 rounded-xl overflow-hidden flex-shrink-0 bg-white">
                                <img src="<?= media_url($edu['logo']) ?>" 
                                     alt="<?= esc($edu['institution']) ?>" 
                                     class="w-full h-full object-contain p-2"
                                     loading="lazy">
                            </div>
                            <?php else: ?>
                            <div class="w-16 h-16 rounded-xl bg-gradient-to-br from-primary/20 to-accent/20 flex items-center justify-center flex-shrink-0">
                                <i data-lucide="graduation-cap" class="w-8 h-8 text-primary"></i>
                            </div>
                            <?php endif; ?>
                            
                            <!-- Content -->
                            <div class="flex-1">
                                <div class="flex items-center gap-3 mb-2">
                                    <span class="px-3 py-1 rounded-lg bg-primary/20 text-primary text-sm font-medium">
                                        <?= esc($edu['start_year']) ?> - <?= esc($edu['end_year'] ?? 'Sekarang') ?>
                                    </span>
                                    <?php if (!empty($edu['location'])): ?>
                                    <span class="dark:text-white/40 text-gray-500 text-sm flex items-center gap-1">
                                        <i data-lucide="map-pin" class="w-4 h-4"></i>
                                        <?= esc($edu['location']) ?>
                                    </span>
                                    <?php endif; ?>
                                </div>
                                
                                <h3 class="text-xl font-bold dark:text-white text-gray-900 mb-2">
                                    <?= esc($edu['institution']) ?>
                                </h3>
                                
                                <?php if (!empty($edu['major'])): ?>
                                <p class="text-primary font-medium mb-3">
                                    <?= esc($edu['major']) ?>
                                </p>
                                <?php endif; ?>
                                
                                <?php if (!empty($edu['description'])): ?>
                                <p class="dark:text-white/60 text-gray-600 leading-relaxed">
                                    <?= esc($edu['description']) ?>
                                </p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endif; ?>
    </div>
</section>

<?= $this->endSection() ?>
