<?= $this->extend('layouts/public') ?>

<?= $this->section('content') ?>

<!-- Page Header -->
<section class="pt-32 pb-16 relative">
    <div class="blob blob-1 opacity-20"></div>
    <div class="max-w-7xl mx-auto px-4 lg:px-8">
        <div class="text-center reveal">
            <h1 class="text-4xl lg:text-5xl font-bold dark:text-white text-gray-900 mb-4">
                <span class="gradient-text">Biodata</span>
            </h1>
            <p class="dark:text-white/60 text-gray-600 max-w-xl mx-auto">
                Profil lengkap dan informasi tentang saya
            </p>
        </div>
    </div>
</section>

<!-- Profile Card -->
<section class="pb-16 relative z-10">
    <div class="max-w-4xl mx-auto px-4 lg:px-8">
        <div class="card p-8 reveal">
            <div class="flex flex-col md:flex-row gap-8 items-center md:items-start">
                <!-- Photo -->
                <div class="relative flex-shrink-0">
                    <div class="w-40 h-40 rounded-2xl overflow-hidden gradient-border glow">
                        <?php if (!empty($biodata['photo'])): ?>
                            <img src="<?= media_url($biodata['photo']) ?>" 
                                 alt="<?= esc($biodata['name']) ?>" 
                                 class="w-full h-full object-cover"
                                 loading="lazy">
                        <?php else: ?>
                            <div class="w-full h-full bg-gradient-to-br from-primary/20 to-accent/20 flex items-center justify-center">
                                <i data-lucide="user" class="w-16 h-16 dark:text-white/40 text-gray-400"></i>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                
                <!-- Info -->
                <div class="flex-1 text-center md:text-left">
                    <h2 class="text-2xl font-bold dark:text-white text-gray-900 mb-2">
                        <?= esc($biodata['name'] ?? 'Nama') ?>
                    </h2>
                    <p class="text-primary font-medium mb-4">
                        <?= esc($biodata['headline'] ?? '') ?>
                    </p>
                    <p class="dark:text-white/60 text-gray-600 mb-6 leading-relaxed">
                        <?= esc($biodata['summary'] ?? '') ?>
                    </p>
                    
                    <!-- Contact Info -->
                    <div class="flex flex-wrap gap-4 justify-center md:justify-start">
                        <?php if (!empty($biodata['email'])): ?>
                        <a href="mailto:<?= esc($biodata['email']) ?>" class="flex items-center gap-2 dark:text-white/70 text-gray-600 hover:text-primary transition-colors">
                            <i data-lucide="mail" class="w-5 h-5"></i>
                            <?= esc($biodata['email']) ?>
                        </a>
                        <?php endif; ?>
                        
                        <?php if (!empty($biodata['phone'])): ?>
                        <span class="flex items-center gap-2 dark:text-white/70 text-gray-600">
                            <i data-lucide="phone" class="w-5 h-5"></i>
                            <?= esc($biodata['phone']) ?>
                        </span>
                        <?php endif; ?>
                        
                        <?php if (!empty($biodata['location'])): ?>
                        <span class="flex items-center gap-2 dark:text-white/70 text-gray-600">
                            <i data-lucide="map-pin" class="w-5 h-5"></i>
                            <?= esc($biodata['location']) ?>
                        </span>
                        <?php endif; ?>
                    </div>
                    
                    <!-- Social Links -->
                    <div class="flex gap-3 mt-6 justify-center md:justify-start">
                        <?php if (!empty($biodata['socials']['github'])): ?>
                        <a href="<?= esc($biodata['socials']['github']) ?>" target="_blank" class="w-10 h-10 rounded-xl dark:bg-white/10 bg-gray-100 flex items-center justify-center hover:bg-primary/20 transition-colors">
                            <i data-lucide="github" class="w-5 h-5 dark:text-white text-gray-700"></i>
                        </a>
                        <?php endif; ?>
                        <?php if (!empty($biodata['socials']['linkedin'])): ?>
                        <a href="<?= esc($biodata['socials']['linkedin']) ?>" target="_blank" class="w-10 h-10 rounded-xl dark:bg-white/10 bg-gray-100 flex items-center justify-center hover:bg-primary/20 transition-colors">
                            <i data-lucide="linkedin" class="w-5 h-5 dark:text-white text-gray-700"></i>
                        </a>
                        <?php endif; ?>
                        <?php if (!empty($biodata['socials']['twitter'])): ?>
                        <a href="<?= esc($biodata['socials']['twitter']) ?>" target="_blank" class="w-10 h-10 rounded-xl dark:bg-white/10 bg-gray-100 flex items-center justify-center hover:bg-primary/20 transition-colors">
                            <i data-lucide="twitter" class="w-5 h-5 dark:text-white text-gray-700"></i>
                        </a>
                        <?php endif; ?>
                        <?php if (!empty($biodata['socials']['instagram'])): ?>
                        <a href="<?= esc($biodata['socials']['instagram']) ?>" target="_blank" class="w-10 h-10 rounded-xl dark:bg-white/10 bg-gray-100 flex items-center justify-center hover:bg-primary/20 transition-colors">
                            <i data-lucide="instagram" class="w-5 h-5 dark:text-white text-gray-700"></i>
                        </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Skills Section -->
<?php if (!empty($biodata['skills'])): ?>
<section class="py-16 relative z-10">
    <div class="max-w-4xl mx-auto px-4 lg:px-8">
        <h2 class="text-2xl font-bold dark:text-white text-gray-900 mb-8 reveal">
            <i data-lucide="zap" class="w-6 h-6 inline-block mr-2 text-primary"></i>
            Skills & Expertise
        </h2>
        
        <div class="grid gap-6 stagger-container">
            <?php foreach ($biodata['skills'] as $skill): ?>
            <div class="card p-6 stagger-item">
                <div class="flex justify-between items-center mb-3">
                    <span class="font-semibold dark:text-white text-gray-900"><?= esc($skill['name']) ?></span>
                    <span class="text-primary font-medium"><?= esc($skill['level']) ?>%</span>
                </div>
                <div class="skill-bar">
                    <div class="skill-bar-fill" style="width: 0%" data-width="<?= esc($skill['level']) ?>%"></div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Tools Section -->
<?php if (!empty($biodata['tools'])): ?>
<section class="py-16 relative z-10">
    <div class="max-w-4xl mx-auto px-4 lg:px-8">
        <h2 class="text-2xl font-bold dark:text-white text-gray-900 mb-8 reveal">
            <i data-lucide="wrench" class="w-6 h-6 inline-block mr-2 text-primary"></i>
            Tools & Technologies
        </h2>
        
        <div class="flex flex-wrap gap-4 stagger-container reveal">
            <?php foreach ($biodata['tools'] as $tool): ?>
            <div class="stagger-item px-6 py-3 rounded-xl dark:bg-white/10 bg-gray-100 dark:text-white text-gray-700 font-medium hover:bg-primary/20 transition-colors cursor-default">
                <?= esc($tool) ?>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Download CV -->
<?php if (!empty($biodata['cv_file'])): ?>
<section class="py-16 relative z-10">
    <div class="max-w-4xl mx-auto px-4 lg:px-8 text-center reveal">
        <div class="card p-8 gradient-border">
            <h3 class="text-xl font-bold dark:text-white text-gray-900 mb-4">
                Ingin tahu lebih lanjut?
            </h3>
            <p class="dark:text-white/60 text-gray-600 mb-6">
                Download CV lengkap saya untuk melihat detail pengalaman dan keahlian
            </p>
            <a href="<?= media_url($biodata['cv_file']) ?>" download class="btn-primary inline-flex items-center gap-2">
                <i data-lucide="download" class="w-5 h-5"></i>
                Download CV
            </a>
        </div>
    </div>
</section>
<?php endif; ?>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
    // Animate skill bars on scroll
    gsap.utils.toArray('.skill-bar-fill').forEach((bar) => {
        const width = bar.dataset.width;
        gsap.to(bar, {
            width: width,
            duration: 1.5,
            ease: 'power2.out',
            scrollTrigger: {
                trigger: bar,
                start: 'top 90%',
            }
        });
    });
</script>
<?= $this->endSection() ?>
