<?= $this->extend('layouts/public') ?>

<?= $this->section('content') ?>

<!-- Article Header -->
<section class="pt-32 pb-8 relative">
    <div class="blob blob-1 opacity-20"></div>
    <div class="max-w-4xl mx-auto px-4 lg:px-8">
        <div class="reveal">
            <!-- Back Button -->
            <a href="<?= base_url('aktivitas') ?>" class="inline-flex items-center gap-2 dark:text-white/60 text-gray-600 hover:text-primary transition-colors mb-8">
                <i data-lucide="arrow-left" class="w-5 h-5"></i>
                Kembali ke Aktivitas
            </a>
            
            <!-- Meta -->
            <div class="flex flex-wrap items-center gap-3 mb-4">
                <?php if (!empty($activity['category'])): ?>
                <span class="tag"><?= esc($activity['category']) ?></span>
                <?php endif; ?>
                <span class="dark:text-white/40 text-gray-500 text-sm">
                    <i data-lucide="calendar" class="w-4 h-4 inline-block mr-1"></i>
                    <?= format_date($activity['activity_date'], 'd F Y') ?>
                </span>
            </div>
            
            <!-- Title -->
            <h1 class="text-3xl lg:text-4xl font-bold dark:text-white text-gray-900 mb-6">
                <?= esc($activity['title']) ?>
            </h1>
            
            <!-- Tags -->
            <?php if (!empty($activity['tags'])): ?>
            <div class="flex flex-wrap gap-2">
                <?php foreach ($activity['tags'] as $tag): ?>
                <span class="text-sm px-3 py-1 rounded-lg dark:bg-white/10 bg-gray-100 dark:text-white/70 text-gray-600">
                    <?= esc($tag) ?>
                </span>
                <?php endforeach; ?>
            </div>
            <?php endif; ?>
        </div>
    </div>
</section>

<!-- Featured Image -->
<?php if (!empty($activity['thumbnail'])): ?>
<section class="pb-8 relative z-10">
    <div class="max-w-4xl mx-auto px-4 lg:px-8">
        <div class="rounded-2xl overflow-hidden reveal">
            <img src="<?= media_url($activity['thumbnail']) ?>" 
                 alt="<?= esc($activity['title']) ?>" 
                 class="w-full h-auto object-cover"
                 loading="lazy">
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Content -->
<section class="py-8 relative z-10">
    <div class="max-w-4xl mx-auto px-4 lg:px-8">
        <article class="prose prose-lg dark:prose-invert max-w-none reveal">
            <div class="dark:text-white/80 text-gray-700 leading-relaxed space-y-6 
                        [&>h2]:text-2xl [&>h2]:font-bold [&>h2]:dark:text-white [&>h2]:text-gray-900 [&>h2]:mt-8 [&>h2]:mb-4
                        [&>h3]:text-xl [&>h3]:font-semibold [&>h3]:dark:text-white [&>h3]:text-gray-900 [&>h3]:mt-6 [&>h3]:mb-3
                        [&>p]:my-4
                        [&>ul]:list-disc [&>ul]:pl-6 [&>ul]:space-y-2
                        [&>ol]:list-decimal [&>ol]:pl-6 [&>ol]:space-y-2
                        [&>li]:dark:text-white/70 [&>li]:text-gray-600
                        [&>blockquote]:border-l-4 [&>blockquote]:border-primary [&>blockquote]:pl-4 [&>blockquote]:italic [&>blockquote]:dark:text-white/60 [&>blockquote]:text-gray-500
                        [&>pre]:bg-gray-900 [&>pre]:p-4 [&>pre]:rounded-xl [&>pre]:overflow-x-auto
                        [&>code]:bg-primary/10 [&>code]:px-2 [&>code]:py-1 [&>code]:rounded [&>code]:text-primary [&>code]:text-sm
                        [&>a]:text-primary [&>a]:underline [&>a]:hover:no-underline">
                <?= $activity['content'] ?>
            </div>
        </article>
    </div>
</section>

<!-- Share & Navigation -->
<section class="py-8 relative z-10">
    <div class="max-w-4xl mx-auto px-4 lg:px-8">
        <div class="flex flex-col sm:flex-row items-center justify-between gap-4 pt-8 border-t dark:border-white/10 border-gray-200 reveal">
            <!-- Share -->
            <div class="flex items-center gap-4">
                <span class="dark:text-white/60 text-gray-600 text-sm">Share:</span>
                <div class="flex gap-2">
                    <a href="https://twitter.com/intent/tweet?url=<?= urlencode(current_url()) ?>&text=<?= urlencode($activity['title']) ?>" 
                       target="_blank"
                       class="w-10 h-10 rounded-xl dark:bg-white/10 bg-gray-100 flex items-center justify-center hover:bg-primary/20 transition-colors">
                        <i data-lucide="twitter" class="w-5 h-5 dark:text-white text-gray-700"></i>
                    </a>
                    <a href="https://www.linkedin.com/shareArticle?mini=true&url=<?= urlencode(current_url()) ?>&title=<?= urlencode($activity['title']) ?>" 
                       target="_blank"
                       class="w-10 h-10 rounded-xl dark:bg-white/10 bg-gray-100 flex items-center justify-center hover:bg-primary/20 transition-colors">
                        <i data-lucide="linkedin" class="w-5 h-5 dark:text-white text-gray-700"></i>
                    </a>
                    <button onclick="navigator.clipboard.writeText('<?= current_url() ?>'); showToast('Link berhasil disalin!');"
                            class="w-10 h-10 rounded-xl dark:bg-white/10 bg-gray-100 flex items-center justify-center hover:bg-primary/20 transition-colors">
                        <i data-lucide="link" class="w-5 h-5 dark:text-white text-gray-700"></i>
                    </button>
                </div>
            </div>
            
            <!-- Back to List -->
            <a href="<?= base_url('aktivitas') ?>" class="btn-secondary flex items-center gap-2 dark:text-white text-gray-700">
                <i data-lucide="grid-3x3" class="w-5 h-5"></i>
                Semua Aktivitas
            </a>
        </div>
    </div>
</section>

<!-- Related Activities -->
<?php if (!empty($related)): ?>
<section class="py-16 relative z-10">
    <div class="max-w-7xl mx-auto px-4 lg:px-8">
        <h2 class="text-2xl font-bold dark:text-white text-gray-900 mb-8 reveal">
            Aktivitas Terkait
        </h2>
        
        <div class="grid md:grid-cols-3 gap-6 stagger-container">
            <?php foreach ($related as $item): ?>
            <a href="<?= base_url('aktivitas/' . $item['slug']) ?>" class="card overflow-hidden group stagger-item">
                <div class="h-40 overflow-hidden bg-gradient-to-br from-primary/20 to-accent/20">
                    <?php if (!empty($item['thumbnail'])): ?>
                        <img src="<?= media_url($item['thumbnail']) ?>" 
                             alt="<?= esc($item['title']) ?>" 
                             class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-500"
                             loading="lazy">
                    <?php else: ?>
                        <div class="w-full h-full flex items-center justify-center">
                            <i data-lucide="image" class="w-8 h-8 text-primary/50"></i>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="p-4">
                    <h3 class="font-semibold dark:text-white text-gray-900 group-hover:text-primary transition-colors line-clamp-2">
                        <?= esc($item['title']) ?>
                    </h3>
                </div>
            </a>
            <?php endforeach; ?>
        </div>
    </div>
</section>
<?php endif; ?>

<?= $this->endSection() ?>
