<!DOCTYPE html>
<html lang="id" class="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    
    <!-- SEO Meta -->
    <title><?= esc($title ?? 'Portfolio') ?></title>
    <meta name="description" content="<?= esc($description ?? '') ?>">
    <meta name="author" content="<?= esc($biodata['name'] ?? '') ?>">
    
    <!-- Open Graph -->
    <meta property="og:type" content="website">
    <meta property="og:title" content="<?= esc($title ?? 'Portfolio') ?>">
    <meta property="og:description" content="<?= esc($description ?? '') ?>">
    <meta property="og:image" content="<?= base_url($settings['og_image'] ?? 'assets/img/og-image.jpg') ?>">
    
    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="<?= esc($title ?? 'Portfolio') ?>">
    <meta name="twitter:description" content="<?= esc($description ?? '') ?>">
    
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@300;400;500;600;700;800&family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Tailwind CSS via CDN -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            darkMode: 'class',
            theme: {
                extend: {
                    colors: {
                        bg: '#050B14',
                        surface: 'rgba(255,255,255,0.06)',
                        'surface-light': 'rgba(0,0,0,0.04)',
                        text: '#EAF0FF',
                        muted: 'rgba(234,240,255,0.68)',
                        primary: '#7C3AED',
                        accent: '#22D3EE',
                        success: '#10B981',
                        danger: '#EF4444',
                    },
                    fontFamily: {
                        sans: ['Plus Jakarta Sans', 'Inter', 'system-ui', 'sans-serif'],
                    },
                },
            },
        }
    </script>
    
    <!-- Alpine.js -->
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    
    <!-- GSAP -->
    <script src="https://cdn.jsdelivr.net/npm/gsap@3.12.5/dist/gsap.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/gsap@3.12.5/dist/ScrollTrigger.min.js"></script>
    
    <!-- Lucide Icons -->
    <script src="https://unpkg.com/lucide@latest/dist/umd/lucide.min.js"></script>
    
    <!-- Three.js for 3D -->
    <script src="https://cdn.jsdelivr.net/npm/three@0.160.0/build/three.min.js"></script>
    
    <style>
        /* Base Styles */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        html {
            scroll-behavior: smooth;
        }
        
        body {
            font-family: 'Plus Jakarta Sans', 'Inter', system-ui, sans-serif;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
            background: linear-gradient(135deg, #050B14 0%, #0D1321 50%, #050B14 100%);
            color: #EAF0FF;
        }
        
        /* Dark Mode Only */
        .dark {
            background: #050B14;
        }
        
        /* Noise Texture */
        .noise-bg::before {
            content: '';
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-image: url("data:image/svg+xml,%3Csvg viewBox='0 0 256 256' xmlns='http://www.w3.org/2000/svg'%3E%3Cfilter id='noise'%3E%3CfeTurbulence type='fractalNoise' baseFrequency='0.9' numOctaves='4' stitchTiles='stitch'/%3E%3C/filter%3E%3Crect width='100%25' height='100%25' filter='url(%23noise)'/%3E%3C/svg%3E");
            opacity: 0.03;
            pointer-events: none;
            z-index: 0;
        }
        
        /* Glassmorphism */
        .glass {
            background: rgba(255, 255, 255, 0.06);
            backdrop-filter: blur(20px);
            -webkit-backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }
        
        /* Gradient Text */
        .gradient-text {
            background: linear-gradient(135deg, #7C3AED 0%, #22D3EE 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        
        /* Gradient Border */
        .gradient-border {
            position: relative;
            background: linear-gradient(135deg, rgba(124, 58, 237, 0.2), rgba(34, 211, 238, 0.2));
            padding: 1px;
            border-radius: 1rem;
        }
        
        .gradient-border::before {
            content: '';
            position: absolute;
            inset: 0;
            border-radius: inherit;
            padding: 1px;
            background: linear-gradient(135deg, #7C3AED, #22D3EE);
            -webkit-mask: linear-gradient(#fff 0 0) content-box, linear-gradient(#fff 0 0);
            -webkit-mask-composite: xor;
            mask-composite: exclude;
        }
        
        /* Glow Effect */
        .glow {
            box-shadow: 0 0 40px rgba(124, 58, 237, 0.3), 0 0 80px rgba(34, 211, 238, 0.1);
        }
        
        .glow-hover:hover {
            box-shadow: 0 0 60px rgba(124, 58, 237, 0.4), 0 0 100px rgba(34, 211, 238, 0.2);
        }
        
        /* Button Styles */
        .btn-primary {
            background: linear-gradient(135deg, #7C3AED 0%, #6D28D9 100%);
            color: white;
            padding: 0.75rem 1.5rem;
            border-radius: 0.75rem;
            font-weight: 600;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 40px rgba(124, 58, 237, 0.4);
        }
        
        .btn-secondary {
            background: rgba(255, 255, 255, 0.1);
            color: #EAF0FF;
            padding: 0.75rem 1.5rem;
            border-radius: 0.75rem;
            font-weight: 600;
            border: 1px solid rgba(255, 255, 255, 0.2);
            transition: all 0.3s ease;
        }
        
        .btn-secondary:hover {
            background: rgba(255, 255, 255, 0.15);
            border-color: rgba(255, 255, 255, 0.3);
        }
        
        /* Card Styles */
        .card {
            background: rgba(255, 255, 255, 0.06);
            border-radius: 1.5rem;
            border: 1px solid rgba(255, 255, 255, 0.1);
            transition: all 0.3s ease;
        }
        
        .card:hover {
            transform: translateY(-4px);
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            border-color: rgba(124, 58, 237, 0.3);
        }
        
        /* Tilt Effect */
        .tilt-card {
            transform-style: preserve-3d;
            perspective: 1000px;
        }
        
        /* Timeline */
        .timeline-line {
            position: absolute;
            left: 1.5rem;
            top: 0;
            bottom: 0;
            width: 2px;
            background: linear-gradient(180deg, #7C3AED 0%, #22D3EE 100%);
        }
        
        .timeline-dot {
            width: 1rem;
            height: 1rem;
            border-radius: 50%;
            background: linear-gradient(135deg, #7C3AED 0%, #22D3EE 100%);
            position: absolute;
            left: 1rem;
            transform: translateX(-50%);
            box-shadow: 0 0 20px rgba(124, 58, 237, 0.5);
        }
        
        /* Skill Bar */
        .skill-bar {
            height: 6px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 3px;
            overflow: hidden;
        }
        
        .skill-bar-fill {
            height: 100%;
            background: linear-gradient(90deg, #7C3AED 0%, #22D3EE 100%);
            border-radius: 3px;
            transition: width 1s ease-out;
        }
        
        /* Navbar */
        .navbar {
            transition: all 0.3s ease;
        }
        
        .navbar.scrolled {
            background: rgba(5, 11, 20, 0.95);
            backdrop-filter: blur(20px);
            -webkit-backdrop-filter: blur(20px);
            box-shadow: 0 4px 30px rgba(0, 0, 0, 0.3);
        }
        
        /* Hero 3D Canvas */
        #hero-canvas {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: 0;
        }
        
        /* Blob Background */
        .blob {
            position: absolute;
            border-radius: 50%;
            filter: blur(80px);
            opacity: 0.3;
            animation: blob-float 8s ease-in-out infinite;
        }
        
        .blob-1 {
            width: 400px;
            height: 400px;
            background: #7C3AED;
            top: -100px;
            right: -100px;
            animation-delay: 0s;
        }
        
        .blob-2 {
            width: 300px;
            height: 300px;
            background: #22D3EE;
            bottom: -50px;
            left: -50px;
            animation-delay: -4s;
        }
        
        @keyframes blob-float {
            0%, 100% {
                transform: translate(0, 0) scale(1);
            }
            33% {
                transform: translate(30px, -30px) scale(1.1);
            }
            66% {
                transform: translate(-20px, 20px) scale(0.9);
            }
        }
        
        /* Page Transitions */
        .page-enter {
            opacity: 0;
            transform: translateY(20px);
        }
        
        .page-enter-active {
            opacity: 1;
            transform: translateY(0);
            transition: all 0.6s ease-out;
        }
        
        /* Tag/Badge */
        .tag {
            display: inline-flex;
            align-items: center;
            padding: 0.25rem 0.75rem;
            font-size: 0.75rem;
            font-weight: 500;
            border-radius: 9999px;
            background: rgba(124, 58, 237, 0.2);
            color: #A78BFA;
            border: 1px solid rgba(124, 58, 237, 0.3);
        }
        
        /* Scrollbar */
        ::-webkit-scrollbar {
            width: 8px;
            height: 8px;
        }
        
        ::-webkit-scrollbar-track {
            background: rgba(255, 255, 255, 0.05);
        }
        
        ::-webkit-scrollbar-thumb {
            background: linear-gradient(180deg, #7C3AED 0%, #22D3EE 100%);
            border-radius: 4px;
        }
        
        ::-webkit-scrollbar-thumb:hover {
            background: #7C3AED;
        }
        
        /* Reveal Animation */
        .reveal {
            opacity: 0;
            transform: translateY(40px);
        }
        
        .reveal.active {
            opacity: 1;
            transform: translateY(0);
        }
        
        /* Focus Styles */
        .focus-ring:focus {
            outline: none;
            box-shadow: 0 0 0 3px rgba(124, 58, 237, 0.5);
        }
        
        /* Image Lazy Load */
        img[loading="lazy"] {
            opacity: 0;
            transition: opacity 0.3s ease;
        }
        
        img[loading="lazy"].loaded {
            opacity: 1;
        }
        
        /* Text Colors for better visibility */
        .text-muted {
            color: rgba(226, 232, 240, 0.7);
        }
        
        .text-body {
            color: #e2e8f0;
        }
        
        /* Improved placeholder colors */
        input::placeholder,
        textarea::placeholder {
            color: rgba(148, 163, 184, 0.7);
        }
        
        /* Form styles */
        input, textarea, select {
            color: #f1f5f9;
        }
        
        select option {
            background-color: #1e293b;
            color: #f1f5f9;
        }
    </style>
</head>
<body class="min-h-screen noise-bg overflow-x-hidden">
    <!-- Navigation -->
    <nav class="navbar fixed top-0 left-0 right-0 z-50 px-4 py-4 lg:px-8" 
         x-data="{ open: false, scrolled: false }"
         @scroll.window="scrolled = (window.pageYOffset > 50)"
         :class="{ 'scrolled': scrolled }">
        <div class="max-w-7xl mx-auto flex items-center justify-between">
            <!-- Logo -->
            <a href="<?= base_url('/') ?>" class="flex items-center gap-2 group">
                <div class="w-10 h-10 rounded-xl bg-gradient-to-br from-primary to-accent flex items-center justify-center text-white font-bold text-lg group-hover:scale-110 transition-transform">
                    H
                </div>
                <span class="font-bold text-lg text-white hidden sm:block">Hanif</span>
            </a>
            
            <!-- Desktop Menu -->
            <div class="hidden md:flex items-center gap-6">
                <a href="<?= base_url('/') ?>" class="flex items-center gap-2 text-slate-300 hover:text-white transition-colors font-medium">
                    <i data-lucide="home" class="w-4 h-4"></i>
                    <span>Home</span>
                </a>
                <a href="<?= base_url('biodata') ?>" class="flex items-center gap-2 text-slate-300 hover:text-white transition-colors font-medium">
                    <i data-lucide="user" class="w-4 h-4"></i>
                    <span>Biodata</span>
                </a>
                <a href="<?= base_url('aktivitas') ?>" class="flex items-center gap-2 text-slate-300 hover:text-white transition-colors font-medium">
                    <i data-lucide="briefcase" class="w-4 h-4"></i>
                    <span>Aktivitas</span>
                </a>
                <a href="<?= base_url('pendidikan') ?>" class="flex items-center gap-2 text-slate-300 hover:text-white transition-colors font-medium">
                    <i data-lucide="graduation-cap" class="w-4 h-4"></i>
                    <span>Pendidikan</span>
                </a>
                <a href="<?= base_url('kontak') ?>" class="flex items-center gap-2 text-slate-300 hover:text-white transition-colors font-medium">
                    <i data-lucide="mail" class="w-4 h-4"></i>
                    <span>Kontak</span>
                </a>
            </div>
            
            <!-- Right Side -->
            <div class="flex items-center gap-3">
                <!-- Login Button -->
                <a href="<?= base_url('admin/login') ?>" class="hidden md:flex items-center gap-2 px-4 py-2 rounded-xl bg-primary/20 text-primary hover:bg-primary/30 transition-colors font-medium text-sm">
                    <i data-lucide="log-in" class="w-4 h-4"></i>
                    <span>Login</span>
                </a>
                
                <!-- Mobile Menu Toggle -->
                <button @click="open = !open" class="md:hidden w-10 h-10 rounded-xl bg-white/10 flex items-center justify-center hover:bg-white/20 transition-colors">
                    <i x-show="!open" data-lucide="menu" class="w-5 h-5 text-white"></i>
                    <i x-show="open" data-lucide="x" class="w-5 h-5 text-white"></i>
                </button>
            </div>
        </div>
        
        <!-- Mobile Menu -->
        <div x-show="open" 
             x-transition:enter="transition ease-out duration-200"
             x-transition:enter-start="opacity-0 -translate-y-4"
             x-transition:enter-end="opacity-1 translate-y-0"
             x-transition:leave="transition ease-in duration-150"
             x-transition:leave-start="opacity-1 translate-y-0"
             x-transition:leave-end="opacity-0 -translate-y-4"
             class="md:hidden absolute top-full left-4 right-4 mt-2 glass rounded-2xl p-4 bg-bg/95">
            <div class="flex flex-col gap-2">
                <a href="<?= base_url('/') ?>" class="flex items-center gap-3 px-4 py-3 rounded-xl hover:bg-white/10 text-white font-medium">
                    <i data-lucide="home" class="w-5 h-5 text-primary"></i>
                    <span>Home</span>
                </a>
                <a href="<?= base_url('biodata') ?>" class="flex items-center gap-3 px-4 py-3 rounded-xl hover:bg-white/10 text-white font-medium">
                    <i data-lucide="user" class="w-5 h-5 text-primary"></i>
                    <span>Biodata</span>
                </a>
                <a href="<?= base_url('aktivitas') ?>" class="flex items-center gap-3 px-4 py-3 rounded-xl hover:bg-white/10 text-white font-medium">
                    <i data-lucide="briefcase" class="w-5 h-5 text-primary"></i>
                    <span>Aktivitas</span>
                </a>
                <a href="<?= base_url('pendidikan') ?>" class="flex items-center gap-3 px-4 py-3 rounded-xl hover:bg-white/10 text-white font-medium">
                    <i data-lucide="graduation-cap" class="w-5 h-5 text-primary"></i>
                    <span>Pendidikan</span>
                </a>
                <a href="<?= base_url('kontak') ?>" class="flex items-center gap-3 px-4 py-3 rounded-xl hover:bg-white/10 text-white font-medium">
                    <i data-lucide="mail" class="w-5 h-5 text-primary"></i>
                    <span>Kontak</span>
                </a>
                <div class="border-t border-white/10 my-2"></div>
                <a href="<?= base_url('admin/login') ?>" class="flex items-center gap-3 px-4 py-3 rounded-xl bg-primary/20 text-primary font-medium">
                    <i data-lucide="log-in" class="w-5 h-5"></i>
                    <span>Login Admin</span>
                </a>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <main class="relative z-10">
        <?= $this->renderSection('content') ?>
    </main>

    <!-- Footer -->
    <footer class="relative z-10 mt-24 border-t border-white/10">
        <div class="max-w-7xl mx-auto px-4 py-12 lg:px-8">
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <!-- Brand -->
                <div>
                    <div class="flex items-center gap-2 mb-4">
                        <div class="w-10 h-10 rounded-xl bg-gradient-to-br from-primary to-accent flex items-center justify-center text-white font-bold text-lg">
                            H
                        </div>
                        <span class="font-bold text-xl text-white">Hanif</span>
                    </div>
                    <p class="text-slate-400 text-sm leading-relaxed">
                        Full-Stack Developer & UI/UX Designer dengan passion dalam menciptakan pengalaman digital yang luar biasa.
                    </p>
                </div>
                
                <!-- Quick Links -->
                <div>
                    <h4 class="font-semibold text-white mb-4">Quick Links</h4>
                    <div class="flex flex-col gap-2">
                        <a href="<?= base_url('biodata') ?>" class="text-slate-400 hover:text-white transition-colors text-sm">Biodata</a>
                        <a href="<?= base_url('aktivitas') ?>" class="text-slate-400 hover:text-white transition-colors text-sm">Aktivitas</a>
                        <a href="<?= base_url('pendidikan') ?>" class="text-slate-400 hover:text-white transition-colors text-sm">Pendidikan</a>
                        <a href="<?= base_url('kontak') ?>" class="text-slate-400 hover:text-white transition-colors text-sm">Kontak</a>
                    </div>
                </div>
                
                <!-- Social Links -->
                <div>
                    <h4 class="font-semibold text-white mb-4">Connect</h4>
                    <div class="flex gap-3">
                        <?php if (!empty($biodata['socials']['github'])): ?>
                        <a href="<?= esc($biodata['socials']['github']) ?>" target="_blank" class="w-10 h-10 rounded-xl bg-white/10 flex items-center justify-center hover:bg-primary/30 transition-colors">
                            <i data-lucide="github" class="w-5 h-5 text-white"></i>
                        </a>
                        <?php endif; ?>
                        <?php if (!empty($biodata['socials']['linkedin'])): ?>
                        <a href="<?= esc($biodata['socials']['linkedin']) ?>" target="_blank" class="w-10 h-10 rounded-xl bg-white/10 flex items-center justify-center hover:bg-primary/30 transition-colors">
                            <i data-lucide="linkedin" class="w-5 h-5 text-white"></i>
                        </a>
                        <?php endif; ?>
                        <?php if (!empty($biodata['socials']['twitter'])): ?>
                        <a href="<?= esc($biodata['socials']['twitter']) ?>" target="_blank" class="w-10 h-10 rounded-xl bg-white/10 flex items-center justify-center hover:bg-primary/30 transition-colors">
                            <i data-lucide="twitter" class="w-5 h-5 text-white"></i>
                        </a>
                        <?php endif; ?>
                        <?php if (!empty($biodata['socials']['instagram'])): ?>
                        <a href="<?= esc($biodata['socials']['instagram']) ?>" target="_blank" class="w-10 h-10 rounded-xl bg-white/10 flex items-center justify-center hover:bg-primary/30 transition-colors">
                            <i data-lucide="instagram" class="w-5 h-5 text-white"></i>
                        </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            
            <!-- Copyright -->
            <div class="mt-12 pt-8 border-t border-white/10 text-center">
                <p class="text-slate-500 text-sm">
                    <?= esc($settings['footer_text'] ?? '© ' . date('Y') . ' All rights reserved.') ?>
                </p>
            </div>
        </div>
    </footer>

    <!-- Toast Container -->
    <div id="toast-container" class="fixed bottom-4 right-4 z-50 flex flex-col gap-2"></div>

    <script>
        // Initialize Lucide Icons
        lucide.createIcons();
        
        // GSAP Scroll Animations
        gsap.registerPlugin(ScrollTrigger);
        
        // Reveal animations
        gsap.utils.toArray('.reveal').forEach((elem) => {
            gsap.fromTo(elem, 
                { opacity: 0, y: 40 },
                {
                    opacity: 1,
                    y: 0,
                    duration: 0.8,
                    ease: 'power2.out',
                    scrollTrigger: {
                        trigger: elem,
                        start: 'top 85%',
                        toggleActions: 'play none none reverse'
                    }
                }
            );
        });
        
        // Stagger animations for cards
        gsap.utils.toArray('.stagger-container').forEach((container) => {
            const cards = container.querySelectorAll('.stagger-item');
            gsap.fromTo(cards,
                { opacity: 0, y: 30 },
                {
                    opacity: 1,
                    y: 0,
                    duration: 0.5,
                    stagger: 0.1,
                    ease: 'power2.out',
                    scrollTrigger: {
                        trigger: container,
                        start: 'top 80%',
                    }
                }
            );
        });
        
        // Toast notification function
        function showToast(message, type = 'success') {
            const container = document.getElementById('toast-container');
            const toast = document.createElement('div');
            const bgColor = type === 'success' ? 'bg-green-500' : type === 'error' ? 'bg-red-500' : 'bg-blue-500';
            
            toast.className = `${bgColor} text-white px-6 py-3 rounded-xl shadow-lg transform translate-x-full transition-transform duration-300`;
            toast.innerHTML = `
                <div class="flex items-center gap-2">
                    <i data-lucide="${type === 'success' ? 'check-circle' : 'alert-circle'}" class="w-5 h-5"></i>
                    <span>${message}</span>
                </div>
            `;
            
            container.appendChild(toast);
            lucide.createIcons();
            
            requestAnimationFrame(() => {
                toast.classList.remove('translate-x-full');
            });
            
            setTimeout(() => {
                toast.classList.add('translate-x-full');
                setTimeout(() => toast.remove(), 300);
            }, 4000);
        }
        
        // Tilt effect for cards
        document.querySelectorAll('.tilt-card').forEach(card => {
            card.addEventListener('mousemove', (e) => {
                const rect = card.getBoundingClientRect();
                const x = e.clientX - rect.left;
                const y = e.clientY - rect.top;
                const centerX = rect.width / 2;
                const centerY = rect.height / 2;
                const rotateX = (y - centerY) / 20;
                const rotateY = (centerX - x) / 20;
                
                card.style.transform = `perspective(1000px) rotateX(${rotateX}deg) rotateY(${rotateY}deg) scale(1.02)`;
            });
            
            card.addEventListener('mouseleave', () => {
                card.style.transform = 'perspective(1000px) rotateX(0) rotateY(0) scale(1)';
            });
        });
        
        // Lazy load images
        document.querySelectorAll('img[loading="lazy"]').forEach(img => {
            img.addEventListener('load', () => img.classList.add('loaded'));
        });
    </script>
    
    <?= $this->renderSection('scripts') ?>
</body>
</html>
