<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<!-- Stats Grid -->
<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 mb-8">
    <div class="card p-6 hover:scale-105 transition-transform">
        <div class="flex items-center gap-4">
            <div class="w-12 h-12 rounded-xl bg-gradient-to-br from-primary/20 to-primary/10 flex items-center justify-center ring-2 ring-primary/30">
                <i data-lucide="folder" class="w-6 h-6 text-primary"></i>
            </div>
            <div>
                <p class="text-2xl font-bold text-slate-100"><?= $stats['total_activities'] ?></p>
                <p class="text-sm text-slate-400">Total Aktivitas</p>
            </div>
        </div>
    </div>
    
    <div class="card p-6 hover:scale-105 transition-transform">
        <div class="flex items-center gap-4">
            <div class="w-12 h-12 rounded-xl bg-gradient-to-br from-success/20 to-success/10 flex items-center justify-center ring-2 ring-success/30">
                <i data-lucide="check-circle" class="w-6 h-6 text-success"></i>
            </div>
            <div>
                <p class="text-2xl font-bold text-slate-100"><?= $stats['published'] ?></p>
                <p class="text-sm text-slate-400">Published</p>
            </div>
        </div>
    </div>
    
    <div class="card p-6 hover:scale-105 transition-transform">
        <div class="flex items-center gap-4">
            <div class="w-12 h-12 rounded-xl bg-gradient-to-br from-accent/20 to-accent/10 flex items-center justify-center ring-2 ring-accent/30">
                <i data-lucide="graduation-cap" class="w-6 h-6 text-accent"></i>
            </div>
            <div>
                <p class="text-2xl font-bold text-slate-100"><?= $stats['total_educations'] ?></p>
                <p class="text-sm text-slate-400">Pendidikan</p>
            </div>
        </div>
    </div>
    
    <div class="card p-6 hover:scale-105 transition-transform">
        <div class="flex items-center gap-4">
            <div class="w-12 h-12 rounded-xl bg-gradient-to-br from-warning/20 to-warning/10 flex items-center justify-center ring-2 ring-warning/30">
                <i data-lucide="mail" class="w-6 h-6 text-warning"></i>
            </div>
            <div>
                <p class="text-2xl font-bold text-slate-100"><?= $stats['unread_messages'] ?></p>
                <p class="text-sm text-slate-400">Pesan Belum Dibaca</p>
            </div>
        </div>
    </div>
</div>

<!-- Quick Actions -->
<div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-8">
    <div class="card p-6">
        <h3 class="font-semibold text-slate-100 mb-4">Quick Actions</h3>
        <div class="flex flex-wrap gap-3">
            <a href="<?= base_url('admin/activities/create') ?>" class="inline-flex items-center gap-2 px-4 py-2 rounded-xl bg-gradient-to-r from-primary to-purple-600 text-white hover:shadow-lg hover:shadow-primary/30 transition-all">
                <i data-lucide="plus" class="w-4 h-4"></i>
                Tambah Aktivitas
            </a>
            <a href="<?= base_url('admin/educations/create') ?>" class="inline-flex items-center gap-2 px-4 py-2 rounded-xl bg-slate-700 text-slate-200 hover:bg-slate-600 transition-colors">
                <i data-lucide="plus" class="w-4 h-4"></i>
                Tambah Pendidikan
            </a>
            <a href="<?= base_url('admin/biodata') ?>" class="inline-flex items-center gap-2 px-4 py-2 rounded-xl bg-slate-700 text-slate-200 hover:bg-slate-600 transition-colors">
                <i data-lucide="edit" class="w-4 h-4"></i>
                Edit Biodata
            </a>
        </div>
    </div>
    
    <div class="card p-6">
        <h3 class="font-semibold text-slate-100 mb-4">Profile Summary</h3>
        <?php if (!empty($biodata)): ?>
        <div class="flex items-center gap-4">
            <?php if (!empty($biodata['photo'])): ?>
            <img src="<?= media_url($biodata['photo']) ?>" alt="Profile" class="w-16 h-16 rounded-xl object-cover ring-2 ring-primary/30">
            <?php else: ?>
            <div class="w-16 h-16 rounded-xl bg-slate-700 flex items-center justify-center">
                <i data-lucide="user" class="w-8 h-8 text-slate-400"></i>
            </div>
            <?php endif; ?>
            <div>
                <p class="font-semibold text-slate-100"><?= esc($biodata['name'] ?? 'Belum diatur') ?></p>
                <p class="text-sm text-slate-400"><?= esc($biodata['headline'] ?? '') ?></p>
            </div>
        </div>
        <?php else: ?>
        <p class="text-slate-400">Biodata belum diatur.</p>
        <?php endif; ?>
    </div>
</div>

<!-- Recent Activities -->
<div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
    <div class="card p-6">
        <div class="flex items-center justify-between mb-4">
            <h3 class="font-semibold text-slate-100">Aktivitas Terbaru</h3>
            <a href="<?= base_url('admin/activities') ?>" class="text-sm text-primary hover:text-primary/80 transition-colors">Lihat Semua</a>
        </div>
        
        <?php if (empty($recent_activities)): ?>
        <p class="text-slate-400 text-center py-8">Belum ada aktivitas.</p>
        <?php else: ?>
        <div class="space-y-3">
            <?php foreach ($recent_activities as $activity): ?>
            <div class="flex items-center gap-3 p-3 rounded-xl hover:bg-slate-700/50 transition-colors">
                <div class="w-10 h-10 rounded-lg bg-primary/20 flex items-center justify-center flex-shrink-0 ring-1 ring-primary/30">
                    <i data-lucide="folder" class="w-5 h-5 text-primary"></i>
                </div>
                <div class="flex-1 min-w-0">
                    <p class="font-medium text-slate-100 truncate"><?= esc($activity['title']) ?></p>
                    <p class="text-xs text-slate-400"><?= date('d M Y', strtotime($activity['created_at'])) ?></p>
                </div>
                <span class="px-2 py-1 rounded-md text-xs <?= $activity['status'] === 'publish' ? 'bg-success/20 text-success ring-1 ring-success/30' : 'bg-slate-700 text-slate-300' ?>">
                    <?= ucfirst($activity['status']) ?>
                </span>
            </div>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>
    </div>
    
    <div class="card p-6">
        <div class="flex items-center justify-between mb-4">
            <h3 class="font-semibold text-slate-100">Pesan Terbaru</h3>
            <a href="<?= base_url('admin/messages') ?>" class="text-sm text-primary hover:text-primary/80 transition-colors">Lihat Semua</a>
        </div>
        
        <?php if (empty($recent_messages)): ?>
        <p class="text-slate-400 text-center py-8">Belum ada pesan.</p>
        <?php else: ?>
        <div class="space-y-3">
            <?php foreach ($recent_messages as $message): ?>
            <div class="flex items-center gap-3 p-3 rounded-xl hover:bg-slate-700/50 transition-colors <?= !$message['is_read'] ? 'bg-primary/10 ring-1 ring-primary/30' : '' ?>">
                <div class="w-10 h-10 rounded-lg bg-accent/20 flex items-center justify-center flex-shrink-0 ring-1 ring-accent/30">
                    <i data-lucide="mail" class="w-5 h-5 text-accent"></i>
                </div>
                <div class="flex-1 min-w-0">
                    <p class="font-medium text-slate-100 truncate"><?= esc($message['name']) ?></p>
                    <p class="text-xs text-slate-400 truncate"><?= esc($message['message']) ?></p>
                </div>
                <?php if (!$message['is_read']): ?>
                <span class="w-2 h-2 rounded-full bg-primary shadow-lg shadow-primary/50"></span>
                <?php endif; ?>
            </div>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>
    </div>
</div>

<?= $this->endSection() ?>
