<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<!-- Header -->
<div class="mb-6">
    <h2 class="text-2xl font-bold text-white">Edit Biodata</h2>
    <p class="text-sm text-slate-300 mt-1">Kelola informasi profil dan data diri</p>
</div>

<div class="card p-6 max-w-4xl">
    <form action="<?= base_url('admin/biodata/update') ?>" method="post" enctype="multipart/form-data" class="space-y-6">
        <?= csrf_field() ?>
        
        <!-- Photo -->
        <div class="grid md:grid-cols-3 gap-6">
            <div class="md:col-span-1">
                <label class="block text-sm font-medium text-slate-200 mb-2">Foto Profil</label>
                <div class="flex flex-col items-center">
                    <?php if (!empty($biodata['photo'])): ?>
                    <img src="<?= media_url($biodata['photo']) ?>" alt="Photo" class="w-32 h-32 rounded-xl object-cover mb-4 ring-2 ring-primary/30">
                    <?php else: ?>
                    <div class="w-32 h-32 rounded-xl bg-slate-700 flex items-center justify-center mb-4 ring-1 ring-slate-600">
                        <i data-lucide="user" class="w-12 h-12 text-slate-500"></i>
                    </div>
                    <?php endif; ?>
                    <input type="file" name="photo" accept="image/*" class="text-sm text-slate-300 file:mr-4 file:py-2 file:px-4 file:rounded-lg file:border-0 file:bg-primary/20 file:text-primary hover:file:bg-primary/30 file:transition-colors file:cursor-pointer cursor-pointer">
                </div>
            </div>
            
            <div class="md:col-span-2 space-y-4">
                <div>
                    <label class="block text-sm font-medium text-slate-200 mb-2">Nama Lengkap *</label>
                    <input type="text" name="name" value="<?= esc($biodata['name'] ?? '') ?>" class="w-full px-4 py-3 rounded-xl border border-slate-600/50 bg-dark-300/50 text-white placeholder-slate-500 focus:border-primary focus:ring-2 focus:ring-primary/30 outline-none transition-all" required>
                </div>
                
                <div>
                    <label class="block text-sm font-medium text-slate-200 mb-2">Headline</label>
                    <input type="text" name="headline" value="<?= esc($biodata['headline'] ?? '') ?>" class="w-full px-4 py-3 rounded-xl border border-slate-600/50 bg-dark-300/50 text-white placeholder-slate-500 focus:border-primary focus:ring-2 focus:ring-primary/30 outline-none transition-all" placeholder="Full-Stack Developer">
                </div>
            </div>
        </div>
        
        <!-- Summary -->
        <div>
            <label class="block text-sm font-medium text-slate-200 mb-2">Ringkasan/Bio</label>
            <textarea name="summary" rows="4" class="w-full px-4 py-3 rounded-xl border border-slate-600/50 bg-dark-300/50 text-white placeholder-slate-500 focus:border-primary focus:ring-2 focus:ring-primary/30 outline-none resize-none transition-all" placeholder="Ceritakan tentang diri Anda..."><?= esc($biodata['summary'] ?? '') ?></textarea>
        </div>
        
        <!-- Contact -->
        <div>
            <label class="block text-sm font-semibold text-white mb-4">Informasi Kontak</label>
            <div class="grid md:grid-cols-3 gap-4">
                <div>
                    <label class="block text-sm font-medium text-slate-300 mb-2">Email</label>
                    <input type="email" name="email" value="<?= esc($biodata['email'] ?? '') ?>" class="w-full px-4 py-3 rounded-xl border border-slate-600/50 bg-dark-300/50 text-white placeholder-slate-500 focus:border-primary focus:ring-2 focus:ring-primary/30 outline-none transition-all" placeholder="email@example.com">
                </div>
                <div>
                    <label class="block text-sm font-medium text-slate-300 mb-2">Telepon</label>
                    <input type="text" name="phone" value="<?= esc($biodata['phone'] ?? '') ?>" class="w-full px-4 py-3 rounded-xl border border-slate-600/50 bg-dark-300/50 text-white placeholder-slate-500 focus:border-primary focus:ring-2 focus:ring-primary/30 outline-none transition-all" placeholder="+62 812 3456 7890">
                </div>
                <div>
                    <label class="block text-sm font-medium text-slate-300 mb-2">Lokasi</label>
                    <input type="text" name="location" value="<?= esc($biodata['location'] ?? '') ?>" class="w-full px-4 py-3 rounded-xl border border-slate-600/50 bg-dark-300/50 text-white placeholder-slate-500 focus:border-primary focus:ring-2 focus:ring-primary/30 outline-none transition-all" placeholder="Jakarta, Indonesia">
                </div>
            </div>
        </div>
        
        <!-- Social Links -->
        <div>
            <label class="block text-sm font-semibold text-white mb-4">Social Links</label>
            <div class="grid md:grid-cols-2 gap-4">
                <div>
                    <label class="block text-sm text-slate-400 mb-2 flex items-center gap-2">
                        <i data-lucide="github" class="w-4 h-4"></i> GitHub
                    </label>
                    <input type="url" name="github" value="<?= esc($biodata['socials']['github'] ?? '') ?>" class="w-full px-4 py-3 rounded-xl border border-slate-600/50 bg-dark-300/50 text-white placeholder-slate-500 focus:border-primary focus:ring-2 focus:ring-primary/30 outline-none transition-all" placeholder="https://github.com/username">
                </div>
                <div>
                    <label class="block text-sm text-slate-400 mb-2 flex items-center gap-2">
                        <i data-lucide="linkedin" class="w-4 h-4"></i> LinkedIn
                    </label>
                    <input type="url" name="linkedin" value="<?= esc($biodata['socials']['linkedin'] ?? '') ?>" class="w-full px-4 py-3 rounded-xl border border-slate-600/50 bg-dark-300/50 text-white placeholder-slate-500 focus:border-primary focus:ring-2 focus:ring-primary/30 outline-none transition-all" placeholder="https://linkedin.com/in/username">
                </div>
                <div>
                    <label class="block text-sm text-slate-400 mb-2 flex items-center gap-2">
                        <i data-lucide="twitter" class="w-4 h-4"></i> Twitter
                    </label>
                    <input type="url" name="twitter" value="<?= esc($biodata['socials']['twitter'] ?? '') ?>" class="w-full px-4 py-3 rounded-xl border border-slate-600/50 bg-dark-300/50 text-white placeholder-slate-500 focus:border-primary focus:ring-2 focus:ring-primary/30 outline-none transition-all" placeholder="https://twitter.com/username">
                </div>
                <div>
                    <label class="block text-sm text-slate-400 mb-2 flex items-center gap-2">
                        <i data-lucide="instagram" class="w-4 h-4"></i> Instagram
                    </label>
                    <input type="url" name="instagram" value="<?= esc($biodata['socials']['instagram'] ?? '') ?>" class="w-full px-4 py-3 rounded-xl border border-slate-600/50 bg-dark-300/50 text-white placeholder-slate-500 focus:border-primary focus:ring-2 focus:ring-primary/30 outline-none transition-all" placeholder="https://instagram.com/username">
                </div>
            </div>
        </div>
        
        <!-- Skills -->
        <div x-data="{ skills: <?= htmlspecialchars(json_encode($biodata['skills'] ?? [['name' => '', 'level' => 50]]), ENT_QUOTES) ?> }">
            <label class="block text-sm font-semibold text-white mb-4">Skills</label>
            <div class="space-y-3">
                <template x-for="(skill, index) in skills" :key="index">
                    <div class="flex items-center gap-3">
                        <input type="text" :name="'skills[' + index + '][name]'" x-model="skill.name" class="flex-1 px-4 py-3 rounded-xl border border-slate-600/50 bg-dark-300/50 text-white placeholder-slate-500 focus:border-primary focus:ring-2 focus:ring-primary/30 outline-none transition-all" placeholder="Nama skill (e.g. JavaScript)">
                        <input type="number" :name="'skills[' + index + '][level]'" x-model="skill.level" min="0" max="100" class="w-24 px-4 py-3 rounded-xl border border-slate-600/50 bg-dark-300/50 text-white placeholder-slate-500 focus:border-primary focus:ring-2 focus:ring-primary/30 outline-none text-center transition-all" placeholder="%">
                        <button type="button" @click="skills.splice(index, 1)" class="p-3 rounded-lg hover:bg-danger/20 text-slate-400 hover:text-danger transition-all">
                            <i data-lucide="trash-2" class="w-5 h-5"></i>
                        </button>
                    </div>
                </template>
            </div>
            <button type="button" @click="skills.push({ name: '', level: 50 })" class="mt-3 text-sm text-primary hover:text-primary/80 flex items-center gap-2 transition-colors">
                <i data-lucide="plus-circle" class="w-4 h-4"></i>
                Tambah Skill
            </button>
        </div>
        
        <!-- Tools -->
        <div>
            <label class="block text-sm font-semibold text-white mb-2">Tools & Technologies</label>
            <p class="text-xs text-slate-400 mb-3">Pisahkan dengan koma</p>
            <input type="text" name="tools" value="<?= esc(implode(', ', $biodata['tools'] ?? [])) ?>" class="w-full px-4 py-3 rounded-xl border border-slate-600/50 bg-dark-300/50 text-white placeholder-slate-500 focus:border-primary focus:ring-2 focus:ring-primary/30 outline-none transition-all" placeholder="VS Code, Git, Docker, Figma, Node.js">
        </div>
        
        <!-- CV File -->
        <div>
            <label class="block text-sm font-semibold text-white mb-2">File CV (PDF)</label>
            <?php if (!empty($biodata['cv_file'])): ?>
            <p class="text-sm text-slate-300 mb-3 flex items-center gap-2">
                <i data-lucide="file-text" class="w-4 h-4 text-primary"></i>
                Current: <a href="<?= media_url($biodata['cv_file']) ?>" target="_blank" class="text-primary hover:text-primary/80 underline"><?= basename($biodata['cv_file']) ?></a>
            </p>
            <?php endif; ?>
            <input type="file" name="cv_file" accept=".pdf" class="text-sm text-slate-300 file:mr-4 file:py-2 file:px-4 file:rounded-lg file:border-0 file:bg-primary/20 file:text-primary hover:file:bg-primary/30 file:transition-colors file:cursor-pointer cursor-pointer">
        </div>
        
        <!-- Submit -->
        <div class="flex justify-end pt-6 border-t border-slate-700/50">
            <button type="submit" class="px-6 py-3 rounded-xl bg-gradient-to-r from-primary to-purple-600 text-white font-medium hover:shadow-lg hover:shadow-primary/30 transition-all flex items-center gap-2">
                <i data-lucide="save" class="w-5 h-5"></i>
                Simpan Perubahan
            </button>
        </div>
    </form>
</div>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
    // Reinitialize icons for Alpine.js dynamic content
    setInterval(() => lucide.createIcons(), 500);
</script>
<?= $this->endSection() ?>
