<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class EducationSeeder extends Seeder
{
    public function run()
    {
        $educations = [
            [
                'institution' => 'Universitas Indonesia',
                'major'       => 'Teknik Informatika',
                'start_year'  => 2018,
                'end_year'    => 2022,
                'description' => 'Menyelesaikan program Sarjana Teknik Informatika dengan predikat Cum Laude. Fokus pada bidang Software Engineering dan Web Development. Aktif dalam organisasi mahasiswa dan berbagai kegiatan akademik.',
                'location'    => 'Depok, Indonesia',
                'logo'        => null,
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s'),
            ],
            [
                'institution' => 'SMA Negeri 1 Jakarta',
                'major'       => 'IPA (Ilmu Pengetahuan Alam)',
                'start_year'  => 2015,
                'end_year'    => 2018,
                'description' => 'Menyelesaikan pendidikan menengah atas dengan nilai rata-rata yang sangat baik. Aktif dalam kegiatan ekstrakurikuler coding dan robotik.',
                'location'    => 'Jakarta, Indonesia',
                'logo'        => null,
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s'),
            ],
            [
                'institution' => 'SMP Negeri 1 Jakarta',
                'major'       => null,
                'start_year'  => 2012,
                'end_year'    => 2015,
                'description' => 'Pendidikan menengah pertama dengan prestasi akademik dan non-akademik yang baik.',
                'location'    => 'Jakarta, Indonesia',
                'logo'        => null,
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s'),
            ],
        ];

        foreach ($educations as $education) {
            $this->db->table('educations')->insert($education);
        }
    }
}
