<?php

namespace App\Controllers;

use App\Models\BiodataModel;
use App\Models\ActivityModel;
use App\Models\EducationModel;
use App\Models\SettingsModel;

class HomeController extends BaseController
{
    protected $biodataModel;
    protected $activityModel;
    protected $educationModel;
    protected $settingsModel;

    public function __construct()
    {
        $this->biodataModel = new BiodataModel();
        $this->activityModel = new ActivityModel();
        $this->educationModel = new EducationModel();
        $this->settingsModel = new SettingsModel();
        helper('media');
    }

    public function index()
    {
        $biodata = $this->biodataModel->getBiodata();
        $activities = $this->activityModel->getPublished(4);
        $educations = $this->educationModel->getAllOrdered();
        $settings = $this->settingsModel->getAllSettings();

        // Count stats
        $totalActivities = $this->activityModel->where('status', 'publish')->countAllResults();
        
        $data = [
            'title'       => $settings['site_title'] ?? 'Portfolio',
            'description' => $settings['meta_description'] ?? '',
            'biodata'     => $biodata,
            'activities'  => $activities,
            'educations'  => $educations,
            'settings'    => $settings,
            'stats'       => [
                'projects' => $totalActivities,
                'years'    => date('Y') - 2020,
                'skills'   => count($biodata['skills'] ?? []),
            ],
        ];

        return view('public/home', $data);
    }
}
