<?php

namespace App\Controllers;

use App\Models\ContactMessageModel;
use App\Models\SettingsModel;

class ContactController extends BaseController
{
    protected $messageModel;
    protected $settingsModel;

    public function __construct()
    {
        $this->messageModel = new ContactMessageModel();
        $this->settingsModel = new SettingsModel();
        helper('media');
    }

    public function index()
    {
        $settings = $this->settingsModel->getAllSettings();

        $data = [
            'title'       => 'Kontak - ' . ($settings['site_title'] ?? 'Portfolio'),
            'description' => 'Hubungi saya untuk kolaborasi atau pertanyaan',
            'settings'    => $settings,
        ];

        return view('public/contact', $data);
    }

    public function send()
    {
        // Validate input
        $rules = [
            'name'    => 'required|max_length[255]',
            'email'   => 'required|valid_email|max_length[255]',
            'message' => 'required|max_length[5000]',
        ];

        if (!$this->validate($rules)) {
            return $this->response->setJSON([
                'success' => false,
                'errors'  => $this->validator->getErrors(),
            ]);
        }

        // Save message
        $data = [
            'name'    => $this->request->getPost('name'),
            'email'   => $this->request->getPost('email'),
            'message' => $this->request->getPost('message'),
            'is_read' => 0,
        ];

        if ($this->messageModel->insert($data)) {
            return $this->response->setJSON([
                'success' => true,
                'message' => 'Pesan berhasil dikirim! Terima kasih telah menghubungi.',
            ]);
        }

        return $this->response->setJSON([
            'success' => false,
            'message' => 'Gagal mengirim pesan. Silakan coba lagi.',
        ]);
    }
}
