<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\SettingsModel;

class SettingsController extends BaseController
{
    protected $settingsModel;

    public function __construct()
    {
        $this->settingsModel = new SettingsModel();
        helper('media');
    }

    public function index()
    {
        $settings = $this->settingsModel->getAllSettings();

        $data = [
            'title'    => 'Pengaturan',
            'settings' => $settings,
        ];

        return view('admin/settings/edit', $data);
    }

    public function update()
    {
        // Update each setting
        $keys = [
            'site_title',
            'site_description',
            'meta_description',
            'footer_text',
        ];

        foreach ($keys as $key) {
            $value = $this->request->getPost($key);
            $this->settingsModel->setSetting($key, $value);
        }

        // Handle OG image upload
        $ogImage = $this->request->getFile('og_image');
        if ($ogImage && $ogImage->isValid() && !$ogImage->hasMoved()) {
            $oldImage = $this->settingsModel->get('og_image');
            if ($oldImage) {
                delete_media($oldImage);
            }
            $newImage = upload_media($ogImage, 'settings');
            if ($newImage) {
                $this->settingsModel->setSetting('og_image', $newImage);
            }
        }

        return redirect()->to('/admin/settings')->with('success', 'Pengaturan berhasil diperbarui!');
    }
}
