<?php

namespace App\Controllers;

use App\Models\ActivityModel;
use App\Models\SettingsModel;

class ActivityController extends BaseController
{
    protected $activityModel;
    protected $settingsModel;

    public function __construct()
    {
        $this->activityModel = new ActivityModel();
        $this->settingsModel = new SettingsModel();
        helper('media');
    }

    public function index()
    {
        $settings = $this->settingsModel->getAllSettings();
        
        // Get filters
        $category = $this->request->getGet('category');
        $search = $this->request->getGet('search');
        
        // Get activities based on filters
        if (!empty($search)) {
            $activities = $this->activityModel->search($search);
        } elseif (!empty($category)) {
            $activities = $this->activityModel->getByCategory($category);
        } else {
            $activities = $this->activityModel->getPublished();
        }
        
        // Get categories for filter
        $categories = $this->activityModel->getCategories();

        $data = [
            'title'       => 'Aktivitas - ' . ($settings['site_title'] ?? 'Portfolio'),
            'description' => 'Daftar aktivitas, project, dan kegiatan',
            'activities'  => $activities,
            'categories'  => $categories,
            'settings'    => $settings,
            'currentCategory' => $category,
            'searchQuery' => $search,
        ];

        return view('public/activity/index', $data);
    }

    public function detail($slug)
    {
        $settings = $this->settingsModel->getAllSettings();
        $activity = $this->activityModel->getBySlug($slug);

        if (!$activity) {
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
        }

        // Get related activities (same category)
        $related = [];
        if (!empty($activity['category'])) {
            $related = $this->activityModel
                ->where('category', $activity['category'])
                ->where('id !=', $activity['id'])
                ->where('status', 'publish')
                ->limit(3)
                ->findAll();
        }

        $data = [
            'title'       => $activity['title'] . ' - ' . ($settings['site_title'] ?? 'Portfolio'),
            'description' => excerpt($activity['content'], 160),
            'activity'    => $activity,
            'related'     => $related,
            'settings'    => $settings,
        ];

        return view('public/activity/detail', $data);
    }
}
