<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */

// ============================================
// PUBLIC ROUTES
// ============================================
$routes->get('/', 'HomeController::index');
$routes->get('biodata', 'BiodataController::index');

// Activities
$routes->get('aktivitas', 'ActivityController::index');
$routes->get('aktivitas/(:segment)', 'ActivityController::detail/$1');

// Education
$routes->get('pendidikan', 'EducationController::index');

// Contact
$routes->get('kontak', 'ContactController::index');
$routes->post('kontak/send', 'ContactController::send');

// ============================================
// ADMIN AUTH ROUTES (No Filter)
// ============================================
$routes->group('admin', static function ($routes) {
    $routes->get('login', 'Admin\AuthController::login', ['filter' => null]);
    $routes->post('login', 'Admin\AuthController::attemptLogin', ['filter' => null]);
    $routes->get('logout', 'Admin\AuthController::logout');
});

// ============================================
// ADMIN PANEL ROUTES (Protected)
// ============================================
$routes->group('admin', ['namespace' => 'App\Controllers\Admin', 'filter' => 'adminauth'], static function ($routes) {
    // Dashboard
    $routes->get('/', 'DashboardController::index');
    $routes->get('dashboard', 'DashboardController::index');
    
    // Biodata (Single Record)
    $routes->get('biodata', 'BiodataAdminController::edit');
    $routes->post('biodata/update', 'BiodataAdminController::update');
    
    // Activities CRUD
    $routes->get('activities', 'ActivityAdminController::index');
    $routes->get('activities/create', 'ActivityAdminController::create');
    $routes->post('activities/store', 'ActivityAdminController::store');
    $routes->get('activities/edit/(:num)', 'ActivityAdminController::edit/$1');
    $routes->post('activities/update/(:num)', 'ActivityAdminController::update/$1');
    $routes->post('activities/delete/(:num)', 'ActivityAdminController::delete/$1');
    
    // Education CRUD
    $routes->get('educations', 'EducationAdminController::index');
    $routes->get('educations/create', 'EducationAdminController::create');
    $routes->post('educations/store', 'EducationAdminController::store');
    $routes->get('educations/edit/(:num)', 'EducationAdminController::edit/$1');
    $routes->post('educations/update/(:num)', 'EducationAdminController::update/$1');
    $routes->post('educations/delete/(:num)', 'EducationAdminController::delete/$1');
    
    // Settings
    $routes->get('settings', 'SettingsController::index');
    $routes->post('settings/update', 'SettingsController::update');
    
    // Contact Messages
    $routes->get('messages', 'MessagesController::index');
    $routes->get('messages/read/(:num)', 'MessagesController::read/$1');
    $routes->post('messages/delete/(:num)', 'MessagesController::delete/$1');
});

// 404 Override
$routes->set404Override('App\Controllers\ErrorController::show404');
