# 🚀 Hanif Portfolio - Modern CI4 Website

Website portfolio modern "berkarakter" dengan **CodeIgniter 4** sebagai backend. Dilengkapi halaman publik yang elegan, admin panel lengkap, dan UI/UX premium dengan animasi 3D.

![PHP](https://img.shields.io/badge/PHP-8.1+-777BB4?logo=php&logoColor=white)
![CodeIgniter](https://img.shields.io/badge/CodeIgniter-4.5-EF4223?logo=codeigniter&logoColor=white)
![Tailwind CSS](https://img.shields.io/badge/Tailwind-3.0-38B2AC?logo=tailwind-css&logoColor=white)

## ✨ Features

### 🌐 Public Pages
- **Home** - Hero 3D particles, stats counter, skills showcase
- **Biodata** - Profile card, skills progress bars, tools grid
- **Aktivitas** - Timeline dengan filter & search
- **Pendidikan** - Education timeline yang elegan
- **Kontak** - Form AJAX dengan validasi
- **404** - Custom error page

### 🔐 Admin Panel
- Dashboard dengan statistik
- CRUD Biodata (single record)
- CRUD Aktivitas dengan thumbnail
- CRUD Pendidikan dengan logo institusi
- Manajemen Pesan Kontak
- Pengaturan Website

### 🎨 UI/UX
- Dark mode + Light mode toggle
- Glassmorphism design
- GSAP scroll animations
- Three.js 3D particle hero
- Responsive (mobile-first)
- Micro-interactions (hover, tilt)

## 🛠️ Tech Stack

| Layer | Technology |
|-------|------------|
| Backend | CodeIgniter 4.5.x, PHP 8.1+ |
| Database | MySQL 8.0+ |
| Frontend | Tailwind CSS 3, Alpine.js 3 |
| Animations | GSAP 3, ScrollTrigger |
| 3D | Three.js |
| Icons | Lucide Icons |
| Fonts | Plus Jakarta Sans, Inter |

## 📦 Installation

### Prerequisites
- PHP >= 8.1
- MySQL >= 8.0
- Composer
- XAMPP / Laragon

### Step 1: Database Setup
Buat database baru di MySQL:
```sql
CREATE DATABASE portfolio_hanif;
```

### Step 2: Configure Environment
Copy dan rename file `env` menjadi `.env`:
```bash
copy env .env
```

Edit `.env` sesuai konfigurasi database Anda:
```ini
CI_ENVIRONMENT = development
app.baseURL = 'http://localhost:8080/'

database.default.hostname = localhost
database.default.database = portfolio_hanif
database.default.username = root
database.default.password = 
database.default.DBDriver = MySQLi
```

### Step 3: Run Migrations
```bash
php spark migrate
```

### Step 4: Seed Database
```bash
php spark db:seed DatabaseSeeder
```

### Step 5: Start Server
```bash
php spark serve
```

Akses website:
- **Public**: http://localhost:8080/
- **Admin**: http://localhost:8080/admin/login

## 🔑 Default Admin Credentials

| Field | Value |
|-------|-------|
| Username | `admin` |
| Password | `Admin#2025` |

> ⚠️ **Penting**: Ganti password setelah login pertama!

## 📁 Project Structure

```
hanif/
├── app/
│   ├── Config/
│   │   ├── Routes.php          # Routing
│   │   └── Filters.php         # Auth filter config
│   ├── Controllers/
│   │   ├── HomeController.php
│   │   ├── BiodataController.php
│   │   ├── ActivityController.php
│   │   ├── EducationController.php
│   │   ├── ContactController.php
│   │   └── Admin/              # Admin controllers
│   ├── Database/
│   │   ├── Migrations/         # 6 migration files
│   │   └── Seeds/              # 5 seeder files
│   ├── Filters/
│   │   └── AdminAuthFilter.php
│   ├── Helpers/
│   │   └── media_helper.php
│   ├── Models/                 # 6 model files
│   └── Views/
│       ├── layouts/            # public.php, admin.php
│       ├── public/             # Public pages
│       └── admin/              # Admin pages
├── public/
│   └── uploads/                # Media uploads
├── .env                        # Environment config
└── README.md
```

## ✅ Feature Checklist

### Public Frontend
- [x] Home page dengan 3D particles
- [x] Biodata page dengan skills & tools
- [x] Aktivitas index dengan filter & search
- [x] Aktivitas detail dengan related posts
- [x] Pendidikan timeline
- [x] Kontak form AJAX
- [x] Custom 404 page
- [x] Dark/Light mode toggle
- [x] Responsive design
- [x] GSAP scroll animations

### Admin Panel
- [x] Login dengan session auth
- [x] Dashboard dengan stats
- [x] CRUD Biodata
- [x] CRUD Aktivitas
- [x] CRUD Pendidikan
- [x] View Pesan Kontak
- [x] Pengaturan Website
- [x] Protected routes (AdminAuthFilter)

### Technical
- [x] MVC Structure
- [x] Database Migrations
- [x] Database Seeders
- [x] Media Upload Helper
- [x] CSRF Protection
- [x] Input Validation
- [x] XSS Prevention (esc())
- [x] Soft Delete (Activities)

## 🎨 Color Palette

```css
--bg:      #050B14   /* Deep Navy */
--surface: rgba(255,255,255,0.06)
--text:    #EAF0FF
--primary: #7C3AED   /* Violet */
--accent:  #22D3EE   /* Cyan */
--success: #10B981
--danger:  #EF4444
```

## 📝 Notes

### Changing Admin Password
1. Login ke admin panel
2. Generate hash baru: `php spark hash:password NewPassword`
3. Update di database atau buat seeder baru

### Upload Configuration
- Max file size: 5MB
- Allowed types: JPEG, PNG, GIF, WebP, PDF
- Upload path: `/public/uploads/`

### SEO
- Meta tags per halaman
- Open Graph support
- Twitter Card support

## 📄 License

MIT License - Feel free to use for personal or commercial projects.

---

Made with ❤️ using CodeIgniter 4
