<?= $this->extend('layout/post_layout') ?>

<?= $this->section('content') ?>

<h2 class="section-heading">Biodata</h2>

<div class="search-filter-section">
    <form method="get" action="<?= base_url('biodata') ?>" class="w-100">
        <div class="row">
            <div class="col-md-4 mb-2">
                <input type="text" name="search" class="form-control" placeholder="Cari nama, alamat, email..." value="<?= esc($search) ?>">
            </div>
            <div class="col-md-3 mb-2">
                <select name="filter_agama" class="form-control" style="color: #1E293B !important; font-weight: 600; background: white;">
                    <option value="" style="color: #64748B;">Semua Agama</option>
                    <option value="Islam" style="color: #1E293B;" <?= $filter_agama == 'Islam' ? 'selected' : '' ?>>Islam</option>
                    <option value="Kristen" style="color: #1E293B;" <?= $filter_agama == 'Kristen' ? 'selected' : '' ?>>Kristen</option>
                    <option value="Katolik" style="color: #1E293B;" <?= $filter_agama == 'Katolik' ? 'selected' : '' ?>>Katolik</option>
                    <option value="Hindu" style="color: #1E293B;" <?= $filter_agama == 'Hindu' ? 'selected' : '' ?>>Hindu</option>
                    <option value="Buddha" style="color: #1E293B;" <?= $filter_agama == 'Buddha' ? 'selected' : '' ?>>Buddha</option>
                    <option value="Konghucu" style="color: #1E293B;" <?= $filter_agama == 'Konghucu' ? 'selected' : '' ?>>Konghucu</option>
                </select>
            </div>
            <div class="col-md-2 mb-2">
                <button type="submit" class="btn btn-primary w-100">Cari</button>
            </div>
            <div class="col-md-3 mb-2">
                <a href="<?= base_url('biodata') ?>" class="btn btn-secondary w-100">Reset</a>
            </div>
        </div>
    </form>
</div>

<div class="sorting-links">
    <small><strong>Urutkan:</strong></small>
    <a href="<?= base_url('biodata?sort_by=nama&sort_order=' . ($sort_by == 'nama' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_agama=' . urlencode($filter_agama)) ?>">
        Nama <?= $sort_by == 'nama' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
    </a>
    <a href="<?= base_url('biodata?sort_by=email&sort_order=' . ($sort_by == 'email' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_agama=' . urlencode($filter_agama)) ?>">
        Email <?= $sort_by == 'email' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
    </a>
    <a href="<?= base_url('biodata?sort_by=tanggal_lahir&sort_order=' . ($sort_by == 'tanggal_lahir' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_agama=' . urlencode($filter_agama)) ?>">
        Tanggal Lahir <?= $sort_by == 'tanggal_lahir' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
    </a>
</div>

<?php if (empty($biodata)): ?>
    <div class="alert alert-info">Tidak ada data biodata.</div>
<?php else: ?>
    <?php foreach ($biodata as $bio): ?>
        <article class="cv-card mb-4">
            <div>
                <?php if (!empty($bio['foto_profil'])): ?>
                    <div class="cv-photo">
                        <img src="<?= base_url($bio['foto_profil']) ?>" alt="Foto Profil">
                    </div>
                <?php else: ?>
                    <div class="cv-photo cv-photo-placeholder">No Photo</div>
                <?php endif; ?>
            </div>
            <div class="cv-info">
                <p class="text-muted mb-4"><?= esc($bio['deskripsi'] ?? 'Profil singkat tidak tersedia.') ?></p>
                <dl>
                    <dt>Nama</dt>
                    <dd><?= esc($bio['nama']) ?></dd>
                    <dt>Alamat</dt>
                    <dd><?= esc($bio['alamat']) ?></dd>
                    <dt>Tempat, Tanggal Lahir</dt>
                    <dd><?= esc($bio['tempat_lahir']) ?>, <?= $bio['tanggal_lahir'] ? date('d-m-Y', strtotime($bio['tanggal_lahir'])) : '-' ?></dd>
                    <dt>Jenis Kelamin</dt>
                    <dd><?= esc($bio['jenis_kelamin']) ?></dd>
                    <dt>Agama</dt>
                    <dd><?= esc($bio['agama']) ?></dd>
                    <dt>No. HP</dt>
                    <dd><?= esc($bio['no_hp']) ?></dd>
                    <dt>Email</dt>
                    <dd><?= esc($bio['email']) ?></dd>
                </dl>
            </div>
        </article>
    <?php endforeach; ?>

    <div class="mt-4">
        <?= $pager->links() ?>
    </div>
<?php endif; ?>

<?= $this->endSection() ?>



