<?= $this->extend('layout/admin/admin_layout') ?>

<?= $this->section('content') ?>

<div class="admin-page-header">
    <h1>Data Riwayat Pendidikan</h1>
</div>

<div class="admin-card">
    <a href="<?= base_url('admin/education/new') ?>" class="admin-btn admin-btn-primary mb-3">Tambah Pendidikan Baru</a>

    <?php if (session()->getFlashdata('message')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert" id="successAlert">
            <?= esc(session()->getFlashdata('message')) ?>
            <button type="button" class="btn-close" onclick="document.getElementById('successAlert').style.display='none'" aria-label="Close">&times;</button>
        </div>
    <?php endif; ?>

    <!-- Search and Filter Form -->
    <form method="get" action="<?= base_url('admin/education') ?>" class="mb-4">
        <div class="row">
            <div class="col-md-4 mb-2">
                <input type="text" name="search" class="admin-form-control" placeholder="Cari sekolah atau jurusan..." value="<?= esc($search) ?>">
            </div>
            <div class="col-md-3 mb-2">
                <select name="filter_jenjang" class="admin-form-control">
                    <option value="">Semua Jenjang</option>
                    <option value="TK" <?= $filter_jenjang == 'TK' ? 'selected' : '' ?>>TK</option>
                    <option value="SD" <?= $filter_jenjang == 'SD' ? 'selected' : '' ?>>SD</option>
                    <option value="SMP" <?= $filter_jenjang == 'SMP' ? 'selected' : '' ?>>SMP</option>
                    <option value="SMA" <?= $filter_jenjang == 'SMA' ? 'selected' : '' ?>>SMK</option>
                    <option value="S1" <?= $filter_jenjang == 'S1' ? 'selected' : '' ?>>S1</option>
                    <option value="S2" <?= $filter_jenjang == 'S2' ? 'selected' : '' ?>>S2</option>
                    <option value="S3" <?= $filter_jenjang == 'S3' ? 'selected' : '' ?>>S3</option>
                </select>
            </div>
            <div class="col-md-2 mb-2">
                <button type="submit" class="admin-btn admin-btn-primary w-100">Cari</button>
            </div>
            <div class="col-md-3 mb-2">
                <a href="<?= base_url('admin/education') ?>" class="admin-btn admin-btn-secondary w-100">Reset</a>
            </div>
        </div>
    </form>

    <!-- Sorting Links -->
    <div class="mb-3 admin-sort-links">
        <span class="admin-sort-links-label">Urutkan:</span>
        <a href="<?= base_url('admin/education?sort_by=tahun_mulai&sort_order=' . ($sort_by == 'tahun_mulai' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_jenjang=' . urlencode($filter_jenjang)) ?>"
           class="<?= $sort_by == 'tahun_mulai' ? 'active' : '' ?>">
            Tahun Mulai <?= $sort_by == 'tahun_mulai' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
        </a>
        <a href="<?= base_url('admin/education?sort_by=tahun_selesai&sort_order=' . ($sort_by == 'tahun_selesai' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_jenjang=' . urlencode($filter_jenjang)) ?>"
           class="<?= $sort_by == 'tahun_selesai' ? 'active' : '' ?>">
            Tahun Selesai <?= $sort_by == 'tahun_selesai' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
        </a>
        <a href="<?= base_url('admin/education?sort_by=jenjang&sort_order=' . ($sort_by == 'jenjang' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_jenjang=' . urlencode($filter_jenjang)) ?>"
           class="<?= $sort_by == 'jenjang' ? 'active' : '' ?>">
            Jenjang <?= $sort_by == 'jenjang' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
        </a>
        <a href="<?= base_url('admin/education?sort_by=nama_sekolah&sort_order=' . ($sort_by == 'nama_sekolah' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_jenjang=' . urlencode($filter_jenjang)) ?>"
           class="<?= $sort_by == 'nama_sekolah' ? 'active' : '' ?>">
            Nama Sekolah <?= $sort_by == 'nama_sekolah' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
        </a>
    </div>
</div>

<div class="admin-card">
    <div class="table-responsive">
        <table class="admin-table">
<thead>
<tr>
    <th>#</th>
    <th>Jenjang</th>
    <th>Nama Sekolah</th>
    <th>Jurusan</th>
    <th>Tahun Mulai</th>
    <th>Tahun Selesai</th>
    <th>IPK</th>
    <th>Action</th>
</tr>
</thead>
<tbody>
<?php 
$no = 1 + (10 * ($pager->getCurrentPage() - 1));
foreach($educations as $edu): 
?>
<tr>
    <td><?= $no++ ?></td>
    <td><?= esc($edu['jenjang'] === 'SMA' ? 'SMK' : $edu['jenjang']) ?></td>
    <td><?= esc($edu['nama_sekolah']) ?></td>
    <td><?= esc($edu['jurusan']) ?></td>
    <td><?= esc($edu['tahun_mulai']) ?></td>
    <td><?= ($edu['tahun_selesai'] == '9999' || $edu['tahun_selesai'] == '0000' || empty($edu['tahun_selesai'])) ? '<span style="color: var(--admin-success); font-weight: 700;">Sekarang</span>' : esc($edu['tahun_selesai']) ?></td>
    <td><?= esc($edu['ipk']) ?></td>
    <td>
        <div class="action-buttons">
            <a href="<?= base_url('education') ?>" class="admin-btn admin-btn-preview" target="_blank">Preview</a>
            <a href="<?= base_url('admin/education/'.$edu['id'].'/edit') ?>" class="admin-btn admin-btn-edit">Edit</a>
            <a href="<?= base_url('admin/education/'.$edu['id'].'/delete') ?>" onclick="return confirm('Yakin ingin menghapus data ini?');" class="admin-btn admin-btn-delete">Delete</a>
        </div>
    </td>
</tr>
<?php endforeach ?>
</tbody>
        </table>
    </div>
</div>

<!-- Pagination -->
<div class="mt-4">
    <?= $pager->links() ?>
</div>

<?= $this->endSection() ?>







