<?= $this->extend('layout/admin/admin_layout') ?>

<?= $this->section('content') ?>

<div class="admin-page-header">
    <h1>Biodata</h1>
</div>

<div class="admin-card">
    <a href="<?= base_url('admin/biodata/new') ?>" class="admin-btn admin-btn-primary mb-3">Tambah Biodata Baru</a>

    <?php if (session()->getFlashdata('message')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert" id="successAlert">
            <?= esc(session()->getFlashdata('message')) ?>
            <button type="button" class="btn-close" onclick="document.getElementById('successAlert').style.display='none'" aria-label="Close">&times;</button>
        </div>
    <?php endif; ?>

    <!-- Search and Filter Form -->
    <form method="get" action="<?= base_url('admin/biodata') ?>" class="mb-4">
        <div class="row">
            <div class="col-md-4 mb-2">
                <input type="text" name="search" class="admin-form-control" placeholder="Cari nama, alamat, email..." value="<?= esc($search) ?>">
            </div>
            <div class="col-md-3 mb-2">
                <select name="filter_agama" class="admin-form-control" style="color: #1E293B !important; font-weight: 600; background: white;">
                    <option value="" style="color: #64748B;">Semua Agama</option>
                    <option value="Islam" style="color: #1E293B;" <?= $filter_agama == 'Islam' ? 'selected' : '' ?>>Islam</option>
                    <option value="Kristen" style="color: #1E293B;" <?= $filter_agama == 'Kristen' ? 'selected' : '' ?>>Kristen</option>
                    <option value="Katolik" style="color: #1E293B;" <?= $filter_agama == 'Katolik' ? 'selected' : '' ?>>Katolik</option>
                    <option value="Hindu" style="color: #1E293B;" <?= $filter_agama == 'Hindu' ? 'selected' : '' ?>>Hindu</option>
                    <option value="Buddha" style="color: #1E293B;" <?= $filter_agama == 'Buddha' ? 'selected' : '' ?>>Buddha</option>
                    <option value="Konghucu" style="color: #1E293B;" <?= $filter_agama == 'Konghucu' ? 'selected' : '' ?>>Konghucu</option>
                </select>
            </div>
            <div class="col-md-2 mb-2">
                <button type="submit" class="admin-btn admin-btn-primary w-100">Cari</button>
            </div>
            <div class="col-md-3 mb-2">
                <a href="<?= base_url('admin/biodata') ?>" class="admin-btn admin-btn-secondary w-100">Reset</a>
            </div>
        </div>
    </form>

    <!-- Sorting Links -->
    <div class="mb-3 admin-sort-links">
        <span class="admin-sort-links-label">Urutkan:</span>
        <a href="<?= base_url('admin/biodata?sort_by=nama&sort_order=' . ($sort_by == 'nama' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_agama=' . urlencode($filter_agama)) ?>"
           class="<?= $sort_by == 'nama' ? 'active' : '' ?>">
            Nama <?= $sort_by == 'nama' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
        </a>
        <a href="<?= base_url('admin/biodata?sort_by=email&sort_order=' . ($sort_by == 'email' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_agama=' . urlencode($filter_agama)) ?>"
           class="<?= $sort_by == 'email' ? 'active' : '' ?>">
            Email <?= $sort_by == 'email' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
        </a>
        <a href="<?= base_url('admin/biodata?sort_by=tanggal_lahir&sort_order=' . ($sort_by == 'tanggal_lahir' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_agama=' . urlencode($filter_agama)) ?>"
           class="<?= $sort_by == 'tanggal_lahir' ? 'active' : '' ?>">
            Tanggal Lahir <?= $sort_by == 'tanggal_lahir' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
        </a>
    </div>
</div>

<div class="admin-card">
    <div class="table-responsive">
        <table class="admin-table">
<thead>
<tr>
    <th>#</th>
    <th>Nama</th>
    <th>Alamat</th>
    <th>Email</th>
    <th>No. HP</th>
    <th>Jenis Kelamin</th>
    <th>Agama</th>
    <th>Foto</th>
    <th>Action</th>
</tr>
</thead>
<tbody>
<?php 
$no = 1 + (10 * ($pager->getCurrentPage() - 1));
foreach($biodata as $bio): 
?>
<tr>
    <td><?= $no++ ?></td>
    <td><?= esc($bio['nama']) ?></td>
    <td><?= esc(substr($bio['alamat'], 0, 50)) ?>...</td>
    <td><?= esc($bio['email']) ?></td>
    <td><?= esc($bio['no_hp']) ?></td>
    <td><?= esc($bio['jenis_kelamin']) ?></td>
    <td><?= esc($bio['agama']) ?></td>
    <td>
        <?php if (!empty($bio['foto_profil'])): ?>
            <img src="<?= base_url($bio['foto_profil']) ?>" style="max-width: 50px; max-height: 50px;" alt="Foto">
        <?php else: ?>
            <span class="text-muted">-</span>
        <?php endif; ?>
    </td>
    <td>
        <div class="action-buttons">
            <a href="<?= base_url('biodata') ?>" class="admin-btn admin-btn-preview" target="_blank">Preview</a>
            <a href="<?= base_url('admin/biodata/'.$bio['id'].'/edit') ?>" class="admin-btn admin-btn-edit">Edit</a>
            <a href="<?= base_url('admin/biodata/'.$bio['id'].'/delete') ?>" onclick="return confirm('Yakin ingin menghapus data ini?');" class="admin-btn admin-btn-delete">Delete</a>
        </div>
    </td>
</tr>
<?php endforeach ?>
</tbody>
        </table>
    </div>
</div>

<!-- Pagination -->
<div class="mt-4">
    <?= $pager->links() ?>
</div>

<?= $this->endSection() ?>







