<?= $this->extend('layout/admin/admin_layout') ?>

<?= $this->section('content') ?>

<div class="admin-page-header">
    <h1>Data Aktivitas Harian</h1>
</div>

<div class="admin-card">
    <a href="<?= base_url('admin/activities/new') ?>" class="admin-btn admin-btn-primary mb-3">Tambah Aktivitas Baru</a>

    <?php if (session()->getFlashdata('message')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert" id="successAlert">
            <?= esc(session()->getFlashdata('message')) ?>
            <button type="button" class="btn-close" onclick="document.getElementById('successAlert').style.display='none'" aria-label="Close">&times;</button>
        </div>
    <?php endif; ?>

    <!-- Search and Filter Form -->
    <form method="get" action="<?= base_url('admin/activities') ?>" class="mb-4">
        <div class="row">
            <div class="col-md-4 mb-2">
                <input type="text" name="search" class="admin-form-control" placeholder="Cari aktivitas..." value="<?= esc($search) ?>">
            </div>
            <div class="col-md-3 mb-2">
                <input type="date" name="filter_tanggal" class="admin-form-control" value="<?= esc($filter_tanggal) ?>">
            </div>
            <div class="col-md-2 mb-2">
                <button type="submit" class="admin-btn admin-btn-primary w-100">Cari</button>
            </div>
            <div class="col-md-3 mb-2">
                <a href="<?= base_url('admin/activities') ?>" class="admin-btn admin-btn-secondary w-100">Reset</a>
            </div>
        </div>
    </form>

    <!-- Sorting Links -->
    <div class="mb-3 admin-sort-links">
        <span class="admin-sort-links-label">Urutkan:</span>
        <a href="<?= base_url('admin/activities?sort_by=tanggal&sort_order=' . ($sort_by == 'tanggal' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_tanggal=' . urlencode($filter_tanggal)) ?>"
           class="<?= $sort_by == 'tanggal' ? 'active' : '' ?>">
            Tanggal <?= $sort_by == 'tanggal' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
        </a>
        <a href="<?= base_url('admin/activities?sort_by=jam&sort_order=' . ($sort_by == 'jam' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_tanggal=' . urlencode($filter_tanggal)) ?>"
           class="<?= $sort_by == 'jam' ? 'active' : '' ?>">
            Jam <?= $sort_by == 'jam' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
        </a>
        <a href="<?= base_url('admin/activities?sort_by=nama_aktivitas&sort_order=' . ($sort_by == 'nama_aktivitas' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_tanggal=' . urlencode($filter_tanggal)) ?>"
           class="<?= $sort_by == 'nama_aktivitas' ? 'active' : '' ?>">
            Nama Aktivitas <?= $sort_by == 'nama_aktivitas' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
        </a>
    </div>
</div>

<div class="admin-card">
    <div class="table-responsive">
        <table class="admin-table">
<thead>
<tr>
    <th>#</th>
    <th>Tanggal</th>
    <th>Jam</th>
    <th>Nama Aktivitas</th>
    <th>Foto</th>
    <th>Video</th>
    <th>Action</th>
</tr>
</thead>
<tbody>
<?php 
$no = 1 + (10 * ($pager->getCurrentPage() - 1));
foreach($activities as $activity): 
?>
<tr>
    <td><?= $no++ ?></td>
    <td><?= date('d-m-Y', strtotime($activity['tanggal'])) ?></td>
    <td><?= date('H:i', strtotime($activity['jam'])) ?></td>
    <td><?= esc($activity['nama_aktivitas']) ?></td>
    <td>
        <?php if (!empty($activity['foto'])): ?>
            <img src="<?= base_url($activity['foto']) ?>" style="max-width: 100px; max-height: 100px;" alt="Foto">
        <?php else: ?>
            <span class="text-muted">-</span>
        <?php endif; ?>
    </td>
    <td>
        <?php if (!empty($activity['video'])): ?>
            <span class="text-success">✓ Ada</span>
        <?php else: ?>
            <span class="text-muted">-</span>
        <?php endif; ?>
    </td>
    <td>
        <div class="action-buttons">
            <a href="<?= base_url('activities') ?>" class="admin-btn admin-btn-preview" target="_blank">Preview</a>
            <a href="<?= base_url('admin/activities/'.$activity['id'].'/edit') ?>" class="admin-btn admin-btn-edit">Edit</a>
            <a href="<?= base_url('admin/activities/'.$activity['id'].'/delete') ?>" onclick="return confirm('Yakin ingin menghapus data ini?');" class="admin-btn admin-btn-delete">Delete</a>
        </div>
    </td>
</tr>
<?php endforeach ?>
</tbody>
        </table>
    </div>
</div>

<!-- Pagination -->
<div class="mt-4">
    <?= $pager->links() ?>
</div>

<?= $this->endSection() ?>



