<?= $this->extend('layout/admin/admin_layout') ?>

<?= $this->section('content') ?>

<div class="admin-page-header">
    <h1>Edit Riwayat Pendidikan</h1>
</div>

<div class="admin-card">
<form action="" method="post">
    <?php if (session()->getFlashdata('errors')): ?>
        <div class="alert alert-danger" role="alert">
            <ul class="mb-0">
                <?php foreach (session()->getFlashdata('errors') as $error): ?>
                    <li><?= esc($error) ?></li>
                <?php endforeach ?>
            </ul>
        </div>
    <?php endif; ?>

    <input type="hidden" name="id" value="<?= $education['id'] ?>">
    
    <div class="admin-form-group">
        <label for="jenjang">Jenjang *</label>
        <select name="jenjang" class="admin-form-control" required>
            <option value="">Pilih Jenjang</option>
            <option value="TK" <?= $education['jenjang'] == 'TK' ? 'selected' : '' ?>>TK</option>
            <option value="SD" <?= $education['jenjang'] == 'SD' ? 'selected' : '' ?>>SD</option>
            <option value="SMP" <?= $education['jenjang'] == 'SMP' ? 'selected' : '' ?>>SMP</option>
            <option value="SMA" <?= $education['jenjang'] == 'SMA' ? 'selected' : '' ?>>SMK</option>
            <option value="S1" <?= $education['jenjang'] == 'S1' ? 'selected' : '' ?>>S1</option>
            <option value="S2" <?= $education['jenjang'] == 'S2' ? 'selected' : '' ?>>S2</option>
            <option value="S3" <?= $education['jenjang'] == 'S3' ? 'selected' : '' ?>>S3</option>
        </select>
    </div>
    <div class="admin-form-group">
        <label for="nama_sekolah">Nama Sekolah/Universitas *</label>
        <input type="text" name="nama_sekolah" class="admin-form-control" value="<?= esc($education['nama_sekolah']) ?>" required>
    </div>
    <div class="admin-form-group">
        <label for="jurusan">Jurusan</label>
        <input type="text" name="jurusan" class="admin-form-control" value="<?= esc($education['jurusan']) ?>">
    </div>
    <div class="row">
        <div class="col-md-6">
            <div class="admin-form-group">
                <label for="tahun_mulai">Tahun Mulai</label>
                <input type="number" name="tahun_mulai" class="admin-form-control" value="<?= esc($education['tahun_mulai']) ?>" min="1900" max="2100">
            </div>
        </div>
        <div class="col-md-6">
            <div class="admin-form-group">
                <label for="tahun_selesai">Tahun Selesai</label>
                <input type="text" name="tahun_selesai" id="tahun_selesai" class="admin-form-control" value="<?= ($education['tahun_selesai'] == '9999' || $education['tahun_selesai'] == '0000') ? '' : esc($education['tahun_selesai']) ?>" maxlength="4" <?= ($education['tahun_selesai'] == '9999' || $education['tahun_selesai'] == '0000') ? 'readonly style="background-color: #f0f0f0;"' : '' ?>>
            </div>
            <div class="form-check" style="margin-top: 0.5rem;">
                <input class="form-check-input" type="checkbox" id="masih_aktif" <?= ($education['tahun_selesai'] == '9999' || $education['tahun_selesai'] == '0000') ? 'checked' : '' ?> style="cursor: pointer;">
                <label class="form-check-label" for="masih_aktif" style="cursor: pointer; font-weight: 600; color: var(--admin-primary);">
                    Masih Aktif/Sekolah Sekarang
                </label>
            </div>
        </div>
    </div>
    <div class="admin-form-group">
        <label for="ipk">IPK</label>
        <input type="number" name="ipk" class="admin-form-control" value="<?= esc($education['ipk']) ?>" step="0.01" min="0" max="4">
        <small class="text-muted d-block mt-1">Hanya untuk jenjang S1, S2, S3</small>
    </div>
    <div class="admin-form-group">
        <label for="keterangan">Keterangan</label>
        <textarea name="keterangan" class="admin-form-control" rows="3"><?= esc($education['keterangan']) ?></textarea>
    </div>
    <div class="admin-form-group d-flex gap-2">
        <button type="submit" class="admin-btn admin-btn-primary">Update</button>
        <a href="<?= base_url('admin/education') ?>" class="admin-btn admin-btn-secondary">Batal</a>
    </div>
</form>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const masihAktifCheckbox = document.getElementById('masih_aktif');
    const tahunSelesaiInput = document.getElementById('tahun_selesai');
    
    // Set initial value if checked
    if (masihAktifCheckbox.checked) {
        tahunSelesaiInput.value = '9999';
    }
    
    masihAktifCheckbox.addEventListener('change', function() {
        if (this.checked) {
            tahunSelesaiInput.value = '9999';
            tahunSelesaiInput.readOnly = true;
            tahunSelesaiInput.style.backgroundColor = '#f0f0f0';
        } else {
            tahunSelesaiInput.value = '';
            tahunSelesaiInput.readOnly = false;
            tahunSelesaiInput.style.backgroundColor = 'white';
        }
    });
});
</script>

<?= $this->endSection() ?>







