<?= $this->extend('layout/admin/admin_layout') ?>

<?= $this->section('content') ?>

<div class="admin-page-header">
    <h1>Tambah Biodata Baru</h1>
</div>

<div class="admin-card">
    <form action="" method="post" enctype="multipart/form-data">
        <?php if (session()->getFlashdata('errors')): ?>
            <div class="alert alert-danger" role="alert">
                <ul class="mb-0">
                    <?php foreach (session()->getFlashdata('errors') as $error): ?>
                        <li><?= esc($error) ?></li>
                    <?php endforeach ?>
                </ul>
            </div>
        <?php endif; ?>

        <div class="admin-form-group">
            <label for="nama">Nama *</label>
            <input type="text" name="nama" class="admin-form-control" placeholder="Nama lengkap" required>
        </div>
        <div class="admin-form-group">
            <label for="alamat">Alamat</label>
            <textarea name="alamat" class="admin-form-control" rows="3" placeholder="Alamat lengkap"></textarea>
        </div>
        <div class="row">
            <div class="col-md-6">
                <div class="admin-form-group">
                    <label for="tempat_lahir">Tempat Lahir</label>
                    <input type="text" name="tempat_lahir" class="admin-form-control" placeholder="Tempat lahir">
                </div>
            </div>
            <div class="col-md-6">
                <div class="admin-form-group">
                    <label for="tanggal_lahir">Tanggal Lahir</label>
                    <input type="date" name="tanggal_lahir" class="admin-form-control">
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-6">
                <div class="admin-form-group">
                    <label for="jenis_kelamin">Jenis Kelamin</label>
                    <select name="jenis_kelamin" class="admin-form-control">
                        <option value="">Pilih</option>
                        <option value="Laki-laki">Laki-laki</option>
                        <option value="Perempuan">Perempuan</option>
                    </select>
                </div>
            </div>
            <div class="col-md-6">
                <div class="admin-form-group">
                    <label for="agama">Agama</label>
                    <select name="agama" class="admin-form-control" style="color: #1E293B !important; font-weight: 600; background: white;">
                        <option value="" style="color: #64748B;">Pilih Agama</option>
                        <option value="Islam" style="color: #1E293B;">Islam</option>
                        <option value="Kristen" style="color: #1E293B;">Kristen</option>
                        <option value="Katolik" style="color: #1E293B;">Katolik</option>
                        <option value="Hindu" style="color: #1E293B;">Hindu</option>
                        <option value="Buddha" style="color: #1E293B;">Buddha</option>
                        <option value="Konghucu" style="color: #1E293B;">Konghucu</option>
                    </select>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-6">
                <div class="admin-form-group">
                    <label for="no_hp">No. HP</label>
                    <input type="text" name="no_hp" class="admin-form-control" placeholder="Nomor HP">
                </div>
            </div>
            <div class="col-md-6">
                <div class="admin-form-group">
                    <label for="email">Email</label>
                    <input type="email" name="email" class="admin-form-control" placeholder="Email">
                </div>
            </div>
        </div>
        <div class="admin-form-group">
            <label for="foto_profil">Foto Profil</label>
            <input type="file" name="foto_profil" class="admin-form-control" accept="image/*">
            <small class="text-muted d-block mt-1">Format: JPG, PNG, GIF (maks 5MB)</small>
        </div>
        <div class="admin-form-group">
            <label for="deskripsi">Deskripsi</label>
            <textarea name="deskripsi" class="admin-form-control" rows="5" placeholder="Deskripsi tentang diri"></textarea>
        </div>
        <div class="admin-form-group d-flex gap-2">
            <button type="submit" class="admin-btn admin-btn-primary">Simpan</button>
            <a href="<?= base_url('admin/biodata') ?>" class="admin-btn admin-btn-secondary">Batal</a>
        </div>
    </form>
</div>

<?= $this->endSection() ?>







