<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class UpdateEducationJenjang extends Migration
{
	public function up()
	{
		// Pastikan kolom jenjang di tabel education_history menerima nilai TK
		// (dan tetap mendukung jenjang lain yang sudah ada).
		// Sesuaikan ENUM dengan kondisi aktual database Anda jika diperlukan.
		$this->db->query("
			ALTER TABLE `education_history`
			CHANGE `jenjang` `jenjang`
			ENUM('TK','SD','SMP','SMA','S1','S2','S3')
			NOT NULL
		");
	}

	public function down()
	{
		// Kembalikan ke definisi awal (tanpa TK) jika diperlukan rollback.
		$this->db->query("
			ALTER TABLE `education_history`
			CHANGE `jenjang` `jenjang`
			ENUM('SD','SMP','SMA','S1','S2','S3')
			NOT NULL
		");
	}
}



