<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class DailyActivities extends Migration
{
	public function up()
	{
		// Membuat kolom/field untuk tabel daily_activities
		$this->forge->addField([
			'id'          => [
				'type'           => 'INT',
				'constraint'     => 11,
				'unsigned'       => true,
				'auto_increment' => true
			],
			'tanggal'       => [
				'type'           => 'DATE',
				'null'           => false
			],
			'jam'      => [
				'type'           => 'TIME',
				'null'           => false,
			],
			'nama_aktivitas' => [
				'type'           => 'VARCHAR',
				'constraint'     => '255',
				'null'           => false,
			],
			'foto'      => [
				'type'           => 'VARCHAR',
				'constraint'     => '255',
				'null'           => true,
			],
			'video'      => [
				'type'           => 'VARCHAR',
				'constraint'     => '255',
				'null'           => true,
			],
			'created_at DATETIME DEFAULT CURRENT_TIMESTAMP',
			'updated_at DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'
		]);

		// Membuat primary key
		$this->forge->addKey('id', TRUE);

		// Membuat tabel daily_activities
		$this->forge->createTable('daily_activities', TRUE);
	}

	//---------------------

	public function down()
	{
		// menghapus tabel daily_activities
		$this->forge->dropTable('daily_activities');
	}
}







