<?php namespace App\Controllers;

use \App\Models\EducationHistoryModel;
use CodeIgniter\Exceptions\PageNotFoundException;

class EducationAdmin extends BaseController
{
	public function index()
	{
		$model = new EducationHistoryModel();
		
		// Get search parameter
		$search = $this->request->getGet('search');
		
		// Get filter parameters
		$filter_jenjang = $this->request->getGet('filter_jenjang');
		
		// Get sorting parameters
		$sort_by = $this->request->getGet('sort_by') ?? 'tahun_mulai';
		$sort_order = $this->request->getGet('sort_order') ?? 'DESC';
		
		// Apply search
		if (!empty($search)) {
			$model->groupStart()
				->like('nama_sekolah', $search)
				->orLike('jurusan', $search)
				->groupEnd();
		}
		
		// Apply filter
		if (!empty($filter_jenjang)) {
			$model->where('jenjang', $filter_jenjang);
		}
		
		// Apply sorting
		$model->orderBy($sort_by, $sort_order);
		
		$data = [
			'educations' => $model->paginate(10),
			'pager' => $model->pager,
			'search' => $search,
			'filter_jenjang' => $filter_jenjang,
			'sort_by' => $sort_by,
			'sort_order' => $sort_order,
		];
		
		return view('admin/admin_list_education', $data);
	}

	//--------------------------------------------------------------------------

	public function preview($id)
	{
		$model = new EducationHistoryModel();
		$data['education'] = $model->where('id', $id)->first();
		
		if(!$data['education']){
			throw PageNotFoundException::forPageNotFound();
		}
		return view('admin/admin_view_education', $data);
	}

	//--------------------------------------------------------------------------

	public function create()
	{
		// lakukan validasi
		$validation = \Config\Services::validation();
		$validation->setRules([
			'jenjang'      => 'required',
			'nama_sekolah' => 'required|min_length[3]',
			'tahun_mulai'  => 'required|exact_length[4]|numeric',
			'tahun_selesai'=> 'required|exact_length[4]|numeric'
		]);
		
		$isDataValid = $validation->withRequest($this->request)->run();

		// jika data valid, simpan ke database
		if($isDataValid){
			$model = new EducationHistoryModel();
			$model->insert([
				"jenjang" => $this->request->getPost('jenjang'),
				"nama_sekolah" => $this->request->getPost('nama_sekolah'),
				"jurusan" => $this->request->getPost('jurusan'),
				"tahun_mulai" => $this->request->getPost('tahun_mulai'),
				"tahun_selesai" => $this->request->getPost('tahun_selesai'),
				"ipk" => $this->request->getPost('ipk'),
				"keterangan" => $this->request->getPost('keterangan')
			]);
			
			session()->setFlashdata('message', 'Riwayat pendidikan berhasil ditambahkan');
			return redirect('admin/education');
		} else {
			if ($this->request->getMethod() === 'post') {
				session()->setFlashdata('errors', $validation->getErrors());
			}
		}
		
		// tampilkan form create
		return view('admin/admin_create_education');
	}

	//--------------------------------------------------------------------------

	public function edit($id)
	{
		// ambil data yang akan diedit
		$model = new EducationHistoryModel();
		$data['education'] = $model->where('id', $id)->first();
		
		if (!$data['education']) {
			throw PageNotFoundException::forPageNotFound();
		}
		
		// lakukan validasi data
		$validation = \Config\Services::validation();
		$validation->setRules([
			'id' => 'required',
			'jenjang' => 'required',
			'nama_sekolah' => 'required|min_length[3]',
			'tahun_mulai'  => 'required|exact_length[4]|numeric',
			'tahun_selesai'=> 'required|exact_length[4]|numeric'
		]);
		
		$isDataValid = $validation->withRequest($this->request)->run();
		
		// jika data valid, maka simpan ke database
		if($isDataValid){
			$model->update($id, [
				"jenjang" => $this->request->getPost('jenjang'),
				"nama_sekolah" => $this->request->getPost('nama_sekolah'),
				"jurusan" => $this->request->getPost('jurusan'),
				"tahun_mulai" => $this->request->getPost('tahun_mulai'),
				"tahun_selesai" => $this->request->getPost('tahun_selesai'),
				"ipk" => $this->request->getPost('ipk'),
				"keterangan" => $this->request->getPost('keterangan')
			]);
			
			session()->setFlashdata('message', 'Riwayat pendidikan berhasil diperbarui');
			return redirect('admin/education');
		} else {
			if ($this->request->getMethod() === 'post') {
				session()->setFlashdata('errors', $validation->getErrors());
			}
		}

		// tampilkan form edit
		return view('admin/admin_edit_education', $data);
	}

	//--------------------------------------------------------------------------

	public function delete($id){
		$model = new EducationHistoryModel();
		$model->delete($id);
		return redirect('admin/education');
	}
}

