<?php

namespace App\Controllers;

use App\Models\BiodataModel;
use CodeIgniter\Exceptions\PageNotFoundException;

class Biodata extends BaseController
{
	public function index()
	{
		$model = new BiodataModel();
		
		// Get search parameter
		$search = $this->request->getGet('search');
		
		// Get filter parameters
		$filter_agama = $this->request->getGet('filter_agama');
		
		// Get sorting parameters
		$sort_by = $this->request->getGet('sort_by') ?? 'nama';
		$sort_order = $this->request->getGet('sort_order') ?? 'ASC';
		
		// Apply search
		if (!empty($search)) {
			$model->groupStart()
				->like('nama', $search)
				->orLike('alamat', $search)
				->orLike('email', $search)
				->groupEnd();
		}
		
		// Apply filter
		if (!empty($filter_agama)) {
			$model->where('agama', $filter_agama);
		}
		
		// Apply sorting
		$model->orderBy($sort_by, $sort_order);
		
		// Get paginated results (10 per page)
		$data = [
			'biodata' => $model->paginate(10),
			'pager' => $model->pager,
			'search' => $search,
			'filter_agama' => $filter_agama,
			'sort_by' => $sort_by,
			'sort_order' => $sort_order,
		];
		
		echo view('biodata', $data);
	}
}

